/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v7_1_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.internal.upgrade.v7_1_0.util.CommerceOrderTable;

/**
 * @author Riccardo Alberti
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderUpgradeProcess
	extends BaseCommerceServiceUpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		addColumn(
			CommerceOrderTable.class, CommerceOrderTable.TABLE_NAME,
			"commerceOrderTypeId", "LONG");

		runSQL(
			"update CommerceOrder set commerceOrderTypeId = 0 where " +
				"commerceOrderTypeId is NULL");
	}

}