/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShippingMethodEngineKeyException;
import com.liferay.commerce.exception.CommerceShippingMethodNameException;
import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.service.CommerceAddressRestrictionLocalService;
import com.liferay.commerce.service.base.CommerceShippingMethodLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceShippingMethod"}, service={AopService.class})
public class CommerceShippingMethodLocalServiceImpl
extends CommerceShippingMethodLocalServiceBaseImpl {
    @Reference
    private CommerceAddressRestrictionLocalService _commerceAddressRestrictionLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceAddressRestriction addCommerceAddressRestriction(long userId, long groupId, long commerceShippingMethodId, long countryId) throws PortalException {
        return this._commerceAddressRestrictionLocalService.addCommerceAddressRestriction(userId, groupId, CommerceShippingMethod.class.getName(), commerceShippingMethodId, countryId);
    }

    @Deprecated
    public CommerceAddressRestriction addCommerceAddressRestriction(long commerceShippingMethodId, long countryId, ServiceContext serviceContext) throws PortalException {
        return this.commerceShippingMethodLocalService.addCommerceAddressRestriction(serviceContext.getUserId(), serviceContext.getScopeGroupId(), commerceShippingMethodId, countryId);
    }

    public CommerceShippingMethod addCommerceShippingMethod(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String engineKey, File imageFile, double priority, String trackingURL) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        this._validate(nameMap, engineKey);
        long commerceShippingMethodId = this.counterLocalService.increment();
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.create(commerceShippingMethodId);
        commerceShippingMethod.setGroupId(groupId);
        commerceShippingMethod.setCompanyId(user.getCompanyId());
        commerceShippingMethod.setUserId(user.getUserId());
        commerceShippingMethod.setUserName(user.getFullName());
        commerceShippingMethod.setNameMap(nameMap);
        commerceShippingMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null) {
            commerceShippingMethod.setImageId(this.counterLocalService.increment());
        }
        commerceShippingMethod.setActive(active);
        commerceShippingMethod.setEngineKey(engineKey);
        commerceShippingMethod.setPriority(priority);
        commerceShippingMethod.setTrackingURL(trackingURL);
        commerceShippingMethod = (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
        if (imageFile != null) {
            this._imageLocalService.updateImage(commerceShippingMethod.getCompanyId(), commerceShippingMethod.getImageId(), imageFile);
        }
        return commerceShippingMethod;
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceShippingMethod deleteCommerceShippingMethod(CommerceShippingMethod commerceShippingMethod) throws PortalException {
        this.commerceShippingMethodPersistence.remove((BaseModel)commerceShippingMethod);
        if (commerceShippingMethod.getImageId() > 0L) {
            this._imageLocalService.deleteImage(commerceShippingMethod.getImageId());
        }
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethod.getCommerceShippingMethodId());
        return commerceShippingMethod;
    }

    @Override
    public CommerceShippingMethod deleteCommerceShippingMethod(long commerceShippingMethodId) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        return this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
    }

    public void deleteCommerceShippingMethods(long groupId) throws PortalException {
        List commerceShippingMethods = this.commerceShippingMethodPersistence.findByGroupId(groupId);
        for (CommerceShippingMethod commerceShippingMethod : commerceShippingMethods) {
            this.commerceShippingMethodLocalService.deleteCommerceShippingMethod(commerceShippingMethod);
        }
    }

    public CommerceShippingMethod fetchCommerceShippingMethod(long groupId, String engineKey) {
        return this.commerceShippingMethodPersistence.fetchByG_E(groupId, engineKey);
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long commerceShippingMethodId, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) {
        return this._commerceAddressRestrictionLocalService.getCommerceAddressRestrictions(CommerceShippingMethod.class.getName(), commerceShippingMethodId, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long commerceShippingMethodId) {
        return this._commerceAddressRestrictionLocalService.getCommerceAddressRestrictionsCount(CommerceShippingMethod.class.getName(), commerceShippingMethodId);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, boolean active, int start, int end, OrderByComparator<CommerceShippingMethod> orderByComparator) {
        return this.commerceShippingMethodPersistence.findByG_A(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, int start, int end, OrderByComparator<CommerceShippingMethod> orderByComparator) {
        return this.commerceShippingMethodPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceShippingMethod> getCommerceShippingMethods(long groupId, long countryId, boolean active) {
        return TransformUtil.transform((Collection)this.commerceShippingMethodPersistence.findByG_A(groupId, active), commerceShippingMethod -> {
            boolean restricted = this._commerceAddressRestrictionLocalService.isCommerceAddressRestricted(CommerceShippingMethod.class.getName(), commerceShippingMethod.getCommerceShippingMethodId(), countryId);
            if (!restricted) {
                return commerceShippingMethod;
            }
            return null;
        });
    }

    public int getCommerceShippingMethodsCount(long groupId) {
        return this.commerceShippingMethodPersistence.countByGroupId(groupId);
    }

    public int getCommerceShippingMethodsCount(long groupId, boolean active) {
        return this.commerceShippingMethodPersistence.countByG_A(groupId, active);
    }

    public CommerceShippingMethod setActive(long commerceShippingMethodId, boolean active) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        commerceShippingMethod.setActive(active);
        return (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
    }

    public CommerceShippingMethod updateCommerceShippingMethod(long commerceShippingMethodId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, File imageFile, double priority, String trackingURL) throws PortalException {
        CommerceShippingMethod commerceShippingMethod = this.commerceShippingMethodPersistence.findByPrimaryKey(commerceShippingMethodId);
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        commerceShippingMethod.setNameMap(nameMap);
        commerceShippingMethod.setDescriptionMap(descriptionMap);
        if (imageFile != null && commerceShippingMethod.getImageId() <= 0L) {
            commerceShippingMethod.setImageId(this.counterLocalService.increment());
        }
        commerceShippingMethod.setActive(active);
        commerceShippingMethod.setPriority(priority);
        commerceShippingMethod.setTrackingURL(trackingURL);
        commerceShippingMethod = (CommerceShippingMethod)this.commerceShippingMethodPersistence.update((BaseModel)commerceShippingMethod);
        if (imageFile != null) {
            this._imageLocalService.updateImage(commerceShippingMethod.getCompanyId(), commerceShippingMethod.getImageId(), imageFile);
        }
        return commerceShippingMethod;
    }

    private void _validate(Map<Locale, String> nameMap, String engineKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceShippingMethodNameException();
        }
        if (Validator.isNull((String)engineKey)) {
            throw new CommerceShippingMethodEngineKeyException();
        }
    }
}

