/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceOrderTypeDisplayDateException;
import com.liferay.commerce.exception.CommerceOrderTypeExpirationDateException;
import com.liferay.commerce.exception.CommerceOrderTypeNameException;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeRelTable;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.service.CommerceOrderTypeRelLocalService;
import com.liferay.commerce.service.base.CommerceOrderTypeLocalServiceBaseImpl;
import com.liferay.commerce.util.CommerceGroupThreadLocal;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceOrderType"}, service={AopService.class})
public class CommerceOrderTypeLocalServiceImpl
extends CommerceOrderTypeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderTypeLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceOrderTypeRelLocalService _commerceOrderTypeRelLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderType addCommerceOrderType(String externalReferenceCode, long userId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int displayOrder, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._validate(nameMap);
        long commerceOrderTypeId = this.counterLocalService.increment();
        CommerceOrderType commerceOrderType = this.commerceOrderTypePersistence.create(commerceOrderTypeId);
        commerceOrderType.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        commerceOrderType.setCompanyId(user.getCompanyId());
        commerceOrderType.setUserId(user.getUserId());
        commerceOrderType.setUserName(user.getFullName());
        commerceOrderType.setNameMap(nameMap);
        commerceOrderType.setDescriptionMap(descriptionMap);
        commerceOrderType.setActive(active);
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceOrderTypeDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceOrderTypeExpirationDateException.class);
        }
        commerceOrderType.setDisplayDate(displayDate);
        commerceOrderType.setDisplayOrder(displayOrder);
        commerceOrderType.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceOrderType.setStatus(2);
        } else {
            commerceOrderType.setStatus(3);
        }
        commerceOrderType.setStatusByUserId(user.getUserId());
        commerceOrderType.setStatusDate(serviceContext.getModifiedDate(date));
        commerceOrderType.setExpandoBridgeAttributes(serviceContext);
        commerceOrderType = (CommerceOrderType)this.commerceOrderTypePersistence.update((BaseModel)commerceOrderType);
        this._resourceLocalService.addModelResources((AuditedModel)commerceOrderType, serviceContext);
        return this._startWorkflowInstance(user.getUserId(), commerceOrderType, serviceContext);
    }

    public void checkCommerceOrderTypes() throws PortalException {
        this._checkCommerceOrderTypesByDisplayDate();
        this._checkCommerceOrderTypesByExpirationDate();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceOrderType deleteCommerceOrderType(CommerceOrderType commerceOrderType) throws PortalException {
        this.commerceOrderTypePersistence.remove((BaseModel)commerceOrderType);
        this._resourceLocalService.deleteResource(commerceOrderType.getCompanyId(), CommerceOrderType.class.getName(), 4, commerceOrderType.getCommerceOrderTypeId());
        this._commerceOrderTypeRelLocalService.deleteCommerceOrderTypeRels(commerceOrderType.getCommerceOrderTypeId());
        this._expandoRowLocalService.deleteRows(commerceOrderType.getCommerceOrderTypeId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrderType.getCompanyId(), 0L, CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId());
        return commerceOrderType;
    }

    @Override
    public CommerceOrderType deleteCommerceOrderType(long commerceOrderTypeId) throws PortalException {
        CommerceOrderType commerceOrderType = this.commerceOrderTypePersistence.findByPrimaryKey(commerceOrderTypeId);
        return this.commerceOrderTypeLocalService.deleteCommerceOrderType(commerceOrderType);
    }

    public List<CommerceOrderType> getCommerceOrderTypes(long companyId, String className, long classPK, boolean active, int start, int end) throws PortalException {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceOrderTypeTable.INSTANCE), companyId, className, classPK, active).orderBy(new OrderByExpression[]{CommerceOrderTypeTable.INSTANCE.displayOrder.ascending()}).limit(start, end));
    }

    public int getCommerceOrderTypesCount(long companyId, boolean active) {
        return this.commerceOrderTypePersistence.countByC_A(companyId, active);
    }

    public int getCommerceOrderTypesCount(long companyId, String className, long classPK, boolean active) throws PortalException {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId), companyId, className, classPK, active));
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderType updateCommerceOrderType(String externalReferenceCode, long userId, long commerceOrderTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int displayOrder, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._validate(nameMap);
        CommerceOrderType commerceOrderType = this.commerceOrderTypePersistence.findByPrimaryKey(commerceOrderTypeId);
        commerceOrderType.setExternalReferenceCode(externalReferenceCode);
        commerceOrderType.setNameMap(nameMap);
        commerceOrderType.setDescriptionMap(descriptionMap);
        commerceOrderType.setActive(active);
        Date date = new Date();
        User user = this._userLocalService.getUser(userId);
        commerceOrderType.setDisplayDate(this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceOrderTypeDisplayDateException.class));
        commerceOrderType.setDisplayOrder(displayOrder);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceOrderTypeExpirationDateException.class);
        }
        commerceOrderType.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceOrderType.setStatus(2);
        } else {
            commerceOrderType.setStatus(3);
        }
        commerceOrderType.setStatusByUserId(user.getUserId());
        commerceOrderType.setStatusDate(serviceContext.getModifiedDate(date));
        commerceOrderType.setExpandoBridgeAttributes(serviceContext);
        commerceOrderType = (CommerceOrderType)this.commerceOrderTypePersistence.update((BaseModel)commerceOrderType);
        return this._startWorkflowInstance(user.getUserId(), commerceOrderType, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderType updateCommerceOrderTypeExternalReferenceCode(String externalReferenceCode, long commerceOrderTypeId) throws PortalException {
        CommerceOrderType commerceOrderType = this.commerceOrderTypeLocalService.getCommerceOrderType(commerceOrderTypeId);
        commerceOrderType.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrderType)this.commerceOrderTypePersistence.update((BaseModel)commerceOrderType);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderType updateStatus(long userId, long commerceOrderTypeId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        CommerceOrderType commerceOrderType = this.commerceOrderTypePersistence.findByPrimaryKey(commerceOrderTypeId);
        Date date = new Date();
        if (status == 0 && commerceOrderType.getDisplayDate() != null && date.before(commerceOrderType.getDisplayDate())) {
            commerceOrderType.setActive(false);
            status = 7;
        }
        if (status == 0) {
            Date expirationDate = commerceOrderType.getExpirationDate();
            if (expirationDate != null && expirationDate.before(date)) {
                commerceOrderType.setExpirationDate(null);
            }
            if (commerceOrderType.getStatus() == 7) {
                commerceOrderType.setActive(true);
            }
        }
        if (status == 3) {
            commerceOrderType.setActive(false);
            commerceOrderType.setExpirationDate(date);
        }
        commerceOrderType.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        commerceOrderType.setStatusByUserId(user.getUserId());
        commerceOrderType.setStatusByUserName(user.getFullName());
        commerceOrderType.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceOrderType)this.commerceOrderTypePersistence.update((BaseModel)commerceOrderType);
    }

    private void _checkCommerceOrderTypesByDisplayDate() throws PortalException {
        List commerceOrderTypes = this.commerceOrderTypePersistence.findByLtD_S(new Date(), 7);
        for (CommerceOrderType commerceOrderType : commerceOrderTypes) {
            long userId = this._portal.getValidUserId(commerceOrderType.getCompanyId(), commerceOrderType.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceOrderTypeLocalService.updateStatus(userId, commerceOrderType.getCommerceOrderTypeId(), 0, serviceContext, new HashMap());
        }
    }

    private void _checkCommerceOrderTypesByExpirationDate() throws PortalException {
        List commerceOrderTypes = this.commerceOrderTypePersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceOrderTypes.size() + " commerce order types"));
        }
        for (CommerceOrderType commerceOrderType : commerceOrderTypes) {
            long userId = this._portal.getValidUserId(commerceOrderType.getCompanyId(), commerceOrderType.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceOrderTypeLocalService.updateStatus(userId, commerceOrderType.getCommerceOrderTypeId(), 3, serviceContext, new HashMap());
        }
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long companyId, String className, long classPK, boolean active) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)CommerceOrderTypeTable.INSTANCE).leftJoinOn((Table)CommerceOrderTypeRelTable.INSTANCE, CommerceOrderTypeRelTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId));
        return joinStep.where(() -> {
            Predicate predicate = CommerceOrderTypeTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)CommerceOrderTypeTable.INSTANCE.active.eq((Object)active));
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            Group group = CommerceGroupThreadLocal.get();
            if (permissionChecker != null && group != null) {
                predicate = predicate.and((Expression)this._inlineSQLHelper.getPermissionWherePredicate(CommerceOrderType.class.getName(), CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId, new long[]{group.getGroupId()}));
            }
            Predicate commerceOrderTypeRelPredicate = Predicate.withParentheses((Predicate)CommerceOrderTypeRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)).and((Expression)CommerceOrderTypeRelTable.INSTANCE.classPK.eq((Object)classPK)));
            commerceOrderTypeRelPredicate = commerceOrderTypeRelPredicate.or((Expression)CommerceOrderTypeRelTable.INSTANCE.commerceOrderTypeRelId.isNull()).withParentheses();
            return predicate.and((Expression)commerceOrderTypeRelPredicate);
        });
    }

    private CommerceOrderType _startWorkflowInstance(long userId, CommerceOrderType commerceOrderType, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceOrderType)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrderType.getCompanyId(), (long)0L, (long)userId, (String)CommerceOrderType.class.getName(), (long)commerceOrderType.getCommerceOrderTypeId(), (Object)commerceOrderType, (ServiceContext)serviceContext, workflowContext);
    }

    private void _validate(Map<Locale, String> nameMap) throws PortalException {
        if (nameMap == null || nameMap.isEmpty()) {
            throw new CommerceOrderTypeNameException();
        }
    }
}

