/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.util.CommerceQuantityFormatter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceQuantityFormatter.class})
public class CommerceQuantityFormatterImpl
implements CommerceQuantityFormatter {
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;

    public String format(BigDecimal quantity, Locale locale) {
        DecimalFormat decimalFormat = this._getDecimalFormat(locale);
        return decimalFormat.format(quantity);
    }

    public BigDecimal format(CPInstance cpInstance, BigDecimal quantity, String unitOfMeasureKey) {
        if (cpInstance == null) {
            return quantity.setScale(0, RoundingMode.HALF_UP);
        }
        return this._format(this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(cpInstance.getCPInstanceId(), unitOfMeasureKey), quantity);
    }

    public BigDecimal format(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, BigDecimal quantity) {
        return this._format(cpInstanceUnitOfMeasure, quantity);
    }

    public BigDecimal format(long cpInstanceId, BigDecimal quantity, String unitOfMeasureKey) {
        return this._format(this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(cpInstanceId, unitOfMeasureKey), quantity);
    }

    public BigDecimal format(long companyId, BigDecimal quantity, String sku, String unitOfMeasureKey) {
        return this._format(this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(companyId, unitOfMeasureKey, sku), quantity);
    }

    private BigDecimal _format(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, BigDecimal quantity) {
        if (quantity == null) {
            return null;
        }
        if (cpInstanceUnitOfMeasure != null) {
            return quantity.setScale(cpInstanceUnitOfMeasure.getPrecision(), RoundingMode.HALF_UP);
        }
        return quantity.setScale(0, RoundingMode.HALF_UP);
    }

    private DecimalFormat _getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00", DecimalFormatSymbols.getInstance(locale));
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setParseBigDecimal(true);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat;
    }
}

