/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v14_0_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Objects;

public class ObjectDefinitionUpgradeProcess
extends UpgradeProcess {
    private static final String _NEW_PK_OBJECT_FIELD_NAME = "CProductId";
    private static final String _OLD_PK_OBJECT_FIELD_NAME = "CPDefinitionId";
    private final CompanyLocalService _companyLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectDefinitionUpgradeProcess(CompanyLocalService companyLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._companyLocalService = companyLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode("L_COMMERCE_PRODUCT_DEFINITION", companyId.longValue());
            if (objectDefinition == null) {
                return;
            }
            objectDefinition.setPKObjectFieldDBColumnName(_NEW_PK_OBJECT_FIELD_NAME);
            objectDefinition.setPKObjectFieldName(_NEW_PK_OBJECT_FIELD_NAME);
            objectDefinition = this._objectDefinitionLocalService.updateObjectDefinition(objectDefinition);
            this._updateObjectField(_NEW_PK_OBJECT_FIELD_NAME, this._objectFieldLocalService.getObjectField(objectDefinition.getObjectDefinitionId(), "id"));
            this._updateObjectField(_NEW_PK_OBJECT_FIELD_NAME, this._objectFieldLocalService.getObjectField(objectDefinition.getObjectDefinitionId(), "productId"));
            this._updateDynamicObjectDefinitionTable(objectDefinition.getExtensionDBTableName(), "LONG not null", objectDefinition, _OLD_PK_OBJECT_FIELD_NAME);
            this._updateDynamicObjectDefinitionTable(objectDefinition.getLocalizationDBTableName(), "LONG not null", objectDefinition, _OLD_PK_OBJECT_FIELD_NAME);
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
            for (ObjectRelationship objectRelationship : objectRelationships) {
                String dbTableName = null;
                Object dbType = "LONG";
                String oldDBColumnName = null;
                if (Objects.equals(objectRelationship.getType(), "oneToOne") || Objects.equals(objectRelationship.getType(), "oneToMany")) {
                    ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
                    dbTableName = objectField.getDBTableName();
                    oldDBColumnName = objectField.getDBColumnName();
                    objectField.setName(this._replaceLast(objectField.getName()));
                    this._updateObjectField(this._replaceLast(objectField.getDBColumnName()), objectField);
                } else if (Objects.equals(objectRelationship.getType(), "manyToMany") && !objectRelationship.isReverse()) {
                    dbTableName = objectRelationship.getDBTableName();
                    dbType = (String)dbType + " not null";
                    oldDBColumnName = _OLD_PK_OBJECT_FIELD_NAME;
                }
                this._updateDynamicObjectDefinitionTable(dbTableName, (String)dbType, objectDefinition, oldDBColumnName);
            }
        });
    }

    private String _replaceLast(String name) {
        return StringUtil.replaceLast((String)name, (String)_OLD_PK_OBJECT_FIELD_NAME, (String)_NEW_PK_OBJECT_FIELD_NAME);
    }

    private void _updateDynamicObjectDefinitionTable(String dbTableName, String dbType, ObjectDefinition objectDefinition, String oldDBColumnName) throws Exception {
        if (dbTableName == null || !this.hasTable(dbTableName) || !this.hasColumn(dbTableName, oldDBColumnName)) {
            return;
        }
        this.runSQL(StringBundler.concat((String[])new String[]{"update ", dbTableName, " set ", oldDBColumnName, " = (select ", _NEW_PK_OBJECT_FIELD_NAME, " from ", objectDefinition.getDBTableName(), " where ", _OLD_PK_OBJECT_FIELD_NAME, " = ", dbTableName, ".", oldDBColumnName, ")"}));
        this.alterColumnName(dbTableName, oldDBColumnName, this._replaceLast(oldDBColumnName) + " " + dbType);
    }

    private void _updateObjectField(String dbColumnName, ObjectField objectField) {
        objectField.setDBColumnName(dbColumnName);
        this._objectFieldLocalService.updateObjectField(objectField);
    }
}

