/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v13_0_6;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;

public class CPDefinitionInventoryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        decimalFormat.setMaximumFractionDigits(0);
        String updateAllowedOrderQuantitiesSQL = "update CPDefinitionInventory set allowedOrderQuantities = ? where CPDefinitionInventoryId = ?";
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateAllowedOrderQuantitiesSQL);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s.executeQuery("select distinct CPDefinitionInventoryId, allowedOrderQuantities from CPDefinitionInventory");){
            while (resultSet.next()) {
                String allowedOrderQuantities = resultSet.getString("allowedOrderQuantities");
                if (!Validator.isNotNull((String)allowedOrderQuantities)) continue;
                allowedOrderQuantities = StringUtil.replace((String)allowedOrderQuantities, (char)',', (char)' ');
                allowedOrderQuantities = StringUtil.replace((String)allowedOrderQuantities, (char)'.', (char)' ');
                String[] allowedOrderQuantitiesParts = allowedOrderQuantities.split(" ");
                StringBundler sb = new StringBundler(allowedOrderQuantitiesParts.length * 2);
                for (String allowedOrderQuantitiesPart : allowedOrderQuantitiesParts) {
                    sb.append(decimalFormat.format(GetterUtil.getDouble((String)allowedOrderQuantitiesPart)));
                    sb.append(" ");
                }
                allowedOrderQuantities = sb.toString();
                preparedStatement.setString(1, allowedOrderQuantities.trim());
                preparedStatement.setLong(2, resultSet.getLong("CPDefinitionInventoryId"));
                preparedStatement.execute();
            }
            preparedStatement.executeBatch();
        }
    }
}

