/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v11_4_2;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class OperationsManagerRoleUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(OperationsManagerRoleUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public OperationsManagerRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._updateOperationsManagerPermissions(company.getCompanyId());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private void _updateOperationsManagerPermissions(long companyId) throws PortalException {
        Role operationsManagerRole = this._roleLocalService.fetchRole(companyId, "Operations Manager");
        if (operationsManagerRole != null && !this._resourcePermissionLocalService.hasResourcePermission(companyId, "com.liferay.commerce.product", 1, String.valueOf(companyId), operationsManagerRole.getRoleId(), "ADD_DOCUMENT")) {
            this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.product", 1, String.valueOf(companyId), operationsManagerRole.getRoleId(), "MANAGE_COMMERCE_PRODUCT_MEASUREMENT_UNITS");
        }
    }
}

