/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.servlet.filter;

import com.liferay.commerce.util.CommerceGroupThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"servlet-context-name=", "servlet-filter-name=Commerce Context Filter", "url-pattern=/o/frontend-taglib-clay/app/*", "url-pattern=/o/headless-batch-engine/*", "url-pattern=/o/headless-commerce-admin-account/*", "url-pattern=/o/headless-commerce-admin-catalog/*", "url-pattern=/o/headless-commerce-admin-channel/*", "url-pattern=/o/headless-commerce-admin-inventory/*", "url-pattern=/o/headless-commerce-admin-order/*", "url-pattern=/o/headless-commerce-admin-pricing/*", "url-pattern=/o/headless-commerce-admin-shipment/*", "url-pattern=/o/headless-commerce-admin-site-setting/*", "url-pattern=/o/headless-commerce-delivery-cart/*", "url-pattern=/o/headless-commerce-delivery-catalog/*", "url-pattern=/o/headless-commerce-machine-learning/*", "url-pattern=/o/headless-commerce-punchout/*"}, service={Filter.class})
public class CommerceContextFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(CommerceContextFilter.class);
    @Reference
    private GroupLocalService _groupLocalService;

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        try {
            HttpSession httpSession = httpServletRequest.getSession();
            long groupId = GetterUtil.getLong((Object)httpSession.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT"));
            CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(groupId));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

