/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceShipment"}, service={ModelPreFilterContributor.class})
public class CommerceShipmentModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByCommerceAccountIds(booleanFilter, searchContext);
        this._filterByCommerceOrderIds(booleanFilter, searchContext);
        this._filterByShipmentStatuses(booleanFilter, searchContext);
    }

    private void _filterByCommerceAccountIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] commerceAccountIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountIds"), null);
        if (commerceAccountIds != null) {
            BooleanFilter commerceAccountIdBooleanFilter = new BooleanFilter();
            for (long commerceAccountId : commerceAccountIds) {
                commerceAccountIdBooleanFilter.add((Filter)new TermFilter("commerceAccountId", String.valueOf(commerceAccountId)), BooleanClauseOccur.SHOULD);
            }
            commerceAccountIdBooleanFilter.add((Filter)new MissingFilter("commerceAccountId"), BooleanClauseOccur.SHOULD);
            booleanFilter.add((Filter)commerceAccountIdBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByCommerceOrderIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] commerceOrderIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceOrderIds"), null);
        if (commerceOrderIds != null && commerceOrderIds.length > 0) {
            BooleanFilter commerceOrderItemIdsBooleanFilter = new BooleanFilter();
            for (long commerceOrderId : commerceOrderIds) {
                commerceOrderItemIdsBooleanFilter.add((Filter)new TermFilter("commerceOrderIds", String.valueOf(commerceOrderId)), BooleanClauseOccur.SHOULD);
            }
            booleanFilter.add((Filter)commerceOrderItemIdsBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByShipmentStatuses(BooleanFilter booleanFilter, SearchContext searchContext) {
        int[] shipmentStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("shipmentStatuses"), null);
        if (shipmentStatuses != null) {
            BooleanFilter shipmentStatusesBooleanFilter = new BooleanFilter();
            int[] nArray = shipmentStatuses;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long shipmentStatus = nArray[i];
                shipmentStatusesBooleanFilter.add((Filter)new TermFilter("status", String.valueOf(shipmentStatus)), BooleanClauseOccur.SHOULD);
            }
            shipmentStatusesBooleanFilter.add((Filter)new MissingFilter("status"), BooleanClauseOccur.SHOULD);
            if (GetterUtil.getBoolean((Object)searchContext.getAttribute("negateShipmentStatuses"))) {
                booleanFilter.add((Filter)shipmentStatusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
            } else {
                booleanFilter.add((Filter)shipmentStatusesBooleanFilter, BooleanClauseOccur.MUST);
            }
        }
    }
}

