/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={ModelDocumentContributor.class})
public class CommerceOrderModelDocumentContributor
implements ModelDocumentContributor<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelDocumentContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, CommerceOrder commerceOrder) {
        block16: {
            try {
                Date requestedDeliveryDate;
                AccountEntry accountEntry;
                document.setSortableTextFields((String[])ArrayUtil.append((Object[])PropsUtil.getArray((String)"index.sortable.text.fields"), (Object[])new String[]{"name", "userName", "accountName", "commerceOrderTypeExternalReferenceCode", "externalReferenceCode", "purchaseOrderNumber"}));
                document.addNumberSortable("entryClassPK", Long.valueOf(commerceOrder.getCommerceOrderId()));
                document.addKeyword("name", commerceOrder.getName(), true);
                document.addKeyword("status", commerceOrder.getStatus());
                User user = this._userLocalService.fetchUser(commerceOrder.getUserId());
                if (user != null) {
                    document.addKeyword("userName", user.getFullName(), true);
                }
                if ((accountEntry = this._accountEntryLocalService.fetchAccountEntry(commerceOrder.getCommerceAccountId())) != null) {
                    document.addKeyword("accountName", accountEntry.getName(), true);
                }
                Address address = null;
                if (!commerceOrder.isOpen()) {
                    address = this._addressLocalService.fetchAddress(commerceOrder.getShippingAddressId());
                }
                if (address != null) {
                    document.addKeyword("addressName", address.getName());
                }
                document.addKeyword("advanceStatus", commerceOrder.getAdvanceStatus());
                if (address != null) {
                    document.addKeyword("city", address.getCity());
                }
                document.addKeyword("commerceAccountId", commerceOrder.getCommerceAccountId());
                document.addNumberSortable("commerceAccountId", Long.valueOf(commerceOrder.getCommerceAccountId()));
                CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
                document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
                CommerceOrderType commerceOrderType = this._commerceOrderTypeLocalService.fetchCommerceOrderType(commerceOrder.getCommerceOrderTypeId());
                if (commerceOrderType != null) {
                    document.addKeyword("commerceOrderTypeExternalReferenceCode", commerceOrderType.getExternalReferenceCode(), true);
                }
                document.addKeyword("commerceOrderTypeId", commerceOrder.getCommerceOrderTypeId());
                if (commerceOrderType != null) {
                    document.addLocalizedKeyword("commerceOrderTypeName", commerceOrderType.getNameMap(), false, true);
                }
                if (address != null) {
                    Country country = address.getCountry();
                    document.addKeyword("countryIsoCode", country.getA2());
                    document.addKeyword("countryName", country.getName());
                }
                document.addKeyword("externalReferenceCode", commerceOrder.getExternalReferenceCode(), true);
                document.addNumber("itemsQuantity", this._getItemsQuantity(commerceOrder));
                if (user != null) {
                    document.addKeyword("orderCreatorEmailAddress", user.getEmailAddress());
                    document.addKeyword("orderCreatorUserId", user.getUserId());
                }
                document.addDate("orderDate", commerceOrder.getOrderDate());
                document.addDateSortable("orderDate", commerceOrder.getOrderDate());
                document.addKeyword("orderItemNames", this._getCommerceOrderItemNames(commerceOrder));
                document.addKeyword("orderStatus", commerceOrder.getOrderStatus());
                document.addNumber("paymentStatus", commerceOrder.getPaymentStatus());
                document.addKeyword("purchaseOrderNumber", commerceOrder.getPurchaseOrderNumber());
                if (address != null) {
                    Region region = address.getRegion();
                    document.addKeyword("regionName", region.getName());
                }
                if ((requestedDeliveryDate = commerceOrder.getRequestedDeliveryDate()) != null) {
                    document.addDate("requestedDeliveryDate", requestedDeliveryDate);
                    document.addDateSortable("requestedDeliveryDate", requestedDeliveryDate);
                }
                if (address != null) {
                    document.addKeyword("shippingAddressExternalReference", address.getExternalReferenceCode());
                }
                document.addKeyword("sku", this._getCommerceOrderItemSKUs(commerceOrder));
                if (address != null) {
                    document.addKeyword("street1", address.getStreet1());
                    document.addKeyword("street2", address.getStreet2());
                    document.addKeyword("street3", address.getStreet3());
                }
                document.addNumber("total", commerceOrder.getTotal());
                document.addNumber("totalAmount", this._getTotalAmount(commerceOrder));
                if (address != null) {
                    document.addKeyword("zip", address.getZip());
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)("Unable to index commerce order " + commerceOrder.getCommerceOrderId()), (Throwable)exception);
            }
        }
    }

    private String[] _getCommerceOrderItemNames(CommerceOrder commerceOrder) {
        ArrayList<String> commerceOrderItemNamesList = new ArrayList<String>();
        for (Locale locale : this._language.getAvailableLocales(commerceOrder.getGroupId())) {
            for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
                String commerceOrderItemName = commerceOrderItem.getName(locale);
                if (Validator.isNull((String)commerceOrderItemName)) {
                    commerceOrderItemName = this._localization.getDefaultLanguageId(commerceOrderItem.getName());
                }
                commerceOrderItemNamesList.add(commerceOrderItemName);
            }
        }
        return commerceOrderItemNamesList.toArray(new String[0]);
    }

    private String[] _getCommerceOrderItemSKUs(CommerceOrder commerceOrder) {
        ArrayList<String> commerceOrderItemSKUsList = new ArrayList<String>();
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            commerceOrderItemSKUsList.add(commerceOrderItem.getSku());
        }
        return commerceOrderItemSKUsList.toArray(new String[0]);
    }

    private BigDecimal _getItemsQuantity(CommerceOrder commerceOrder) {
        BigDecimal count = BigDecimal.ZERO;
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            count = count.add(commerceOrderItem.getQuantity());
        }
        return count;
    }

    private double _getTotalAmount(CommerceOrder commerceOrder) throws PortalException {
        CommerceMoney commerceOrderTotalCommerceMoney = commerceOrder.getTotalMoney();
        BigDecimal commerceOrderTotalValue = commerceOrderTotalCommerceMoney.getPrice();
        return commerceOrderTotalValue.doubleValue();
    }
}

