/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.configuration.CommerceOrderFieldsConfiguration;
import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItemModel;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=21", "commerce.order.status.priority:Integer=20"}, service={CommerceOrderStatus.class})
public class QuoteRequestedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 21;
    public static final int PRIORITY = 20;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(21);
        commerceOrder = secure ? this._commerceOrderService.updateCommerceOrder(commerceOrder) : this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return commerceOrder;
    }

    public int getKey() {
        return 21;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)21));
    }

    public int getPriority() {
        return 20;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isOpen() && this._isRequestQuoteEnabled(commerceOrder)) {
            return true;
        }
        return commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        if (currentCommerceOrderStatus.getKey() == 6 || currentCommerceOrderStatus.getKey() == 2) {
            if (!this._commerceOrderValidatorRegistry.isValid(LocaleUtil.getSiteDefault(), commerceOrder)) {
                return false;
            }
            return this._isRequestQuoteEnabled(commerceOrder);
        }
        return false;
    }

    private boolean _isRequestQuoteEnabled(CommerceOrder commerceOrder) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        CommerceOrderFieldsConfiguration commerceOrderFieldsConfiguration = (CommerceOrderFieldsConfiguration)this._configurationProvider.getConfiguration(CommerceOrderFieldsConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.order.fields"));
        if (commerceOrderFieldsConfiguration.requestQuoteEnabled()) {
            return true;
        }
        return ListUtil.exists((List)commerceOrder.getCommerceOrderItems(), CommerceOrderItemModel::isPriceOnApplication);
    }
}

