/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.helper.CommerceShippingHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=0", "commerce.order.status.priority:Integer=70"}, service={CommerceOrderStatus.class})
public class CompletedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 0;
    public static final int PRIORITY = 70;
    @Reference
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(0);
        commerceOrder = secure ? this._commerceOrderService.updateCommerceOrder(commerceOrder) : this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return commerceOrder;
    }

    public int getKey() {
        return 0;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)0));
    }

    public int getPriority() {
        return 70;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        return !commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return commerceOrder.getOrderStatus() == 15 || commerceOrder.getOrderStatus() == 10 && !this._commerceShippingHelper.isShippable(commerceOrder);
    }
}

