/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.availability.CPAvailabilityChecker;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.order.validator.key=availability", "commerce.order.validator.priority:Integer=20"}, service={CommerceOrderValidator.class})
public class AvailabilityCommerceOrderValidatorImpl
implements CommerceOrderValidator {
    public static final String KEY = "availability";
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CPAvailabilityChecker _cpAvailabilityChecker;
    @Reference
    private Language _language;

    public String getKey() {
        return KEY;
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrder commerceOrder, CPInstance cpInstance, String json, BigDecimal quantity, boolean child) throws PortalException {
        if (!this._cpAvailabilityChecker.isPurchasable(cpInstance)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        if (!this._cpAvailabilityChecker.isAvailable(commerceOrder.getCommerceAccountId(), commerceOrder.getGroupId(), cpInstance, "", quantity)) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-specified-quantity-is-unavailable"));
        }
        return new CommerceOrderValidatorResult(true);
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrderItem commerceOrderItem) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (!this._cpAvailabilityChecker.isPurchasable(cpInstance)) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getCommerceInventoryBookedQuantityId());
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        BigDecimal quantity = commerceOrderItem.getQuantity();
        if (commerceInventoryBookedQuantity == null && !this._cpAvailabilityChecker.isAvailable(commerceOrder.getCommerceAccountId(), commerceOrderItem.getGroupId(), cpInstance, commerceOrderItem.getUnitOfMeasureKey(), quantity)) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-specified-quantity-is-unavailable"));
        }
        if (commerceInventoryBookedQuantity != null && !BigDecimalUtil.eq((BigDecimal)quantity, (BigDecimal)commerceInventoryBookedQuantity.getQuantity())) {
            BigDecimal bookedQuantity = BigDecimal.ZERO;
            BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryBookedQuantity.getQuantity();
            if (commerceInventoryWarehouseItemQuantity != null) {
                bookedQuantity = commerceInventoryWarehouseItemQuantity;
            }
            if (!BigDecimalUtil.eq((BigDecimal)commerceOrderItem.getQuantity(), (BigDecimal)bookedQuantity)) {
                return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-specified-quantity-is-not-allowed"));
            }
        }
        return new CommerceOrderValidatorResult(true);
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, key);
    }
}

