/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.deployer;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.internal.notification.term.evaluator.CommerceOrderAccountNotificationTermEvaluator;
import com.liferay.commerce.internal.notification.term.evaluator.CommerceOrderAddressNotificationTermEvaluator;
import com.liferay.commerce.internal.notification.term.evaluator.CommerceOrderItemsNotificationTermEvaluator;
import com.liferay.commerce.internal.notification.term.evaluator.SalesAgentNotificationTermEvaluator;
import com.liferay.commerce.internal.notification.term.provider.CommerceOrderAccountNotificationTermProvider;
import com.liferay.commerce.internal.notification.term.provider.CommerceOrderAddressNotificationTermProvider;
import com.liferay.commerce.internal.notification.term.provider.CommerceOrderItemsNotificationTermProvider;
import com.liferay.commerce.internal.notification.term.provider.SalesAgentNotificationTermProvider;
import com.liferay.commerce.internal.notification.type.ObjectDefinitionCommerceNotificationType;
import com.liferay.commerce.internal.order.term.contributor.ObjectCommerceDefinitionTermContributor;
import com.liferay.commerce.internal.order.term.contributor.ObjectRecipientCommerceDefinitionTermContributor;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.helper.CPInstanceHelper;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.provider.NotificationTermProvider;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ObjectDefinitionDeployer.class})
public class ObjectDefinitionDeployerImpl
implements ObjectDefinitionDeployer {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    private BundleContext _bundleContext;
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommerceOrderItemQuantityFormatter _commerceOrderItemQuantityFormatter;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private Language _language;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<ServiceRegistration<?>> deploy(ObjectDefinition objectDefinition) {
        if (StringUtil.equalsIgnoreCase((String)"CommerceOrder", (String)objectDefinition.getShortName())) {
            return Arrays.asList(this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new CommerceOrderAccountNotificationTermEvaluator(this._commerceOrderLocalService, objectDefinition), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new CommerceOrderAddressNotificationTermEvaluator(this._commerceOrderLocalService, objectDefinition), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new CommerceOrderItemsNotificationTermEvaluator(this._commerceMediaResolver, this._commerceMoneyFactory, this._commerceOrderItemQuantityFormatter, this._commerceOrderLocalService, this._commerceOrderPriceCalculation, this._companyLocalService, this._cpDefinitionLocalService, this._cpInstanceUnitOfMeasureLocalService, this._cpInstanceHelper, this._language, objectDefinition, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new SalesAgentNotificationTermEvaluator(this._accountEntryModelResourcePermission, this._commerceOrderLocalService, objectDefinition, this._permissionCheckerFactory, this._roleLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermProvider.class, (Object)new CommerceOrderAccountNotificationTermProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermProvider.class, (Object)new CommerceOrderAddressNotificationTermProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermProvider.class, (Object)new CommerceOrderItemsNotificationTermProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()), this._bundleContext.registerService(NotificationTermProvider.class, (Object)new SalesAgentNotificationTermProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build()));
        }
        if (objectDefinition.isUnmodifiableSystemObject() || Objects.equals(objectDefinition.getScope(), "company")) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._bundleContext.registerService(CommerceNotificationType.class, (Object)new ObjectDefinitionCommerceNotificationType("create", objectDefinition.getClassName() + "#create", objectDefinition.getShortName()), (Dictionary)HashMapDictionaryBuilder.put((Object)"commerce.notification.type.key", (Object)(objectDefinition.getClassName() + "#create")).build()), this._bundleContext.registerService(CommerceNotificationType.class, (Object)new ObjectDefinitionCommerceNotificationType("delete", objectDefinition.getClassName() + "#delete", objectDefinition.getShortName()), (Dictionary)HashMapDictionaryBuilder.put((Object)"commerce.notification.type.key", (Object)(objectDefinition.getClassName() + "#delete")).build()), this._bundleContext.registerService(CommerceNotificationType.class, (Object)new ObjectDefinitionCommerceNotificationType("update", objectDefinition.getClassName() + "#update", objectDefinition.getShortName()), (Dictionary)HashMapDictionaryBuilder.put((Object)"commerce.notification.type.key", (Object)(objectDefinition.getClassName() + "#update")).build()), this._bundleContext.registerService(CommerceDefinitionTermContributor.class, (Object)new ObjectCommerceDefinitionTermContributor(objectDefinition.getObjectDefinitionId(), this._objectFieldLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"commerce.definition.term.contributor.key", (Object)"BodyAndSubjectTerms").put((Object)"commerce.notification.type.key", (Object)new String[]{objectDefinition.getClassName() + "#create", objectDefinition.getClassName() + "#delete", objectDefinition.getClassName() + "#update"}).build()), this._bundleContext.registerService(CommerceDefinitionTermContributor.class, (Object)new ObjectRecipientCommerceDefinitionTermContributor(objectDefinition.getObjectDefinitionId(), this._objectFieldLocalService, this._userGroupLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"commerce.definition.term.contributor.key", (Object)"RecipientTerms").put((Object)"commerce.notification.type.key", (Object)new String[]{objectDefinition.getClassName() + "#create", objectDefinition.getClassName() + "#delete", objectDefinition.getClassName() + "#update"}).build()));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }
}

