/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelListener.class);
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterCreate((BaseModel)objectEntry);
        this._sendNotifications("create", objectEntry);
        this._updateCommerceReturnItemResourcePermissions(objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterRemove((BaseModel)objectEntry);
        this._sendNotifications("delete", objectEntry);
        this._removeCommerceReturnItemDiscussion(objectEntry);
        this._updateCommerceReturn(objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        super.onAfterUpdate((BaseModel)originalObjectEntry, (BaseModel)objectEntry);
        this._sendNotifications("update", objectEntry);
        this._updateCommerceReturn(originalObjectEntry);
    }

    private void _removeCommerceReturnItemDiscussion(ObjectEntry objectEntry) {
        block3: {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
            if (!StringUtil.equals((String)objectDefinition.getName(), (String)"CommerceReturnItem")) {
                return;
            }
            try {
                this._commentManager.deleteDiscussion(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private void _sendNotifications(String action, ObjectEntry objectEntry) {
        block3: {
            try {
                CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(objectEntry.getGroupId());
                if (commerceChannel == null) {
                    return;
                }
                ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
                this._commerceNotificationHelper.sendNotifications(commerceChannel.getGroupId(), objectEntry.getUserId(), objectDefinition.getClassName() + "#" + action, (Object)objectEntry);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private void _updateCommerceReturn(ObjectEntry originalObjectEntry) {
        block4: {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(originalObjectEntry.getObjectDefinitionId());
            if (!StringUtil.equals((String)objectDefinition.getName(), (String)"CommerceReturnItem")) {
                return;
            }
            Map values = originalObjectEntry.getValues();
            ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(GetterUtil.getLong(values.get("r_commerceReturnToCommerceReturnItems_l_commerceReturnId")));
            if (objectEntry == null) {
                return;
            }
            try {
                this._objectEntryLocalService.updateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), objectEntry.getValues(), new ServiceContext());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private void _updateCommerceReturnItemResourcePermissions(ObjectEntry objectEntry) {
        block4: {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
            if (!StringUtil.equals((String)objectDefinition.getName(), (String)"CommerceReturnItem")) {
                return;
            }
            Role role = this._roleLocalService.fetchRole(objectEntry.getCompanyId(), "Owner");
            if (role == null) {
                return;
            }
            try {
                this._resourcePermissionLocalService.removeResourcePermission(objectEntry.getCompanyId(), objectDefinition.getClassName(), 4, String.valueOf(objectEntry.getObjectEntryId()), role.getRoleId(), "DELETE_DISCUSSION");
                this._resourcePermissionLocalService.removeResourcePermission(objectEntry.getCompanyId(), objectDefinition.getClassName(), 4, String.valueOf(objectEntry.getObjectEntryId()), role.getRoleId(), "UPDATE_DISCUSSION");
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)portalException);
            }
        }
    }
}

