/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.service.CPDAvailabilityEstimateLocalService;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalService;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CProductModelListener
extends BaseModelListener<CProduct> {
    @Reference
    private CPDAvailabilityEstimateLocalService _cpdAvailabilityEstimateLocalService;
    @Reference
    private SiteNavigationMenuItemLocalService _siteNavigationMenuItemLocalService;

    public void onAfterUpdate(CProduct originalCProduct, CProduct cProduct) {
        if (Objects.equals(originalCProduct.getExternalReferenceCode(), cProduct.getExternalReferenceCode())) {
            return;
        }
        this._updateSiteNavigationMenuItem(cProduct.getExternalReferenceCode(), originalCProduct.getExternalReferenceCode());
    }

    public void onBeforeRemove(CProduct cProduct) {
        this._cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimateByCProductId(cProduct.getCProductId());
    }

    private void _updateSiteNavigationMenuItem(String externalReferenceCode, String originalExternalReferenceCode) {
        List siteNavigationMenuItems = this._siteNavigationMenuItemLocalService.getSiteNavigationMenuItems(CPDefinition.class.getName());
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)siteNavigationMenuItem.getTypeSettings()).build();
            String productNavigationMenuItemExternalReferenceCode = unicodeProperties.getProperty("externalReferenceCode");
            if (!Objects.equals(originalExternalReferenceCode, productNavigationMenuItemExternalReferenceCode)) continue;
            unicodeProperties.setProperty("externalReferenceCode", externalReferenceCode);
            siteNavigationMenuItem.setTypeSettings(unicodeProperties.toString());
            this._siteNavigationMenuItemLocalService.updateSiteNavigationMenuItem(siteNavigationMenuItem);
        }
    }
}

