/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.helper;

import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.manager.CurrentAccountEntryManager;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.configuration.CommerceAccountServiceConfiguration;
import com.liferay.commerce.helper.CommerceAccountHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRelModel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceAccountHelper.class})
public class CommerceAccountHelperImpl
implements CommerceAccountHelper {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CurrentAccountEntryManager _currentAccountEntryManager;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long userId, long[] roleIds, ServiceContext serviceContext) throws PortalException {
        AccountEntryUserRel accountEntryUserRel = this.addAccountEntryUserRel(accountEntryId, userId, serviceContext);
        if (roleIds != null) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            Group group = accountEntry.getAccountEntryGroup();
            if (group == null) {
                throw new PortalException();
            }
            this._userGroupRoleLocalService.addUserGroupRoles(userId, group.getGroupId(), roleIds);
        }
        return accountEntryUserRel;
    }

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long userId, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (accountEntry.isPersonalAccount()) {
            List accountEntryUserRels = this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(userId);
            for (AccountEntryUserRel accountEntryUserRel : accountEntryUserRels) {
                AccountEntry curAccountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryUserRel.getAccountEntryId());
                if (!curAccountEntry.isPersonalAccount()) continue;
                throw new AccountEntryTypeException();
            }
        }
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, userId);
        this.addDefaultRoles(userId);
        return accountEntryUserRel;
    }

    public void addAccountEntryUserRels(long accountEntryId, long[] userIds, String[] emailAddresses, long[] roleIds, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        Group group = accountEntry.getAccountEntryGroup();
        if (group == null) {
            throw new PortalException();
        }
        if (userIds != null) {
            for (long userId : userIds) {
                User user = this._userLocalService.getUser(userId);
                this.addAccountEntryUserRel(accountEntryId, user.getUserId(), serviceContext);
                if (!ArrayUtil.contains((long[])user.getGroupIds(), (long)group.getGroupId())) {
                    this._userLocalService.addGroupUsers(group.getGroupId(), new long[]{userId});
                }
                if (!ArrayUtil.contains((long[])user.getGroupIds(), (long)serviceContext.getScopeGroupId())) {
                    this._userLocalService.addGroupUsers(serviceContext.getScopeGroupId(), new long[]{userId});
                }
                if (roleIds == null) continue;
                this._userGroupRoleLocalService.addUserGroupRoles(user.getUserId(), group.getGroupId(), roleIds);
            }
        }
        if (emailAddresses != null) {
            for (String emailAddress : emailAddresses) {
                this._accountEntryUserRelLocalService.inviteUser(accountEntryId, roleIds, emailAddress, this._userLocalService.getUser(accountEntry.getUserId()), serviceContext);
            }
        }
    }

    public void addDefaultRoles(long userId) throws PortalException {
        CommerceAccountServiceConfiguration commerceAccountServiceConfiguration = (CommerceAccountServiceConfiguration)this._configurationProvider.getSystemConfiguration(CommerceAccountServiceConfiguration.class);
        Object[] siteRoles = commerceAccountServiceConfiguration.siteRoles();
        if (siteRoles == null && ArrayUtil.isEmpty((Object[])siteRoles)) {
            return;
        }
        User user = this._userLocalService.getUser(userId);
        HashSet<Role> roles = new HashSet<Role>();
        for (Object siteRole : siteRoles) {
            Role role = this._roleLocalService.fetchRole(user.getCompanyId(), (String)siteRole);
            if (role == null || role.getType() != 2) continue;
            roles.add(role);
        }
        long[] roleIds = TransformUtil.transformToLongArray(roles, RoleModel::getRoleId);
        for (AccountEntryUserRel accountEntryUserRel : this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(userId)) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryUserRel.getAccountEntryId());
            this._userGroupRoleLocalService.addUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), roleIds);
        }
    }

    public int countUserCommerceAccounts(long userId, long commerceChannelGroupId) throws PortalException {
        return this._accountEntryLocalService.getUserAccountEntriesCount(userId, Long.valueOf(0L), "", this.getAccountEntryTypes(commerceChannelGroupId), Integer.valueOf(-1));
    }

    public String[] getAccountEntryTypes(long commerceChannelGroupId) throws ConfigurationException {
        return this.toAccountEntryTypes(this.getCommerceSiteType(commerceChannelGroupId));
    }

    public String getAccountManagementPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_account_admin_web_internal_portlet_AccountEntriesManagementPortlet");
        if (plid > 0L) {
            LiferayPortletURL portletURL = this._portletURLFactory.create(httpServletRequest, "com_liferay_account_admin_web_internal_portlet_AccountEntriesManagementPortlet", plid, "RENDER_PHASE");
            return portletURL.toString();
        }
        return "";
    }

    public int getCommerceSiteType(long commerceChannelGroupId) throws ConfigurationException {
        CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannelGroupId, "com.liferay.commerce.account"));
        return commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    public AccountEntry getCurrentAccountEntry(long commerceChannelGroupId, HttpServletRequest httpServletRequest) throws PortalException {
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        CommerceOrder commerceOrder = (CommerceOrder)httpSession.getAttribute("COMMERCE_ORDER_ON_ACCOUNT_SELECTION");
        if (commerceOrder != null) {
            this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, 0L);
            return null;
        }
        int commerceSiteType = this.getCommerceSiteType(commerceChannelGroupId);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceChannelGroupId);
        long userId = this._portal.getUserId(httpServletRequest);
        AccountEntry accountEntry = this._currentAccountEntryManager.getCurrentAccountEntry(commerceChannel.getSiteGroupId(), userId);
        if (!(accountEntry != null && accountEntry.getStatus() == 0 || commerceSiteType != 0 && commerceSiteType != 2 || (accountEntry = this._accountEntryLocalService.fetchPersonAccountEntry(userId)) != null || (accountEntry = this._accountEntryLocalService.fetchSupplierAccountEntry(userId)) != null)) {
            User user = this._userLocalService.getUser(userId);
            if (user.isGuestUser()) {
                accountEntry = this._accountEntryLocalService.getGuestAccountEntry(commerceChannel.getCompanyId());
            } else {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(user.getCompanyId());
                serviceContext.setUserId(userId);
                accountEntry = this._accountEntryLocalService.addAccountEntry("", userId, 0L, user.getFullName(), null, null, user.getEmailAddress(), null, "", "person", 0, serviceContext);
                this.addAccountEntryUserRel(accountEntry.getAccountEntryId(), userId, serviceContext);
            }
        }
        if (accountEntry != null) {
            if (accountEntry.isGuestAccount()) {
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, -1L);
                return accountEntry;
            }
            CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId(), 7);
            if (commerceChannelAccountEntryRel != null) {
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, commerceChannelAccountEntryRel.getAccountEntryId());
                return accountEntry;
            }
            commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId(), 9);
            if (commerceChannelAccountEntryRel != null) {
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, commerceChannelAccountEntryRel.getAccountEntryId());
                return accountEntry;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            int count = this._commerceChannelAccountEntryRelLocalService.getCommerceChannelAccountEntryRelsCount(commerceChannel.getCommerceChannelId(), null, 9);
            if (permissionChecker.hasPermission(commerceChannelGroupId, AccountEntry.class.getName(), commerceChannel.getCompanyId(), "VIEW") && count == 0) {
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, accountEntry.getAccountEntryId());
                return accountEntry;
            }
            List<AccountEntry> commerceChannelAccountEntries = this._getCommerceChannelAccountEntries(userId, commerceChannel.getCommerceChannelId());
            for (AccountEntry commerceChannelAccountEntry : commerceChannelAccountEntries) {
                if (accountEntry.getAccountEntryId() != commerceChannelAccountEntry.getAccountEntryId()) continue;
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, accountEntry.getAccountEntryId());
                return accountEntry;
            }
            if (!commerceChannelAccountEntries.isEmpty()) {
                accountEntry = commerceChannelAccountEntries.get(0);
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, accountEntry.getAccountEntryId());
            } else {
                this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, -1L);
                if (!accountEntry.isGuestAccount()) {
                    return null;
                }
            }
        } else {
            this.setCurrentCommerceAccount(httpServletRequest, commerceChannelGroupId, -1L);
            return null;
        }
        return accountEntry;
    }

    public long[] getUserCommerceAccountIds(long userId, long commerceChannelGroupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceChannelGroupId);
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(0L), "", this.getAccountEntryTypes(commerceChannelGroupId), Integer.valueOf(-1), -1, -1);
        return ListUtil.toLongArray(this._filterAccountEntries(accountEntries, commerceChannel.getCommerceChannelId()), AccountEntryModel::getAccountEntryId);
    }

    public void setCurrentCommerceAccount(HttpServletRequest httpServletRequest, long commerceChannelGroupId, long commerceAccountId) throws PortalException {
        if (commerceAccountId > 0L && commerceAccountId != AccountRolePermissionThreadLocal.getAccountEntryId()) {
            AccountEntry accountEntry = this._accountEntryService.getAccountEntry(commerceAccountId);
            this._checkAccountType(commerceChannelGroupId, accountEntry.getAccountEntryId());
        }
        AccountRolePermissionThreadLocal.setAccountEntryIdWithSafeCloseable((long)commerceAccountId);
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceChannelGroupId);
        long userId = this._portal.getUserId(httpServletRequest);
        this._currentAccountEntryManager.setCurrentAccountEntry(commerceAccountId, commerceChannel.getGroupId(), userId);
        this._currentAccountEntryManager.setCurrentAccountEntry(commerceAccountId, commerceChannel.getSiteGroupId(), userId);
    }

    public Integer toAccountEntryStatus(Boolean commerceAccountActive) {
        if (commerceAccountActive == null) {
            return -1;
        }
        if (commerceAccountActive.booleanValue()) {
            return 0;
        }
        return 5;
    }

    public String[] toAccountEntryTypes(int commerceSiteType) {
        if (commerceSiteType == 1) {
            return new String[]{"business"};
        }
        if (commerceSiteType == 0) {
            return new String[]{"person"};
        }
        if (commerceSiteType == 2) {
            return new String[]{"business", "person"};
        }
        return null;
    }

    private void _checkAccountType(long commerceChannelGroupId, long commerceAccountId) throws PortalException {
        int commerceSiteType = this.getCommerceSiteType(commerceChannelGroupId);
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(commerceAccountId);
        if (commerceSiteType == 0 && accountEntry.isBusinessAccount()) {
            throw new PortalException("Only personal accounts are allowed in a b2c site");
        }
        if (commerceSiteType == 1 && accountEntry.isPersonalAccount()) {
            throw new PortalException("Only business accounts are allowed in a b2b site");
        }
    }

    private List<AccountEntry> _filterAccountEntries(List<AccountEntry> accountEntries, long commerceChannelId) {
        List commerceChannelAccountEntryRels = this._commerceChannelAccountEntryRelLocalService.getCommerceChannelAccountEntryRels(commerceChannelId, null, 9, -1, -1);
        if (commerceChannelAccountEntryRels.isEmpty()) {
            return accountEntries;
        }
        HashSet channelAccountEntryIds = new HashSet(ListUtil.toList((List)commerceChannelAccountEntryRels, CommerceChannelAccountEntryRelModel::getAccountEntryId));
        return TransformUtil.transform(accountEntries, accountEntry -> {
            if (channelAccountEntryIds.contains(accountEntry.getAccountEntryId())) {
                return accountEntry;
            }
            return null;
        });
    }

    private List<AccountEntry> _getCommerceChannelAccountEntries(long userId, long commerceChannelId) throws PortalException {
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(0L), null, new String[]{"business", "guest", "person", "supplier"}, -1, -1);
        return this._filterAccountEntries(accountEntries, commerceChannelId);
    }
}

