/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.configuration.CommerceOrderFieldsConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.exception.CommerceDiscountCouponCodeException;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTimesException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.discount.validator.helper.CommerceDiscountValidatorHelper;
import com.liferay.commerce.exception.CommerceOrderAccountLimitException;
import com.liferay.commerce.exception.CommerceOrderDateException;
import com.liferay.commerce.exception.CommerceOrderPurchaseOrderNumberException;
import com.liferay.commerce.exception.CommerceOrderRequestedDeliveryDateException;
import com.liferay.commerce.exception.GuestCartMaxAllowedException;
import com.liferay.commerce.internal.order.comparator.CommerceOrderModifiedDateComparator;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.CommerceShippingOption;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.model.attributes.provider.CommerceModelAttributesProvider;
import com.liferay.commerce.payment.integration.CommercePaymentIntegration;
import com.liferay.commerce.payment.integration.CommercePaymentIntegrationRegistry;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelQualifierLocalService;
import com.liferay.commerce.payment.util.comparator.CommercePaymentMethodPriorityComparator;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.exception.NoSuchChannelAccountEntryRelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderNoteLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelService;
import com.liferay.commerce.service.base.CommerceOrderLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemPersistence;
import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOption;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.service.CommerceTermEntryLocalService;
import com.liferay.commerce.util.CommerceOrderThreadLocal;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.commerce.util.comparator.CommerceShippingMethodPriorityComparator;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderConfiguration"}, property={"model.class.name=com.liferay.commerce.model.CommerceOrder"}, service={AopService.class})
public class CommerceOrderLocalServiceImpl
extends CommerceOrderLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderLocalServiceImpl.class);
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    @Reference
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @Reference
    private CommerceDiscountValidatorHelper _commerceDiscountValidatorHelper;
    @Reference
    private CommerceModelAttributesProvider _commerceModelAttributesProvider;
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderItemPersistence _commerceOrderItemPersistence;
    @Reference
    private CommerceOrderNoteLocalService _commerceOrderNoteLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @Reference
    private CommercePaymentIntegrationRegistry _commercePaymentIntegrationRegistry;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodGroupRelQualifierLocalService _commercePaymentMethodGroupRelQualifierLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CommerceShippingOptionAccountEntryRelService _commerceShippingOptionAccountEntryRelService;
    @Reference
    private CommerceTermEntryLocalService _commerceTermEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private WorkflowTaskManager _workflowTaskManager;

    public FileEntry addAttachmentFileEntry(String externalReferenceCode, long userId, long commerceOrderId, String fileName, InputStream inputStream) throws PortalException {
        FileEntry fileEntry;
        if (Validator.isNull((String)fileName)) {
            return null;
        }
        File file = null;
        try {
            ServiceContext serviceContext;
            CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            LocalRepository localRepository = commerceOrder.getLocalRepository();
            Folder folder = commerceOrder.getFolder(localRepository);
            if (folder == null) {
                serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setCompanyId(commerceOrder.getCompanyId());
                serviceContext.setUserId(commerceOrder.getUserId());
                folder = localRepository.addFolder("order-" + commerceOrderId, commerceOrder.getUserId(), 0L, String.valueOf(commerceOrderId), "", serviceContext);
            }
            file = FileUtil.createTempFile((InputStream)inputStream);
            serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAttribute("className", (Serializable)((Object)CommerceOrder.class.getName()));
            serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(commerceOrderId)));
            serviceContext.setIndexingEnabled(false);
            fileEntry = localRepository.addFileEntry(externalReferenceCode, userId, folder.getFolderId(), fileName, MimeTypesUtil.getContentType((File)file, (String)fileName), fileName, fileName, "", "", file, null, null, null, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                DLAppHelperThreadLocal.setEnabled((boolean)true);
                FileUtil.delete(file);
                throw throwable;
            }
        }
        DLAppHelperThreadLocal.setEnabled((boolean)true);
        FileUtil.delete((File)file);
        return fileEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addCommerceOrder(long userId, long groupId, long billingAddressId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String commercePaymentMethodKey, String name, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, ServiceContext serviceContext) throws PortalException {
        List commerceOrderTypes;
        CommerceCurrency commerceCurrency;
        if (userId == 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            User guestUser = this._userLocalService.getGuestUser(group.getCompanyId());
            userId = guestUser.getUserId();
        }
        serviceContext.setUserId(userId);
        User user = this._userLocalService.getUser(userId);
        if (this._hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        serviceContext.setScopeGroupId(groupId);
        this._validateAccountLimit(groupId, commerceAccountId);
        this._validateCommerceChannelAccount(groupId, commerceAccountId);
        this._validateGuestOrders();
        if (Validator.isNull((String)commerceCurrencyCode) && (commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(serviceContext.getCompanyId())) != null) {
            commerceCurrencyCode = commerceCurrency.getCode();
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        if (commerceOrderTypeId <= 0L && !(commerceOrderTypes = this._commerceOrderTypeLocalService.getCommerceOrderTypes(user.getCompanyId(), CommerceChannel.class.getName(), commerceChannel.getCommerceChannelId(), true, 0, 1)).isEmpty()) {
            CommerceOrderType commerceOrderType = (CommerceOrderType)commerceOrderTypes.get(0);
            commerceOrderTypeId = commerceOrderType.getCommerceOrderTypeId();
        }
        long commerceOrderId = this.counterLocalService.increment();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.create(commerceOrderId);
        commerceOrder.setGroupId(groupId);
        commerceOrder.setCompanyId(user.getCompanyId());
        commerceOrder.setUserId(userId);
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setCommerceAccountId(commerceAccountId);
        commerceOrder.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceOrder.setCommerceOrderTypeId(commerceOrderTypeId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        if (billingAddressId > 0L) {
            commerceOrder.setBillingAddressId(billingAddressId);
        } else {
            this._setAccountDefaultBillingAddress(commerceChannel, commerceOrder);
        }
        if (shippingAddressId > 0L) {
            commerceOrder.setShippingAddressId(shippingAddressId);
        } else {
            this._setAccountDefaultShippingAddress(commerceChannel, commerceOrder);
        }
        if (Validator.isNotNull((String)commercePaymentMethodKey)) {
            commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        } else {
            this._setAccountDefaultPaymentIntegrationKey(commerceChannel, commerceOrder);
        }
        this._setAccountDefaultPaymentTerm(commerceChannel, commerceOrder, user);
        commerceOrder.setName(name);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setShippingOptionName(shippingOptionName);
        this._setCommerceOrderPrices(commerceOrder, shippingAmount, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, null, false);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, null, false);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, null, true);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, null, false);
        commerceOrder.setManuallyAdjusted(false);
        Date orderDate = this._portal.getDate(orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, user.getTimeZone(), null);
        if (orderDate != null) {
            commerceOrder.setOrderDate(orderDate);
        } else {
            commerceOrder.setOrderDate(new Date());
        }
        commerceOrder.setOrderStatus(orderStatus);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setStatus(2);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(null));
        commerceOrder.setExpandoBridgeAttributes(serviceContext);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        LocalRepository localRepository = commerceOrder.getLocalRepository();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        localRepository.addFolder("order-" + commerceOrderId, user.getUserId(), 0L, String.valueOf(commerceOrderId), "", serviceContext);
        return (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getScopeGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
    }

    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId) throws PortalException {
        return this.commerceOrderLocalService.addCommerceOrder(userId, groupId, 0L, commerceAccountId, commerceCurrencyCode, commerceOrderTypeId, 0L, 0L, null, null, 0, 0, 0, 0, 0, 2, 1, null, BigDecimal.ZERO, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, new ServiceContext());
    }

    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long userId, long groupId, long billingAddressId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            commerceOrder = this.commerceOrderPersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId());
        }
        if (commerceOrder != null) {
            commerceOrder = this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrder.getCommerceOrderId(), billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, null, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, commerceOrder.getTotalDiscountAmount(), totalWithTaxAmount);
            commerceOrder = this.commerceOrderLocalService.updatePaymentStatus(userId, commerceOrder.getCommerceOrderId(), paymentStatus);
            User user = this._userLocalService.getUser(serviceContext.getUserId());
            Date orderDate = this._portal.getDate(orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, user.getTimeZone(), null);
            if (orderDate != null) {
                commerceOrder.setOrderDate(orderDate);
            }
            commerceOrder.setOrderStatus(orderStatus);
            return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        }
        commerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, groupId, billingAddressId, commerceAccountId, commerceCurrencyCode, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, commercePaymentMethodKey, name, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, serviceContext);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean hasDiscounts = false;
        int count = this._commerceDiscountLocalService.getActiveCommerceDiscountsCount(commerceOrder.getCompanyId(), couponCode, true);
        if (count == 0) {
            hasDiscounts = true;
        }
        if (hasDiscounts && Validator.isNotNull((String)couponCode)) {
            throw new CommerceDiscountCouponCodeException();
        }
        if (Validator.isNotNull((String)couponCode)) {
            CommerceDiscount commerceDiscount = this._commerceDiscountLocalService.getActiveCommerceDiscount(commerceOrder.getCompanyId(), couponCode, true);
            this._commerceDiscountValidatorHelper.checkValid(commerceContext, commerceDiscount, new String[0]);
            if (!this._commerceDiscountUsageEntryLocalService.validateDiscountLimitationUsage(CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceDiscount.getCommerceDiscountId())) {
                throw new CommerceDiscountLimitationTimesException();
            }
        }
        commerceOrder.setCouponCode(couponCode);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
    }

    public void deleteAttachmentFileEntry(long attachmentFileEntryId, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        LocalRepository localRepository = commerceOrder.getLocalRepository();
        localRepository.deleteFileEntry(attachmentFileEntryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceOrder deleteCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        boolean deleteInProcess = CommerceOrderThreadLocal.isDeleteInProcess();
        try {
            CommerceOrderThreadLocal.setDeleteInProcess((boolean)true);
            this._commerceOrderItemLocalService.deleteCommerceOrderItems(this._getUserId(commerceOrder), commerceOrder.getCommerceOrderId());
            this._commerceOrderNoteLocalService.deleteCommerceOrderNotes(commerceOrder.getCommerceOrderId());
            this._commerceOrderPaymentLocalService.deleteCommerceOrderPayments(commerceOrder.getCommerceOrderId());
            this._commerceAddressLocalService.deleteCommerceAddresses(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId());
            this.commerceOrderPersistence.remove((BaseModel)commerceOrder);
            this._expandoRowLocalService.deleteRows(commerceOrder.getCommerceOrderId());
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrder.getCompanyId(), commerceOrder.getScopeGroupId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
            CommerceOrder commerceOrder2 = commerceOrder;
            return commerceOrder2;
        }
        finally {
            CommerceOrderThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    @Override
    public CommerceOrder deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
    }

    public void deleteCommerceOrders(long groupId) throws PortalException {
        List commerceOrders = this.commerceOrderPersistence.findByGroupId(groupId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
        }
    }

    @Deprecated
    public void deleteCommerceOrders(long userId, Date date, int status) {
        this.commerceOrderPersistence.removeByU_LtC_O(userId, date, status);
    }

    public void deleteCommerceOrdersByAccountId(long commerceAccountId, Date date, int status) throws PortalException {
        List commerceOrderList = this.commerceOrderPersistence.findByC_LtC_O(date, commerceAccountId, status, -1, -1, null);
        for (CommerceOrder commerceOrder : commerceOrderList) {
            this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
        }
    }

    public CommerceOrder executeWorkflowTransition(long userId, long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        long companyId = commerceOrder.getCompanyId();
        WorkflowTask workflowTask = this._workflowTaskManager.getWorkflowTask(workflowTaskId);
        if (!workflowTask.isAssignedToSingleUser()) {
            workflowTask = this._workflowTaskManager.assignWorkflowTaskToUser(companyId, userId, workflowTask.getWorkflowTaskId(), userId, comment, null, null);
        }
        this._workflowTaskManager.completeWorkflowTask(companyId, userId, workflowTask.getWorkflowTaskId(), transitionName, comment, null, true);
        return commerceOrder;
    }

    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) {
        return this.commerceOrderPersistence.fetchByG_C_O_First(groupId, commerceAccountId, orderStatus, (OrderByComparator)CommerceOrderModifiedDateComparator.getInstance(false));
    }

    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) {
        return this.commerceOrderFinder.fetchByG_U_C_O_S_First(groupId, userId, commerceAccountId, orderStatus);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderFinder.findByG_O(groupId, orderStatuses, start, end);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByG_C(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus, int start, int end) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, start, end, null);
        BaseModelSearchResult baseModelSearchResult = this.commerceOrderLocalService.searchCommerceOrders(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceOrder> getCommerceOrders(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, start, end, sort);
        BaseModelSearchResult baseModelSearchResult = this.commerceOrderLocalService.searchCommerceOrders(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, String commercePaymentMethodKey) {
        return this.commerceOrderPersistence.findByG_CP(groupId, commercePaymentMethodKey);
    }

    public List<CommerceOrder> getCommerceOrdersByBillingAddress(long billingAddressId) {
        return this.commerceOrderPersistence.findByBillingAddressId(billingAddressId);
    }

    public List<CommerceOrder> getCommerceOrdersByCommerceAccountId(long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByCommerceAccountId(commerceAccountId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrdersByShippingAddress(long shippingAddressId) {
        return this.commerceOrderPersistence.findByShippingAddressId(shippingAddressId);
    }

    public int getCommerceOrdersCount(long groupId) {
        return this.commerceOrderPersistence.countByGroupId(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long commerceAccountId) {
        return this.commerceOrderPersistence.countByG_C(groupId, commerceAccountId);
    }

    public long getCommerceOrdersCount(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupId, commerceAccountIds, keywords, excludeOrderStatus, orderStatuses, -1, -1, null);
        return this.commerceOrderLocalService.searchCommerceOrdersCount(searchContext);
    }

    public int getCommerceOrdersCountByCommerceAccountId(long commerceAccountId) {
        return this.commerceOrderPersistence.countByCommerceAccountId(commerceAccountId);
    }

    public List<CommerceOrder> getShippedCommerceOrdersByCommerceShipmentId(long commerceShipmentId, int start, int end) {
        return this.commerceOrderFinder.getShippedCommerceOrdersByCommerceShipmentId(commerceShipmentId, start, end);
    }

    @Deprecated
    public List<CommerceOrder> getUserCommerceOrders(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords, int start, int end) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return this.commerceOrderLocalService.getCommerceOrders(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false, start, end);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return Collections.emptyList();
        }
    }

    @Deprecated
    public int getUserCommerceOrdersCount(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), groupId, new long[]{commerceAccountId}, keywords, new int[]{2}, false);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return 0;
        }
    }

    public void mergeGuestCommerceOrder(long userId, long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List guestCommerceOrderItems = this._commerceOrderItemPersistence.findByCommerceOrderId(guestCommerceOrderId);
        for (CommerceOrderItem guestCommerceOrderItem : guestCommerceOrderItems) {
            List userCommerceOrderItems = this._commerceOrderItemPersistence.findByC_CPI(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId());
            if (!userCommerceOrderItems.isEmpty()) {
                boolean found = false;
                for (CommerceOrderItem userCommerceOrderItem : userCommerceOrderItems) {
                    if (!Objects.equals(guestCommerceOrderItem.getJson(), userCommerceOrderItem.getJson())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            this._commerceOrderItemLocalService.addCommerceOrderItem(userId, userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId(), guestCommerceOrderItem.getJson(), guestCommerceOrderItem.getQuantity(), guestCommerceOrderItem.getReplacedCPInstanceId(), guestCommerceOrderItem.getShippedQuantity(), guestCommerceOrderItem.getUnitOfMeasureKey(), commerceContext, serviceContext);
        }
        this.commerceOrderLocalService.deleteCommerceOrder(guestCommerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (commerceOrder.getOrderStatus() != 2 || commerceOrder.isManuallyAdjusted()) {
            return commerceOrder;
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            this._commerceOrderItemLocalService.updateCommerceOrderItemPrice(commerceOrderItem.getCommerceOrderItemId(), commerceContext);
        }
        commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, false, commerceContext);
        CommerceMoney subtotalCommerceMoney = commerceOrderPrice.getSubtotal();
        CommerceMoney shippingValueCommerceMoney = commerceOrderPrice.getShippingValue();
        CommerceMoney taxValueCommerceMoney = commerceOrderPrice.getTaxValue();
        CommerceMoney totalCommerceMoney = commerceOrderPrice.getTotal();
        CommerceMoney subtotalWithTaxAmountCommerceMoney = commerceOrderPrice.getSubtotalWithTaxAmount();
        CommerceMoney shippingValueWithTaxAmountCommerceMoney = commerceOrderPrice.getShippingValueWithTaxAmount();
        CommerceMoney totalWithTaxAmountCommerceMoney = commerceOrderPrice.getTotalWithTaxAmount();
        commerceOrder.setShippingAmount(shippingValueCommerceMoney.getPrice());
        commerceOrder.setSubtotal(subtotalCommerceMoney.getPrice());
        commerceOrder.setTaxAmount(taxValueCommerceMoney.getPrice());
        commerceOrder.setTotal(totalCommerceMoney.getPrice());
        if (subtotalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmountCommerceMoney.getPrice());
        }
        if (shippingValueWithTaxAmountCommerceMoney != null) {
            commerceOrder.setShippingWithTaxAmount(shippingValueWithTaxAmountCommerceMoney.getPrice());
        }
        if (totalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setTotalWithTaxAmount(totalWithTaxAmountCommerceMoney.getPrice());
        }
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValue(), false);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValue(), false);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValue(), false);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValueWithTaxAmount(), true);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder reorderCommerceOrder(long userId, long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceAddress billingAddress;
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        long billingAddressId = 0L;
        long shippingAddressId = 0L;
        CommerceAddress shippingAddress = billingAddress = this._getNewCommerceAddress("billing", commerceOrder, commerceOrder.getBillingAddress(), serviceContext);
        if (commerceOrder.getBillingAddressId() != commerceOrder.getShippingAddressId()) {
            shippingAddress = this._getNewCommerceAddress("shipping", commerceOrder, commerceOrder.getShippingAddress(), serviceContext);
        }
        if (billingAddress != null) {
            billingAddressId = billingAddress.getCommerceAddressId();
        }
        if (shippingAddress != null) {
            shippingAddressId = shippingAddress.getCommerceAddressId();
        }
        String commerceCurrencyCode = commerceOrder.getCommerceCurrencyCode();
        boolean recalculate = false;
        CommerceCurrency commerceContextCommerceCurrency = commerceContext.getCommerceCurrency();
        if (commerceContextCommerceCurrency != null && !Objects.equals(commerceContextCommerceCurrency.getCode(), commerceCurrencyCode)) {
            commerceCurrencyCode = commerceContextCommerceCurrency.getCode();
            recalculate = true;
        }
        CommerceOrder newCommerceOrder = this.commerceOrderLocalService.addCommerceOrder(userId, commerceOrder.getGroupId(), billingAddressId, commerceOrder.getCommerceAccountId(), commerceCurrencyCode, commerceOrder.getCommerceOrderTypeId(), commerceOrder.getCommerceShippingMethodId(), shippingAddressId, commerceOrder.getCommercePaymentMethodKey(), commerceOrder.getName(), 0, 0, 0, 0, 0, 2, 1, "", commerceOrder.getShippingAmount(), commerceOrder.getShippingOptionName(), commerceOrder.getShippingWithTaxAmount(), commerceOrder.getSubtotal(), commerceOrder.getSubtotalWithTaxAmount(), commerceOrder.getTaxAmount(), commerceOrder.getTotal(), commerceOrder.getTotalWithTaxAmount(), serviceContext);
        List commerceOrderItems = this._commerceOrderItemLocalService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.getParentCommerceOrderItemId() != 0L) continue;
            this._commerceOrderItemLocalService.addCommerceOrderItem(userId, newCommerceOrder.getCommerceOrderId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity(), commerceOrderItem.getReplacedCPInstanceId(), BigDecimal.ZERO, commerceOrderItem.getUnitOfMeasureKey(), commerceContext, serviceContext);
        }
        if (recalculate) {
            newCommerceOrder = this.commerceOrderLocalService.updateCommerceShippingMethod(newCommerceOrder.getCommerceOrderId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), commerceContext, serviceContext.getLocale());
            newCommerceOrder = this.commerceOrderLocalService.recalculatePrice(newCommerceOrder.getCommerceOrderId(), commerceContext);
        }
        return newCommerceOrder;
    }

    public CommerceOrder resetCommerceOrderAddresses(long commerceOrderId, boolean billingAddress, boolean shippingAddress) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (billingAddress) {
            commerceOrder.setBillingAddressId(0L);
        }
        if (shippingAddress) {
            commerceOrder.setShippingAddressId(0L);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder resetCommerceOrderShipping(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(0L);
        commerceOrder.setShippingAmount(BigDecimal.ZERO);
        commerceOrder.setShippingOptionName(null);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public void resetCommerceOrderShippingByAddressId(long addressId) throws PortalException {
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(addressId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            if (!commerceOrder.isDraft() && !commerceOrder.isOpen()) continue;
            this.commerceOrderLocalService.resetCommerceOrderShipping(commerceOrder.getCommerceOrderId());
        }
    }

    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean resetDeliveryCommerceTerm, boolean resetPaymentCommerceTermEntry) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (resetDeliveryCommerceTerm) {
            commerceOrder.setDeliveryCommerceTermEntryId(0L);
            commerceOrder.setDeliveryCommerceTermEntryDescription(null);
            commerceOrder.setDeliveryCommerceTermEntryName(null);
        }
        if (resetPaymentCommerceTermEntry) {
            commerceOrder.setPaymentCommerceTermEntryId(0L);
            commerceOrder.setPaymentCommerceTermEntryDescription(null);
            commerceOrder.setPaymentCommerceTermEntryName(null);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public BaseModelSearchResult<CommerceOrder> searchCommerceOrders(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceOrder.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceOrder> commerceOrders = this._getCommerceOrders(hits);
            if (commerceOrders == null) continue;
            return new BaseModelSearchResult(commerceOrders, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceOrdersCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceOrder.class.getName());
        return indexer.searchCount(searchContext);
    }

    public CommerceOrder updateAccount(long commerceOrderId, long userId, long commerceAccountId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this._userLocalService.getUser(userId);
        commerceOrder.setUserId(user.getUserId());
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setCommerceAccountId(commerceAccountId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, long countryId, long regionId, String city, String description, String name, String phoneNumber, String street1, String street2, String street3, String subtype, String zip, ServiceContext serviceContext) throws PortalException {
        return this._updateAddress(city, CommerceOrderModel::getBillingAddressId, CommerceOrderModel::setBillingAddressId, commerceOrderId, countryId, description, name, phoneNumber, regionId, street1, street2, street3, serviceContext, subtype, zip);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) {
        try {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceOrder.getGroupId());
            User user = this._userLocalService.getUser(commerceOrder.getUserId());
            this._setAccountDefaultBillingAddress(commerceChannel, commerceOrder);
            this._setAccountDefaultShippingAddress(commerceChannel, commerceOrder);
            this._setAccountDefaultPaymentIntegrationKey(commerceChannel, commerceOrder);
            this._setAccountDefaultShippingOption(commerceChannel, commerceOrder, user);
            this._setAccountDefaultDeliveryTerm(commerceChannel, commerceOrder, user);
            this._setAccountDefaultPaymentTerm(commerceChannel, commerceOrder, user);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return super.updateCommerceOrder(commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(long userId, String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId, long commerceShippingMethodId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String couponCode, String deliveryCommerceTermEntryDescription, String deliveryCommerceTermEntryName, Date lastPriceUpdateDate, boolean manuallyAdjusted, String name, Date orderDate, int orderStatus, String paymentCommerceTermEntryDescription, String paymentCommerceTermEntryName, int paymentStatus, String printedNote, String purchaseOrderNumber, Date requestedDeliveryDate, boolean shippable, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount, String transactionId, int status, long statusByUserId, String statusByUserName, Date statusDate, boolean recalculate, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        long currentUserId = commerceOrder.getUserId();
        if (currentUserId != userId) {
            User user = this._userLocalService.getUser(userId);
            commerceOrder.setUserId(user.getUserId());
            commerceOrder.setUserName(user.getFullName());
        }
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setCommerceAccountId(commerceAccountId);
        commerceOrder.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceOrder.setCommerceOrderTypeId(commerceOrderTypeId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setDeliveryCommerceTermEntryId(deliveryCommerceTermEntryId);
        commerceOrder.setPaymentCommerceTermEntryId(paymentCommerceTermEntryId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setAdvanceStatus(advanceStatus);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        commerceOrder.setCouponCode(couponCode);
        commerceOrder.setDeliveryCommerceTermEntryDescription(deliveryCommerceTermEntryDescription);
        commerceOrder.setDeliveryCommerceTermEntryName(deliveryCommerceTermEntryName);
        commerceOrder.setLastPriceUpdateDate(lastPriceUpdateDate);
        commerceOrder.setManuallyAdjusted(manuallyAdjusted);
        if (name != null) {
            commerceOrder.setName(name);
        }
        commerceOrder.setOrderDate(orderDate);
        commerceOrder.setOrderStatus(orderStatus);
        commerceOrder.setPaymentCommerceTermEntryDescription(paymentCommerceTermEntryDescription);
        commerceOrder.setPaymentCommerceTermEntryName(paymentCommerceTermEntryName);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setPrintedNote(printedNote);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setRequestedDeliveryDate(requestedDeliveryDate);
        commerceOrder.setShippable(shippable);
        if (shippingAmount == null) {
            shippingAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingAmount(shippingAmount);
        if (shippingDiscountAmount == null) {
            shippingDiscountAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountAmount(shippingDiscountAmount);
        if (shippingDiscountPercentageLevel1 == null) {
            shippingDiscountPercentageLevel1 = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        if (shippingDiscountPercentageLevel2 == null) {
            shippingDiscountPercentageLevel2 = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        if (shippingDiscountPercentageLevel3 == null) {
            shippingDiscountPercentageLevel3 = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        if (shippingDiscountPercentageLevel4 == null) {
            shippingDiscountPercentageLevel4 = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
        if (shippingDiscountPercentageLevel1WithTaxAmount == null) {
            shippingDiscountPercentageLevel1WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(shippingDiscountPercentageLevel1WithTaxAmount);
        if (shippingDiscountPercentageLevel2WithTaxAmount == null) {
            shippingDiscountPercentageLevel2WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(shippingDiscountPercentageLevel2WithTaxAmount);
        if (shippingDiscountPercentageLevel3WithTaxAmount == null) {
            shippingDiscountPercentageLevel3WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(shippingDiscountPercentageLevel3WithTaxAmount);
        if (shippingDiscountPercentageLevel4WithTaxAmount == null) {
            shippingDiscountPercentageLevel4WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(shippingDiscountPercentageLevel4WithTaxAmount);
        if (shippingDiscountWithTaxAmount == null) {
            shippingDiscountWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingDiscountWithTaxAmount(shippingDiscountWithTaxAmount);
        commerceOrder.setShippingOptionName(shippingOptionName);
        if (shippingWithTaxAmount == null) {
            shippingWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        if (subtotal == null) {
            subtotal = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotal(subtotal);
        if (subtotalDiscountAmount == null) {
            subtotalDiscountAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountAmount(subtotalDiscountAmount);
        if (subtotalDiscountPercentageLevel1 == null) {
            subtotalDiscountPercentageLevel1 = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        if (subtotalDiscountPercentageLevel2 == null) {
            subtotalDiscountPercentageLevel2 = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        if (subtotalDiscountPercentageLevel3 == null) {
            subtotalDiscountPercentageLevel3 = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        if (subtotalDiscountPercentageLevel4 == null) {
            subtotalDiscountPercentageLevel4 = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
        if (subtotalDiscountPercentageLevel1WithTaxAmount == null) {
            subtotalDiscountPercentageLevel1WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(subtotalDiscountPercentageLevel1WithTaxAmount);
        if (subtotalDiscountPercentageLevel2WithTaxAmount == null) {
            subtotalDiscountPercentageLevel2WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(subtotalDiscountPercentageLevel2WithTaxAmount);
        if (subtotalDiscountPercentageLevel3WithTaxAmount == null) {
            subtotalDiscountPercentageLevel3WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(subtotalDiscountPercentageLevel3WithTaxAmount);
        if (subtotalDiscountPercentageLevel4WithTaxAmount == null) {
            subtotalDiscountPercentageLevel4WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(subtotalDiscountPercentageLevel4WithTaxAmount);
        if (subtotalDiscountWithTaxAmount == null) {
            subtotalDiscountWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalDiscountWithTaxAmount(subtotalDiscountWithTaxAmount);
        if (subtotalWithTaxAmount == null) {
            subtotalWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        if (taxAmount == null) {
            taxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTaxAmount(taxAmount);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        commerceOrder.setTotal(total);
        if (totalDiscountAmount == null) {
            totalDiscountAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        if (totalDiscountPercentageLevel1 == null) {
            totalDiscountPercentageLevel1 = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        if (totalDiscountPercentageLevel2 == null) {
            totalDiscountPercentageLevel2 = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        if (totalDiscountPercentageLevel3 == null) {
            totalDiscountPercentageLevel3 = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        if (totalDiscountPercentageLevel4 == null) {
            totalDiscountPercentageLevel4 = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
        if (totalDiscountPercentageLevel1WithTaxAmount == null) {
            totalDiscountPercentageLevel1WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(totalDiscountPercentageLevel1WithTaxAmount);
        if (totalDiscountPercentageLevel2WithTaxAmount == null) {
            totalDiscountPercentageLevel2WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(totalDiscountPercentageLevel2WithTaxAmount);
        if (totalDiscountPercentageLevel3WithTaxAmount == null) {
            totalDiscountPercentageLevel3WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(totalDiscountPercentageLevel3WithTaxAmount);
        if (totalDiscountPercentageLevel4WithTaxAmount == null) {
            totalDiscountPercentageLevel4WithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(totalDiscountPercentageLevel4WithTaxAmount);
        if (totalDiscountWithTaxAmount == null) {
            totalDiscountWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountWithTaxAmount(totalDiscountWithTaxAmount);
        if (totalWithTaxAmount == null) {
            totalWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        commerceOrder.setTransactionId(transactionId);
        commerceOrder.setStatus(status);
        commerceOrder.setStatusByUserId(statusByUserId);
        commerceOrder.setStatusByUserName(statusByUserName);
        commerceOrder.setStatusDate(statusDate);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        if (recalculate) {
            commerceOrder = this._recalculateOrder(commerceOrder, commerceContext);
        }
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, purchaseOrderNumber, shippingAmount, shippingOptionName, commerceOrder.getShippingWithTaxAmount(), subtotal, commerceOrder.getSubtotalWithTaxAmount(), commerceOrder.getTaxAmount(), total, commerceOrder.getTotalDiscountAmount(), commerceOrder.getTotalWithTaxAmount());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceOrder.getGroupId());
        commerceOrder.setBillingAddressId(billingAddressId);
        this._setAccountDefaultBillingAddress(commerceChannel, commerceOrder);
        commerceOrder.setShippingAddressId(shippingAddressId);
        this._setAccountDefaultShippingAddress(commerceChannel, commerceOrder);
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        this._setAccountDefaultShippingOption(commerceChannel, commerceOrder, user);
        commerceOrder.setAdvanceStatus(advanceStatus);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        this._setAccountDefaultPaymentIntegrationKey(commerceChannel, commerceOrder);
        this._setAccountDefaultDeliveryTerm(commerceChannel, commerceOrder, user);
        this._setAccountDefaultPaymentTerm(commerceChannel, commerceOrder, user);
        if (name != null) {
            commerceOrder.setName(name);
        }
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        if (totalDiscountAmount == null) {
            totalDiscountAmount = BigDecimal.ZERO;
        }
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        this._setCommerceOrderPrices(commerceOrder, shippingAmount, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public void updateCommerceOrderAddresses(long addressId) throws PortalException {
        List commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByBillingAddress(addressId);
        this._updateCommerceOrderAddresses(commerceOrders, addressId);
        commerceOrders = this.commerceOrderLocalService.getCommerceOrdersByShippingAddress(addressId);
        this._updateCommerceOrderAddresses(commerceOrders, addressId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getShippingDiscountWithTaxAmount(), commerceOrder.getShippingWithTaxAmount(), subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getSubtotalDiscountWithTaxAmount(), commerceOrder.getSubtotalWithTaxAmount(), taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount(), commerceOrder.getTotalDiscountWithTaxAmount(), commerceOrder.getTotalWithTaxAmount());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setLastPriceUpdateDate(new Date());
        commerceOrder.setManuallyAdjusted(true);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingDiscountAmount(shippingDiscountAmount);
        commerceOrder.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        commerceOrder.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        commerceOrder.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        commerceOrder.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
        commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(shippingDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(shippingDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(shippingDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(shippingDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setShippingDiscountWithTaxAmount(shippingDiscountWithTaxAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalDiscountAmount(subtotalDiscountAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        commerceOrder.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        commerceOrder.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        commerceOrder.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
        commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(subtotalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(subtotalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(subtotalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(subtotalDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setSubtotalDiscountWithTaxAmount(subtotalDiscountWithTaxAmount);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalDiscountAmount(totalDiscountAmount);
        commerceOrder.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        commerceOrder.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        commerceOrder.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        commerceOrder.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
        commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(totalDiscountPercentageLevel1WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(totalDiscountPercentageLevel2WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(totalDiscountPercentageLevel3WithTaxAmount);
        commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(totalDiscountPercentageLevel4WithTaxAmount);
        commerceOrder.setTotalDiscountWithTaxAmount(totalDiscountWithTaxAmount);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodKey);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingOptionName(commerceShippingOptionName);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (commerceShippingMethodId > 0L) {
            CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
            commerceOrder.setCommerceShippingMethodId(commerceShippingMethod.getCommerceShippingMethodId());
            commerceOrder.setShippingOptionName(commerceShippingOptionName);
            CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
            List commerceShippingOptions = commerceShippingEngine.getCommerceShippingOptions(commerceContext, commerceOrder, locale);
            for (CommerceShippingOption commerceShippingOption : commerceShippingOptions) {
                if (!Validator.isNotNull((String)commerceShippingOptionName) || !commerceShippingOptionName.equals(commerceShippingOption.getKey())) continue;
                commerceOrder.setShippingAmount(commerceShippingOption.getAmount());
                break;
            }
        } else {
            commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
            commerceOrder.setShippingAmount(BigDecimal.ZERO);
            commerceOrder.setShippingOptionName(commerceShippingOptionName);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        Date requestedDeliveryDate = this._portal.getDate(requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, user.getTimeZone(), CommerceOrderRequestedDeliveryDateException.class);
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPrintedNote(printedNote);
        commerceOrder.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setOrderDate(this._portal.getDate(orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, user.getTimeZone(), CommerceOrderDateException.class));
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatus(long userId, long commerceOrderId, int paymentStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.updatePaymentStatusAndTransactionId(userId, commerceOrderId, paymentStatus, commerceOrder.getTransactionId());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePaymentStatusAndTransactionId(long userId, long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceOrder originalCommerceOrder = commerceOrder.cloneWithOriginalValues();
        int previousPaymentStatus = commerceOrder.getPaymentStatus();
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setTransactionId(transactionId);
        commerceOrder = (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this._sendPaymentStatusMessage(commerceOrder, originalCommerceOrder, previousPaymentStatus);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPrintedNote(printedNote);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        this._validatePurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, long countryId, long regionId, String city, String description, String name, String phoneNumber, String street1, String street2, String street3, String subtype, String zip, ServiceContext serviceContext) throws PortalException {
        return this._updateAddress(city, CommerceOrderModel::getShippingAddressId, CommerceOrderModel::setShippingAddressId, commerceOrderId, countryId, description, name, phoneNumber, regionId, street1, street2, street3, serviceContext, subtype, zip);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateStatus(long userId, long commerceOrderId, int status, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setStatus(status);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(new Date());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceTermEntry deliveryCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(deliveryCommerceTermEntryId);
        CommerceTermEntry paymentCommerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(paymentCommerceTermEntryId);
        if (deliveryCommerceTermEntry == null && paymentCommerceTermEntry == null) {
            return commerceOrder;
        }
        if (deliveryCommerceTermEntry != null) {
            commerceOrder.setDeliveryCommerceTermEntryId(deliveryCommerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setDeliveryCommerceTermEntryDescription(deliveryCommerceTermEntry.getDescription(languageId, true));
            commerceOrder.setDeliveryCommerceTermEntryName(deliveryCommerceTermEntry.getLabel(languageId, true));
        }
        if (paymentCommerceTermEntry != null) {
            commerceOrder.setPaymentCommerceTermEntryId(paymentCommerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setPaymentCommerceTermEntryDescription(paymentCommerceTermEntry.getDescription(languageId, true));
            commerceOrder.setPaymentCommerceTermEntryName(paymentCommerceTermEntry.getLabel(languageId, true));
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderConfiguration.class, properties);
    }

    private SearchContext _buildSearchContext(long companyId, long commerceChannelGroupId, long[] commerceAccountIds, String keywords, boolean negated, int[] orderStatuses, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (orderStatuses != null) {
            searchContext.setAttribute("negateOrderStatuses", (Serializable)Boolean.valueOf(negated));
            searchContext.setAttribute("orderStatuses", (Serializable)orderStatuses);
        }
        if (commerceAccountIds != null) {
            searchContext.setAttribute("commerceAccountIds", (Serializable)commerceAccountIds);
        }
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{commerceChannelGroupId});
        searchContext.setKeywords(keywords);
        if (sort == null) {
            sort = SortFactoryUtil.getSort(CommerceOrder.class, (int)6, (String)"createDate", (String)"DESC");
        } else {
            sort.setFieldName("createDate");
            sort.setType(6);
        }
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommercePaymentMethodGroupRel> _filterCommercePaymentMethodGroupRels(long commerceOrderTypeId, List<CommercePaymentMethodGroupRel> commercePaymentMethodGroupRels, boolean subscriptionOrder) {
        if (ListUtil.isEmpty(commercePaymentMethodGroupRels)) {
            return Collections.emptyList();
        }
        LinkedList<CommercePaymentMethodGroupRel> filteredCommercePaymentMethodGroupRels = new LinkedList<CommercePaymentMethodGroupRel>();
        ListUtil.sort(commercePaymentMethodGroupRels, (Comparator)new CommercePaymentMethodPriorityComparator());
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            List commercePaymentMethodGroupRelQualifiers = this._commercePaymentMethodGroupRelQualifierLocalService.getCommercePaymentMethodGroupRelQualifiers(CommerceOrderType.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
            if (commerceOrderTypeId > 0L && ListUtil.isNotEmpty((List)commercePaymentMethodGroupRelQualifiers) && !ListUtil.exists((List)commercePaymentMethodGroupRelQualifiers, commercePaymentMethodGroupRelQualifier -> {
                long classPK = commercePaymentMethodGroupRelQualifier.getClassPK();
                return classPK == commerceOrderTypeId;
            })) continue;
            CommercePaymentIntegration commercePaymentIntegration = this._commercePaymentIntegrationRegistry.getCommercePaymentIntegration(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
            CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (commercePaymentIntegration == null && commercePaymentMethod == null || !permissionChecker.hasPermission(commercePaymentMethodGroupRel.getGroupId(), CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId(), "VIEW") || commercePaymentMethod == null && subscriptionOrder || commercePaymentMethod != null && subscriptionOrder && !commercePaymentMethod.isProcessRecurringEnabled() || commercePaymentMethod != null && !subscriptionOrder && !commercePaymentMethod.isProcessPaymentEnabled()) continue;
            filteredCommercePaymentMethodGroupRels.add(commercePaymentMethodGroupRel);
        }
        return filteredCommercePaymentMethodGroupRels;
    }

    private JSONObject _getCommerceOrderJSONObject(CommerceOrder commerceOrder, DTOConverter<?, ?> commerceOrderDTOConverter) throws Exception {
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceOrder.getCommerceOrderId(), LocaleUtil.getSiteDefault(), null, null);
        dtoConverterContext.setAttribute("secure", (Object)Boolean.FALSE);
        JSONObject commerceOrderJSONObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(commerceOrderDTOConverter.toDTO((DTOConverterContext)dtoConverterContext)));
        JSONArray commerceOrderItemsJSONArray = this._jsonFactory.createJSONArray();
        DTOConverter commerceOrderItemDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceOrderItem.class.getName());
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            dtoConverterContext = new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceOrderItem.getCommerceOrderItemId(), LocaleUtil.getSiteDefault(), null, null);
            dtoConverterContext.setAttribute("secure", (Object)Boolean.FALSE);
            JSONObject commerceOrderItemJSONObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(commerceOrderItemDTOConverter.toDTO((DTOConverterContext)dtoConverterContext)));
            commerceOrderItemsJSONArray.put(commerceOrderItemJSONObject);
        }
        commerceOrderJSONObject.put("orderItems", commerceOrderItemsJSONArray);
        return commerceOrderJSONObject;
    }

    private List<CommerceOrder> _getCommerceOrders(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrder> commerceOrders = new ArrayList<CommerceOrder>(documents.size());
        for (Document document : documents) {
            long commerceOrderId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrder commerceOrder = this.fetchCommerceOrder(commerceOrderId);
            if (commerceOrder == null) {
                commerceOrders = null;
                Indexer indexer = this._indexerRegistry.getIndexer(CommerceOrder.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrders == null) continue;
            commerceOrders.add(commerceOrder);
        }
        return commerceOrders;
    }

    private CommerceAddress _getNewCommerceAddress(String addressType, CommerceOrder commerceOrder, CommerceAddress commerceAddress, ServiceContext serviceContext) throws PortalException {
        if (commerceAddress == null) {
            return commerceAddress;
        }
        List commerceAddresses = Collections.emptyList();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceOrder.getGroupId());
        if (Objects.equals(addressType, "billing")) {
            commerceAddresses = this._commerceAddressLocalService.getBillingCommerceAddresses(commerceChannel.getCommerceChannelId(), AccountEntry.class.getName(), commerceOrder.getCommerceAccountId(), -1, -1);
        }
        if (Objects.equals(addressType, "shipping")) {
            commerceAddresses = this._commerceAddressLocalService.getShippingCommerceAddresses(commerceChannel.getCommerceChannelId(), AccountEntry.class.getName(), commerceOrder.getCommerceAccountId(), -1, -1);
        }
        for (CommerceAddress newCommerceAddress : commerceAddresses) {
            if (!commerceAddress.isSameAddress(newCommerceAddress)) continue;
            return newCommerceAddress;
        }
        return this._commerceAddressLocalService.copyCommerceAddress(commerceAddress.getCommerceAddressId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId(), serviceContext);
    }

    private long _getUserId(CommerceOrder commerceOrder) {
        User user;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && (user = this._userLocalService.fetchUser(serviceContext.getUserId())) != null) {
            return user.getUserId();
        }
        return commerceOrder.getUserId();
    }

    private boolean _hasWorkflowDefinition(long groupId, long typePK) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return false;
        }
        return this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), CommerceOrder.class.getName(), 0L, typePK);
    }

    private CommerceOrder _recalculateOrder(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder.getOrderStatus() != 2 || commerceOrder.isManuallyAdjusted()) {
            return commerceOrder;
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            this._commerceOrderItemLocalService.updateCommerceOrderItemPrice(commerceOrderItem.getCommerceOrderItemId(), commerceContext);
        }
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, false, commerceContext);
        CommerceMoney subtotalCommerceMoney = commerceOrderPrice.getSubtotal();
        CommerceMoney shippingValueCommerceMoney = commerceOrderPrice.getShippingValue();
        CommerceMoney taxValueCommerceMoney = commerceOrderPrice.getTaxValue();
        CommerceMoney totalCommerceMoney = commerceOrderPrice.getTotal();
        CommerceMoney subtotalWithTaxAmountCommerceMoney = commerceOrderPrice.getSubtotalWithTaxAmount();
        CommerceMoney shippingValueWithTaxAmountCommerceMoney = commerceOrderPrice.getShippingValueWithTaxAmount();
        CommerceMoney totalWithTaxAmountCommerceMoney = commerceOrderPrice.getTotalWithTaxAmount();
        commerceOrder.setShippingAmount(shippingValueCommerceMoney.getPrice());
        commerceOrder.setSubtotal(subtotalCommerceMoney.getPrice());
        commerceOrder.setTaxAmount(taxValueCommerceMoney.getPrice());
        commerceOrder.setTotal(totalCommerceMoney.getPrice());
        if (subtotalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmountCommerceMoney.getPrice());
        }
        if (shippingValueWithTaxAmountCommerceMoney != null) {
            commerceOrder.setShippingWithTaxAmount(shippingValueWithTaxAmountCommerceMoney.getPrice());
        }
        if (totalWithTaxAmountCommerceMoney != null) {
            commerceOrder.setTotalWithTaxAmount(totalWithTaxAmountCommerceMoney.getPrice());
        }
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValue(), false);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValue(), false);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValue(), false);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, commerceOrderPrice.getSubtotalDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderShippingDiscountValue(commerceOrder, commerceOrderPrice.getShippingDiscountValueWithTaxAmount(), true);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, commerceOrderPrice.getTotalDiscountValueWithTaxAmount(), true);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    private void _sendPaymentStatusMessage(CommerceOrder commerceOrder, CommerceOrder originalCommerceOrder, int previousPaymentStatus) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            DTOConverter commerceOrderDTOConverter = this._dtoConverterRegistry.getDTOConverter("Liferay.Headless.Commerce.Admin.Order", CommerceOrder.class.getName(), "v1.0");
            message.setPayload((Object)JSONUtil.put((String)"classPK", (Object)commerceOrder.getCommerceOrderId()).put("commerceOrder", this._getCommerceOrderJSONObject(commerceOrder, commerceOrderDTOConverter)).put("commerceOrderId", commerceOrder.getCommerceOrderId()).put("model" + CommerceOrder.class.getSimpleName(), (Object)commerceOrder.getModelAttributes()).put("modelDTO" + commerceOrderDTOConverter.getContentType(), (Object)this._commerceModelAttributesProvider.getModelAttributes((BaseModel)commerceOrder, commerceOrderDTOConverter, commerceOrder.getUserId())).put("originalCommerceOrder", (Object)originalCommerceOrder.getModelAttributes()).put("paymentStatus", commerceOrder.getPaymentStatus()).put("previousPaymentStatus", previousPaymentStatus));
            MessageBusUtil.sendMessage((String)"liferay/commerce_payment_status", (Message)message);
            return null;
        });
    }

    private void _setAccountDefaultBillingAddress(CommerceChannel commerceChannel, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.getBillingAddressId() > 0L) {
            return;
        }
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceOrder.getCommerceAccountId(), commerceChannel.getCommerceChannelId(), 2);
        if (commerceChannelAccountEntryRel == null) {
            return;
        }
        CommerceAddress commerceAddress = this._commerceAddressLocalService.getCommerceAddress(commerceChannelAccountEntryRel.getClassPK());
        if (commerceAddress == null) {
            return;
        }
        List billingCommerceAddresses = this._commerceAddressLocalService.getBillingCommerceAddresses(commerceChannel.getCommerceChannelId(), AccountEntry.class.getName(), commerceOrder.getCommerceAccountId(), -1, -1);
        if (billingCommerceAddresses.contains(commerceAddress)) {
            commerceOrder.setBillingAddressId(commerceAddress.getCommerceAddressId());
        }
    }

    private void _setAccountDefaultDeliveryTerm(CommerceChannel commerceChannel, CommerceOrder commerceOrder, User user) {
        if (commerceOrder.getDeliveryCommerceTermEntryId() > 0L) {
            return;
        }
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceOrder.getCommerceAccountId(), commerceChannel.getCommerceChannelId(), 0);
        if (commerceChannelAccountEntryRel == null) {
            return;
        }
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(commerceChannelAccountEntryRel.getClassPK());
        if (commerceChannelAccountEntryRel.isOverrideEligibility() && commerceTermEntry != null) {
            commerceOrder.setDeliveryCommerceTermEntryId(commerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setDeliveryCommerceTermEntryDescription(commerceTermEntry.getDescription(user.getLanguageId(), true));
            commerceOrder.setDeliveryCommerceTermEntryName(commerceTermEntry.getLabel(user.getLanguageId(), true));
            return;
        }
        CommerceShippingFixedOption commerceShippingFixedOption = this._commerceShippingFixedOptionLocalService.fetchCommerceShippingFixedOption(commerceOrder.getCompanyId(), commerceOrder.getShippingOptionName());
        if (commerceShippingFixedOption == null || commerceTermEntry == null) {
            return;
        }
        List deliveryCommerceTermEntries = this._commerceTermEntryLocalService.getDeliveryCommerceTermEntries(commerceOrder.getCompanyId(), commerceOrder.getCommerceOrderTypeId(), commerceShippingFixedOption.getCommerceShippingFixedOptionId());
        if (!commerceTermEntry.isActive() || !deliveryCommerceTermEntries.contains(commerceTermEntry)) {
            return;
        }
        commerceOrder.setDeliveryCommerceTermEntryId(commerceTermEntry.getCommerceTermEntryId());
        commerceOrder.setDeliveryCommerceTermEntryDescription(commerceTermEntry.getDescription(user.getLanguageId(), true));
        commerceOrder.setDeliveryCommerceTermEntryName(commerceTermEntry.getLabel(user.getLanguageId(), true));
    }

    private void _setAccountDefaultPaymentIntegrationKey(CommerceChannel commerceChannel, CommerceOrder commerceOrder) throws PortalException {
        AccountEntry accountEntry;
        if (Validator.isNotNull((String)commerceOrder.getCommercePaymentMethodKey())) {
            return;
        }
        CommerceAddress commerceAddress = commerceOrder.getBillingAddress();
        if (commerceAddress == null && (commerceAddress = commerceOrder.getShippingAddress()) == null) {
            return;
        }
        List<CommercePaymentMethodGroupRel> commercePaymentMethodGroupRels = this._filterCommercePaymentMethodGroupRels(commerceOrder.getCommerceOrderTypeId(), this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(commerceOrder.getGroupId(), commerceAddress.getCountryId(), true), commerceOrder.isSubscription());
        if (ListUtil.isEmpty(commercePaymentMethodGroupRels)) {
            return;
        }
        if (commercePaymentMethodGroupRels.size() == 1) {
            CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = commercePaymentMethodGroupRels.get(0);
            commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
        }
        if ((accountEntry = commerceOrder.getAccountEntry()) == null || accountEntry.isGuestAccount() || accountEntry.isPersonalAccount()) {
            return;
        }
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId(), 8);
        if (commerceChannelAccountEntryRel == null) {
            return;
        }
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceChannelAccountEntryRel.getClassPK());
        if (commercePaymentMethodGroupRel != null && commercePaymentMethodGroupRel.isActive() && commercePaymentMethodGroupRels.contains(commercePaymentMethodGroupRel) && Validator.isNull((String)commerceOrder.getCommercePaymentMethodKey())) {
            commerceOrder.setCommercePaymentMethodKey(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
        }
    }

    private void _setAccountDefaultPaymentTerm(CommerceChannel commerceChannel, CommerceOrder commerceOrder, User user) {
        if (commerceOrder.getPaymentCommerceTermEntryId() > 0L) {
            return;
        }
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceOrder.getCommerceAccountId(), commerceChannel.getCommerceChannelId(), 1);
        if (commerceChannelAccountEntryRel == null) {
            return;
        }
        CommerceTermEntry commerceTermEntry = this._commerceTermEntryLocalService.fetchCommerceTermEntry(commerceChannelAccountEntryRel.getClassPK());
        if (commerceChannelAccountEntryRel.isOverrideEligibility() && commerceTermEntry != null) {
            commerceOrder.setPaymentCommerceTermEntryId(commerceTermEntry.getCommerceTermEntryId());
            commerceOrder.setPaymentCommerceTermEntryDescription(commerceTermEntry.getDescription(user.getLanguageId(), true));
            commerceOrder.setPaymentCommerceTermEntryName(commerceTermEntry.getLabel(user.getLanguageId(), true));
            return;
        }
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commerceOrder.getCommercePaymentMethodKey());
        if (commercePaymentMethodGroupRel == null || commerceTermEntry == null) {
            return;
        }
        List paymentCommerceTermEntries = this._commerceTermEntryLocalService.getPaymentCommerceTermEntries(commerceOrder.getCompanyId(), commerceOrder.getCommerceOrderTypeId(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        if (!commerceTermEntry.isActive() || !paymentCommerceTermEntries.contains(commerceTermEntry)) {
            return;
        }
        commerceOrder.setPaymentCommerceTermEntryId(commerceTermEntry.getCommerceTermEntryId());
        commerceOrder.setPaymentCommerceTermEntryDescription(commerceTermEntry.getDescription(user.getLanguageId(), true));
        commerceOrder.setPaymentCommerceTermEntryName(commerceTermEntry.getLabel(user.getLanguageId(), true));
    }

    private void _setAccountDefaultShippingAddress(CommerceChannel commerceChannel, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.getShippingAddressId() > 0L) {
            return;
        }
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceOrder.getCommerceAccountId(), commerceChannel.getCommerceChannelId(), 3);
        if (commerceChannelAccountEntryRel == null) {
            return;
        }
        CommerceAddress commerceAddress = this._commerceAddressLocalService.getCommerceAddress(commerceChannelAccountEntryRel.getClassPK());
        if (commerceAddress == null) {
            return;
        }
        List shippingCommerceAddresses = this._commerceAddressLocalService.getShippingCommerceAddresses(commerceChannel.getCommerceChannelId(), AccountEntry.class.getName(), commerceOrder.getCommerceAccountId(), -1, -1);
        if (shippingCommerceAddresses.contains(commerceAddress)) {
            commerceOrder.setShippingAddressId(commerceAddress.getCommerceAddressId());
        }
    }

    private void _setAccountDefaultShippingOption(CommerceChannel commerceChannel, CommerceOrder commerceOrder, User user) throws PortalException {
        if (commerceOrder.getCommerceShippingMethodId() > 0L && Validator.isNotNull((String)commerceOrder.getShippingOptionName()) || commerceOrder.getShippingAddressId() <= 0L || !commerceOrder.isShippable()) {
            return;
        }
        AccountEntry accountEntry = commerceOrder.getAccountEntry();
        if (accountEntry == null || accountEntry.isGuestAccount() || accountEntry.isPersonalAccount()) {
            return;
        }
        CommerceShippingOptionAccountEntryRel commerceShippingOptionAccountEntryRel = this._commerceShippingOptionAccountEntryRelService.fetchCommerceShippingOptionAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId());
        if (commerceShippingOptionAccountEntryRel == null) {
            return;
        }
        List commerceShippingMethods = this._commerceShippingMethodLocalService.getCommerceShippingMethods(commerceOrder.getGroupId(), true, -1, -1, (OrderByComparator)CommerceShippingMethodPriorityComparator.getInstance((boolean)false));
        if (ListUtil.isEmpty((List)commerceShippingMethods)) {
            return;
        }
        for (CommerceShippingMethod commerceShippingMethod : commerceShippingMethods) {
            List commerceShippingOptions;
            CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(commerceShippingMethod.getEngineKey());
            if (commerceShippingEngine == null || ListUtil.isEmpty((List)(commerceShippingOptions = commerceShippingEngine.getEnabledCommerceShippingOptions(null, commerceOrder, user.getLocale())))) continue;
            CommerceShippingOption defaultCommerceShippingOption = null;
            for (CommerceShippingOption commerceShippingOption : commerceShippingOptions) {
                String key = commerceShippingOption.getKey();
                if (!key.equals(commerceShippingOptionAccountEntryRel.getCommerceShippingOptionKey())) continue;
                defaultCommerceShippingOption = commerceShippingOption;
                break;
            }
            if (defaultCommerceShippingOption == null) continue;
            commerceOrder.setCommerceShippingMethodId(commerceShippingMethod.getCommerceShippingMethodId());
            commerceOrder.setShippingAmount(defaultCommerceShippingOption.getAmount());
            commerceOrder.setShippingOptionName(defaultCommerceShippingOption.getKey());
        }
    }

    private void _setCommerceOrderPrices(CommerceOrder commerceOrder, BigDecimal shippingAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount) {
        if (shippingAmount == null) {
            shippingAmount = BigDecimal.ZERO;
        }
        if (shippingWithTaxAmount == null) {
            shippingWithTaxAmount = BigDecimal.ZERO;
        }
        if (subtotal == null) {
            subtotal = BigDecimal.ZERO;
        }
        if (subtotalWithTaxAmount == null) {
            subtotalWithTaxAmount = BigDecimal.ZERO;
        }
        if (taxAmount == null) {
            taxAmount = BigDecimal.ZERO;
        }
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (totalWithTaxAmount == null) {
            totalWithTaxAmount = BigDecimal.ZERO;
        }
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingWithTaxAmount(shippingWithTaxAmount);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setSubtotalWithTaxAmount(subtotalWithTaxAmount);
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setTotalWithTaxAmount(totalWithTaxAmount);
    }

    private void _setCommerceOrderShippingDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setShippingDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setShippingDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setShippingDiscountAmount(discountAmount);
            commerceOrder.setShippingDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setShippingDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setShippingDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setShippingDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderSubtotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setSubtotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setSubtotalDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setSubtotalDiscountAmount(discountAmount);
            commerceOrder.setSubtotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setSubtotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setSubtotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setSubtotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderTotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue, boolean withTaxAmount) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (withTaxAmount) {
            commerceOrder.setTotalDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrder.setTotalDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrder.setTotalDiscountAmount(discountAmount);
            commerceOrder.setTotalDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrder.setTotalDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrder.setTotalDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrder.setTotalDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private CommerceOrder _updateAddress(String city, Function<CommerceOrder, Long> commerceAddressIdGetter, BiConsumer<CommerceOrder, Long> commerceAddressIdSetter, long commerceOrderId, long countryId, String description, String name, String phoneNumber, long regionId, String street1, String street2, String street3, ServiceContext serviceContext, String subtype, String zip) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceAddress commerceAddress = null;
        long commerceAddressId = commerceAddressIdGetter.apply(commerceOrder);
        if (commerceAddressId > 0L) {
            commerceAddress = this._commerceAddressLocalService.getCommerceAddress(commerceAddressId);
            commerceAddress = this._commerceAddressLocalService.updateCommerceAddress(commerceAddress.getExternalReferenceCode(), commerceAddressId, countryId, regionId, city, description, name, phoneNumber, street1, street2, street3, subtype, commerceAddress.getType(), zip, serviceContext);
        } else {
            commerceAddress = this._commerceAddressLocalService.addCommerceAddress("", commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), countryId, regionId, city, description, name, phoneNumber, street1, street2, street3, subtype, 2, zip, serviceContext);
        }
        commerceAddressIdSetter.accept(commerceOrder, commerceAddress.getCommerceAddressId());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    private void _updateCommerceOrderAddresses(List<CommerceOrder> commerceOrders, long addressId) throws PortalException {
        for (CommerceOrder commerceOrder : commerceOrders) {
            long billingAddressId = commerceOrder.getBillingAddressId();
            long shippingAddressId = commerceOrder.getShippingAddressId();
            long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
            String shippingOptionName = commerceOrder.getShippingOptionName();
            BigDecimal shippingPrice = commerceOrder.getShippingAmount();
            if (billingAddressId == addressId) {
                billingAddressId = 0L;
            }
            if (shippingAddressId == addressId) {
                shippingAddressId = 0L;
                commerceShippingMethodId = 0L;
                shippingOptionName = null;
                shippingPrice = BigDecimal.ZERO;
            }
            this.commerceOrderLocalService.updateCommerceOrder(null, commerceOrder.getCommerceOrderId(), billingAddressId, commerceShippingMethodId, shippingAddressId, commerceOrder.getAdvanceStatus(), commerceOrder.getCommercePaymentMethodKey(), null, commerceOrder.getPurchaseOrderNumber(), shippingPrice, shippingOptionName, commerceOrder.getSubtotal(), commerceOrder.getTotal());
        }
    }

    private void _validateAccountLimit(long commerceChannelGroupId, long commerceAccountId) throws PortalException {
        if (CommerceOrderThreadLocal.isSkipValidateAccountLimit()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(commerceChannelGroupId);
        int pendingCommerceOrdersCount = (int)this.commerceOrderLocalService.getCommerceOrdersCount(group.getCompanyId(), commerceChannelGroupId, new long[]{commerceAccountId}, "", new int[]{2}, false);
        CommerceOrderFieldsConfiguration commerceOrderFieldsConfiguration = (CommerceOrderFieldsConfiguration)this._configurationProvider.getConfiguration(CommerceOrderFieldsConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannelGroupId, "com.liferay.commerce.order.fields"));
        if (commerceOrderFieldsConfiguration.accountCartMaxAllowed() > 0 && pendingCommerceOrdersCount >= commerceOrderFieldsConfiguration.accountCartMaxAllowed()) {
            throw new CommerceOrderAccountLimitException("The commerce account carts limit was reached");
        }
    }

    private void _validateCommerceChannelAccount(long commerceChannelGroupId, long accountEntryId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(commerceChannelGroupId);
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, commerceChannel.getCommerceChannelId(), 9);
        int count = this._commerceChannelAccountEntryRelLocalService.getCommerceChannelAccountEntryRelsCount(commerceChannel.getCommerceChannelId(), null, 9);
        if (commerceChannelAccountEntryRel == null && count != 0) {
            throw new NoSuchChannelAccountEntryRelException("This commerce account is not eligible for this commerce channel");
        }
    }

    private void _validateGuestOrders() throws PortalException {
        int count = this.commerceOrderPersistence.countByUserId(0L);
        if (count >= this._commerceOrderConfiguration.guestCartMaxAllowed()) {
            throw new GuestCartMaxAllowedException();
        }
    }

    private void _validatePurchaseOrderNumber(String purchaseOrderNumber) throws PortalException {
        if (Validator.isNull((String)purchaseOrderNumber)) {
            throw new CommerceOrderPurchaseOrderNumberException();
        }
    }
}

