/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v10_0_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CommercePermissionUpgradeProcess
extends UpgradeProcess {
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommercePermissionUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        String[] newPermissions = new String[]{"MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES"};
        this._updateCompanyRolePermissions("Operations Manager", newPermissions);
        this._updateCompanyRolePermissions("Supplier", newPermissions);
        this._updateAccountRolePermissions("Account Administrator", newPermissions);
        this._updateAccountRolePermissions("Order Manager", newPermissions);
    }

    private void _updateAccountRolePermissions(String name, String[] permissions) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select companyId, resourcePermissionId, roleId from ", "ResourcePermission where name = ", "'com.liferay.commerce.order' and scope = 3"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long roleId = resultSet.getLong(3);
                Role role = this._roleLocalService.fetchRole(resultSet.getLong(1), name);
                if (role == null || roleId != role.getRoleId()) continue;
                ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(resultSet.getLong(2));
                for (String permission : permissions) {
                    ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction("com.liferay.commerce.order", permission);
                    if (resourceAction == null || this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction)) continue;
                    resourcePermission.addResourceAction(resourceAction.getActionId());
                    this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
                }
            }
        }
    }

    private void _updateCompanyRolePermissions(String name, String[] permissions) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select companyId, resourcePermissionId, roleId from ", "ResourcePermission where name = ", "'com.liferay.commerce.order' and scope = 1"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long roleId = resultSet.getLong(3);
                Role role = this._roleLocalService.fetchRole(resultSet.getLong(1), name);
                if (role == null || roleId != role.getRoleId()) continue;
                ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(resultSet.getLong(2));
                for (String permission : permissions) {
                    ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction("com.liferay.commerce.order", permission);
                    if (resourceAction == null || this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction)) continue;
                    resourcePermission.addResourceAction(resourceAction.getActionId());
                    this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
                }
            }
        }
    }
}

