/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.subscription;

import com.liferay.commerce.configuration.CommerceSubscriptionConfiguration;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryActionHelper;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceSubscriptionEntryActionHelper.class})
public class CommerceSubscriptionEntryActionHelperImpl
implements CommerceSubscriptionEntryActionHelper {
    @Reference
    private CommerceSubscriptionEngine _commerceSubscriptionEngine;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;

    public void activateCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        if (1 != commerceSubscriptionEntry.getSubscriptionStatus()) {
            return;
        }
        this._commerceSubscriptionEngine.activateRecurringPayment(commerceSubscriptionEntryId);
    }

    public void cancelCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionConfiguration commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)this._configurationProvider.getSystemConfiguration(CommerceSubscriptionConfiguration.class);
        if (commerceSubscriptionConfiguration.subscriptionCancellationAllowed()) {
            this._commerceSubscriptionEngine.cancelRecurringPayment(commerceSubscriptionEntryId);
        }
    }

    public void suspendCommerceSubscriptionEntry(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionConfiguration commerceSubscriptionConfiguration = (CommerceSubscriptionConfiguration)this._configurationProvider.getSystemConfiguration(CommerceSubscriptionConfiguration.class);
        if (commerceSubscriptionConfiguration.subscriptionSuspensionAllowed()) {
            this._commerceSubscriptionEngine.suspendRecurringPayment(commerceSubscriptionEntryId);
        }
    }
}

