/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemTable;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderItem;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderItemResource;
import com.liferay.object.field.builder.LongIntegerObjectFieldBuilder;
import com.liferay.object.field.builder.PrecisionDecimalObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class CommerceOrderItemSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private OrderItemResource.Factory _orderItemResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        OrderItemResource orderItemResource = this._buildOrderItemResource(false, user);
        OrderItem orderItem = orderItemResource.postOrderIdOrderItem(Long.valueOf(GetterUtil.getLong((Object)values.get("orderId"))), this._toOrderItem(values));
        this.setExtendedProperties(OrderItem.class.getName(), orderItem, user, values);
        return orderItem.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commerceOrderItemLocalService.deleteCommerceOrderItem((CommerceOrderItem)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._commerceOrderItemLocalService.fetchCommerceOrderItemByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderItemLocalService.getCommerceOrderItemByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(primaryKey);
        return commerceOrderItem.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_COMMERCE_ORDER_ITEM";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Order", "headless-commerce-admin-order", "orderItems", "v1.0");
    }

    public Map<String, String> getLabelKeys() {
        return HashMapBuilder.put((Object)"label", (Object)"commerce-order-item").put((Object)"pluralLabel", (Object)"commerce-order-items").build();
    }

    public Class<?> getModelClass() {
        return CommerceOrderItem.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new LongIntegerObjectFieldBuilder().dbColumnName("orderId").labelMap(this.createLabelMap("order-id")).name("orderId").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("sku")).name("sku").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("name")).name("name").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("unit-of-measure")).name("unitOfMeasureKey").required(true).system(true).build(), new PrecisionDecimalObjectFieldBuilder().labelMap(this.createLabelMap("unit-price")).name("unitPrice").required(true).system(true).build());
    }

    public Page<?> getPage(User user, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        OrderItemResource orderItemResource = this._buildOrderItemResource(true, user);
        return orderItemResource.getOrderItemsPage(search, filter, pagination, sorts);
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommerceOrderItemTable.INSTANCE.commerceOrderItemId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommerceOrderItemTable.INSTANCE;
    }

    public int getVersion() {
        return 4;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        OrderItemResource orderItemResource = this._buildOrderItemResource(false, user);
        orderItemResource.patchOrderItem(Long.valueOf(primaryKey), this._toOrderItem(values));
        this.setExtendedProperties(OrderItem.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private OrderItemResource _buildOrderItemResource(boolean checkPermissions, User user) {
        OrderItemResource.Builder builder = this._orderItemResourceFactory.create();
        return builder.checkPermissions(checkPermissions).preferredLocale(user.getLocale()).user(user).build();
    }

    private OrderItem _toOrderItem(final Map<String, Object> values) {
        return new OrderItem(){
            {
                this.setName(() -> CommerceOrderItemSystemObjectDefinitionManager.this.getLanguageIdMap("name", values));
                this.setOrderId(() -> GetterUtil.getLong(values.get("orderId")));
                this.setSku(() -> GetterUtil.getString(values.get("sku")));
                this.setUnitOfMeasure(() -> GetterUtil.getString(values.get("unitOfMeasureKey")));
                this.setUnitPrice(() -> {
                    String unitPriceString = GetterUtil.getString(values.get("unitPrice"));
                    if (Validator.isNull((String)unitPriceString)) {
                        return null;
                    }
                    return new BigDecimal(unitPriceString);
                });
            }
        };
    }
}

