/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.ListUtil;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CommerceOrderModelListener
extends BaseModelListener<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelListener.class);
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    public void onAfterUpdate(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder) {
        block3: {
            try {
                if (originalCommerceOrder.getOrderStatus() != commerceOrder.getOrderStatus() && commerceOrder.getOrderStatus() == 15) {
                    this._commerceOrderEngine.checkCommerceOrderShipmentStatus(commerceOrder, true);
                }
                ListUtil.isNotEmptyForEach((List)originalCommerceOrder.getCustomerCommerceOrderIds(), customerCommerceOrderId -> {
                    block3: {
                        try {
                            CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(customerCommerceOrderId.longValue());
                            this._updateOrderStatus(customerCommerceOrder, commerceOrder.getOrderStatus(), originalCommerceOrder.getOrderStatus());
                            if (this._updateShippingAmount(customerCommerceOrder, commerceOrder.getShippingAmount(), originalCommerceOrder.getShippingAmount()) || this._updateShippingDiscountAmount(customerCommerceOrder, commerceOrder.getShippingDiscountAmount(), originalCommerceOrder.getShippingDiscountAmount()) || this._updateSubtotal(customerCommerceOrder, commerceOrder.getSubtotal(), originalCommerceOrder.getSubtotal()) || this._updateSubtotalDiscountAmount(customerCommerceOrder, commerceOrder.getSubtotalDiscountAmount(), originalCommerceOrder.getSubtotalDiscountAmount()) || this._updateTaxAmount(customerCommerceOrder, commerceOrder.getTaxAmount(), originalCommerceOrder.getTaxAmount()) || this._updateTotal(customerCommerceOrder, commerceOrder.getTotal(), originalCommerceOrder.getTotal()) || this._updateTotalDiscountAmount(customerCommerceOrder, commerceOrder.getTotalDiscountAmount(), originalCommerceOrder.getTotalDiscountAmount())) {
                                this._commerceOrderLocalService.updateCommerceOrder(customerCommerceOrder);
                            }
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Throwable)portalException);
                        }
                    }
                });
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private boolean _transitionOrderStatusCompleted(CommerceOrder commerceOrder) throws PortalException {
        List supplierCommerceOrderIds = commerceOrder.getSupplierCommerceOrderIds();
        if (ListUtil.isEmpty((List)supplierCommerceOrderIds)) {
            return false;
        }
        CommerceOrder firstSupplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(((Long)supplierCommerceOrderIds.get(0)).longValue());
        int orderStatus = firstSupplierCommerceOrder.getOrderStatus();
        if (supplierCommerceOrderIds.size() == 1 && orderStatus != commerceOrder.getOrderStatus()) {
            return true;
        }
        for (Long supplierCommerceOrderId : supplierCommerceOrderIds) {
            CommerceOrder supplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(supplierCommerceOrderId.longValue());
            if (orderStatus == supplierCommerceOrder.getOrderStatus()) continue;
            return false;
        }
        return true;
    }

    private void _updateOrderStatus(CommerceOrder customerCommerceOrder, int newOrderStatus, int originalOrderStatus) throws PortalException {
        if (originalOrderStatus == newOrderStatus) {
            return;
        }
        this._commerceOrderEngine.checkCommerceOrderShipmentStatus(customerCommerceOrder, false);
        if (newOrderStatus == 0 && this._transitionOrderStatusCompleted(customerCommerceOrder)) {
            this._commerceOrderEngine.transitionCommerceOrder(customerCommerceOrder, newOrderStatus, 0L, false);
        }
    }

    private boolean _updateShippingAmount(CommerceOrder customerCommerceOrder, BigDecimal newShippingAmount, BigDecimal originalShippingAmount) {
        int compareShippingAmount = originalShippingAmount.compareTo(newShippingAmount);
        if (compareShippingAmount == 0) {
            return false;
        }
        BigDecimal customerShippingAmount = customerCommerceOrder.getShippingAmount();
        BigDecimal subtractOriginalValue = customerShippingAmount.subtract(originalShippingAmount);
        customerCommerceOrder.setShippingAmount(subtractOriginalValue.add(newShippingAmount));
        return true;
    }

    private boolean _updateShippingDiscountAmount(CommerceOrder customerCommerceOrder, BigDecimal newShippingDiscountAmount, BigDecimal originalShippingDiscountAmount) {
        int compareShippingDiscountAmount = originalShippingDiscountAmount.compareTo(newShippingDiscountAmount);
        if (compareShippingDiscountAmount == 0) {
            return false;
        }
        BigDecimal customerShippingDiscountAmount = customerCommerceOrder.getShippingDiscountAmount();
        BigDecimal subtractOriginalValue = customerShippingDiscountAmount.subtract(originalShippingDiscountAmount);
        customerCommerceOrder.setShippingDiscountAmount(subtractOriginalValue.add(newShippingDiscountAmount));
        return true;
    }

    private boolean _updateSubtotal(CommerceOrder customerCommerceOrder, BigDecimal newSubtotal, BigDecimal originalSubtotal) {
        int compareSubtotal = originalSubtotal.compareTo(newSubtotal);
        if (compareSubtotal == 0) {
            return false;
        }
        BigDecimal customerSubtotal = customerCommerceOrder.getSubtotal();
        BigDecimal subtractOriginalValue = customerSubtotal.subtract(originalSubtotal);
        customerCommerceOrder.setSubtotal(subtractOriginalValue.add(newSubtotal));
        return true;
    }

    private boolean _updateSubtotalDiscountAmount(CommerceOrder customerCommerceOrder, BigDecimal newSubtotalDiscountAmount, BigDecimal originalSubtotalDiscountAmount) {
        int compareSubtotalDiscountAmount = originalSubtotalDiscountAmount.compareTo(newSubtotalDiscountAmount);
        if (compareSubtotalDiscountAmount == 0) {
            return false;
        }
        BigDecimal customerSubtotalDiscountAmount = customerCommerceOrder.getSubtotalDiscountAmount();
        BigDecimal subtractOriginalValue = customerSubtotalDiscountAmount.subtract(originalSubtotalDiscountAmount);
        customerCommerceOrder.setSubtotalDiscountAmount(subtractOriginalValue.add(newSubtotalDiscountAmount));
        return true;
    }

    private boolean _updateTaxAmount(CommerceOrder customerCommerceOrder, BigDecimal newTaxAmount, BigDecimal originalTaxAmount) {
        int compareTaxAmount = originalTaxAmount.compareTo(newTaxAmount);
        if (compareTaxAmount == 0) {
            return false;
        }
        BigDecimal customerTaxAmount = customerCommerceOrder.getTaxAmount();
        BigDecimal subtractOriginalValue = customerTaxAmount.subtract(originalTaxAmount);
        customerCommerceOrder.setTaxAmount(subtractOriginalValue.add(newTaxAmount));
        return true;
    }

    private boolean _updateTotal(CommerceOrder customerCommerceOrder, BigDecimal newTotal, BigDecimal originalTotal) {
        int compareTotal = originalTotal.compareTo(newTotal);
        if (compareTotal == 0) {
            return false;
        }
        BigDecimal customerTotal = customerCommerceOrder.getTotal();
        BigDecimal subtractOriginalValue = customerTotal.subtract(originalTotal);
        customerCommerceOrder.setTotal(subtractOriginalValue.add(newTotal));
        return true;
    }

    private boolean _updateTotalDiscountAmount(CommerceOrder customerCommerceOrder, BigDecimal newTotalDiscountAmount, BigDecimal originalTotalDiscountAmount) {
        int compareTotalDiscountAmount = originalTotalDiscountAmount.compareTo(newTotalDiscountAmount);
        if (compareTotalDiscountAmount != 0) {
            return false;
        }
        BigDecimal customerTotalDiscountAmount = customerCommerceOrder.getTotalDiscountAmount();
        BigDecimal subtractOriginalValue = customerTotalDiscountAmount.subtract(originalTotalDiscountAmount);
        customerCommerceOrder.setTotalDiscountAmount(subtractOriginalValue.add(newTotalDiscountAmount));
        return true;
    }
}

