/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.inventory;

import com.liferay.commerce.internal.inventory.BaseCommerceInventoryChecker;
import com.liferay.commerce.inventory.CommerceInventoryChecker;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"commerce.inventory.checker.target=CPDefinitionOptionValueRel"}, service={CommerceInventoryChecker.class})
public class CPDefinitionOptionValueRelCommerceInventoryCheckerImpl
extends BaseCommerceInventoryChecker<CPDefinitionOptionValueRel> {
    public List<CPDefinitionOptionValueRel> filterByAvailability(List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels) {
        return TransformUtil.transform(cpDefinitionOptionValueRels, cpDefinitionOptionValueRel -> {
            if (this.isAvailable((BaseModel<CPDefinitionOptionValueRel>)cpDefinitionOptionValueRel)) {
                return cpDefinitionOptionValueRel;
            }
            return null;
        });
    }

    public boolean isAvailable(BaseModel<CPDefinitionOptionValueRel> baseModel) {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)baseModel;
        if (Validator.isNull((String)cpDefinitionOptionValueRel.getCPInstanceUuid())) {
            return true;
        }
        BigDecimal quantity = cpDefinitionOptionValueRel.getQuantity();
        return this.isAvailable(cpDefinitionOptionValueRel.fetchCPInstance(), quantity);
    }
}

