/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.instance.lifecycle;

import com.liferay.commerce.helper.CommerceRoleHelper;
import com.liferay.commerce.helper.CommerceSAPHelper;
import com.liferay.commerce.payment.configuration.CommercePaymentEntryRefundTypeConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.IOException;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class CommerceServicePortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private CommerceRoleHelper _commerceRoleHelper;
    @Reference
    private CommerceSAPHelper _commerceSAPHelper;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        User user = this._userLocalService.getGuestUser(company.getCompanyId());
        this._commerceSAPHelper.addCommerceDefaultSAPEntries(company.getCompanyId(), user.getUserId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(company.getCompanyId());
        serviceContext.setUserId(this._getAdminUserId(company.getCompanyId()));
        serviceContext.setUuid(PortalUUIDUtil.generate());
        this._commerceRoleHelper.checkCommerceAccountRoles(serviceContext);
        try {
            Object[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((Object[])new Object[]{"(&(companyId=", company.getCompanyId(), ")(service.pid=", CommercePaymentEntryRefundTypeConfiguration.class.getName(), "*))"}));
            if (ArrayUtil.isNotEmpty((Object[])configurations)) {
                return;
            }
            this._createFactoryConfiguration(this._configurationAdmin.createFactoryConfiguration(CommercePaymentEntryRefundTypeConfiguration.class.getName(), "?"), CommercePaymentEntryRefundTypeConfiguration.class.getName(), "damaged-in-transit", "Damaged in Transit", company);
            this._createFactoryConfiguration(this._configurationAdmin.createFactoryConfiguration(CommercePaymentEntryRefundTypeConfiguration.class.getName(), "?"), CommercePaymentEntryRefundTypeConfiguration.class.getName(), "product-defect", "Product Defect", company);
            this._createFactoryConfiguration(this._configurationAdmin.createFactoryConfiguration(CommercePaymentEntryRefundTypeConfiguration.class.getName(), "?"), CommercePaymentEntryRefundTypeConfiguration.class.getName(), "return", "Return", company);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private void _createFactoryConfiguration(Configuration configuration, String factoryPid, String key, String name, Company company) throws IOException {
        configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"service.factoryPid", (Object)factoryPid).put((Object)"enabled", (Object)true).put((Object)"key", (Object)key).put((Object)"name", (Object)name).put((Object)"priority", (Object)"0").put((Object)ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), (Object)company.getCompanyId()).put((Object)"configuration.cleaner.ignore", (Object)"true").build());
    }

    private long _getAdminUserId(long companyId) throws Exception {
        Role role = this._roleLocalService.getRole(companyId, "Administrator");
        long[] userIds = this._userLocalService.getRoleUserIds(role.getRoleId());
        if (userIds.length == 0) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"No user exists in company ", companyId, " with role ", role.getName()}));
        }
        return userIds[0];
    }
}

