/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.helper;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.commerce.helper.CommerceRoleHelper;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceRoleHelper.class})
public class CommerceRoleHelperImpl
implements CommerceRoleHelper {
    private static final String[] _RETURNS_MANAGER_CONTROL_PANEL_PORTLET_IDS = new String[]{"com_liferay_commerce_payment_web_internal_portlet_CommercePaymentPortlet", "com_liferay_commerce_order_web_internal_portlet_CommerceReturnPortlet"};
    private static final String[] _RETURNS_MANAGER_LIST_TYPE_DEFINITION_EXTERNAL_REFERENCE_CODES = new String[]{"L_COMMERCE_RETURN_ITEM_STATUSES", "L_COMMERCE_RETURN_REASONS", "L_COMMERCE_RETURN_RESOLUTION_METHODS", "L_COMMERCE_RETURN_STATUSES"};
    private static final String[] _RETURNS_MANAGER_OBJECT_DEFINITION_NAMES = new String[]{"CommerceReturn", "CommerceReturnItem"};
    private static final String[] _SUPPLIER_CONTROL_PANEL_PORTLET_IDS = new String[]{"com_liferay_commerce_order_web_internal_portlet_CommerceOrderPortlet", "com_liferay_commerce_pricing_web_internal_portlet_CommercePriceListPortlet", "com_liferay_commerce_pricing_web_internal_portlet_CommercePromotionPortlet", "com_liferay_commerce_catalog_web_internal_portlet_CommerceCatalogsPortlet", "com_liferay_commerce_channel_web_internal_portlet_CommerceChannelsPortlet", "com_liferay_commerce_product_definitions_web_internal_portlet_CPDefinitionsPortlet"};
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void checkCommerceAccountRoles(ServiceContext serviceContext) throws PortalException {
        this._checkAccountRole("Account Administrator", serviceContext);
        this._checkRole("Account Manager", 3, serviceContext);
        this._checkAccountRole("Account Member", serviceContext);
        this._checkAccountRole("Buyer", serviceContext);
        this._checkAccountRole("Order Manager", serviceContext);
        this._checkAccountRole("Account Supplier", serviceContext);
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-10562")) {
            this._checkRole("Returns Manager", 1, serviceContext);
            this._checkRole("User", 1, serviceContext);
        }
        this._checkRole("Supplier", 1, serviceContext);
    }

    public void checkCommerceUserRoles(ServiceContext serviceContext) throws PortalException {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-10562")) {
            this._checkRole("User", 1, serviceContext);
        }
    }

    public boolean hasCommerceUserPermissions(long companyId) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, "User");
        for (String objectDefinitionName : _RETURNS_MANAGER_OBJECT_DEFINITION_NAMES) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(role.getCompanyId(), objectDefinitionName);
            if (objectDefinition == null || this._resourcePermissionLocalService.hasResourcePermission(companyId, objectDefinition.getResourceName(), 1, String.valueOf(companyId), role.getRoleId(), "ADD_OBJECT_ENTRY")) continue;
            return false;
        }
        for (String externalReferenceCode : _RETURNS_MANAGER_LIST_TYPE_DEFINITION_EXTERNAL_REFERENCE_CODES) {
            ListTypeDefinition listTypeDefinition = this._listTypeDefinitionLocalService.fetchListTypeDefinitionByExternalReferenceCode(externalReferenceCode, role.getCompanyId());
            if (listTypeDefinition == null || this._resourcePermissionLocalService.hasResourcePermission(companyId, listTypeDefinition.getModelClassName(), 4, String.valueOf(listTypeDefinition.getListTypeDefinitionId()), role.getRoleId(), "VIEW")) continue;
            return false;
        }
        return true;
    }

    private void _checkAccountRole(String name, ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            AccountRole accountRole = this._accountRoleLocalService.addAccountRole(null, serviceContext.getUserId(), 0L, name, Collections.singletonMap(serviceContext.getLocale(), name), Collections.emptyMap());
            role = accountRole.getRole();
            this._setRolePermissions(role, serviceContext);
        } else if ("Account Administrator".equals(name) || GetterUtil.getBoolean((Object)serviceContext.getAttribute("forceReloadPermissions"))) {
            this._setRolePermissions(role, serviceContext);
        }
    }

    private void _checkRole(String name, int type, ServiceContext serviceContext) throws PortalException {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            role = this._roleLocalService.addRole(null, serviceContext.getUserId(), null, 0L, name, Collections.singletonMap(serviceContext.getLocale(), name), Collections.emptyMap(), type, null, serviceContext);
            this._setRolePermissions(role, serviceContext);
        } else if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("forceReloadPermissions"))) {
            this._setRolePermissions(role, serviceContext);
        }
    }

    private void _setRolePermissions(long companyId, String primaryKey, Map<String, String[]> resourceActionIds, Role role, int scope) throws PortalException {
        for (Map.Entry<String, String[]> entry : resourceActionIds.entrySet()) {
            try {
                DBPartitionUtil.forEachCompanyId(company -> this._resourceActionLocalService.checkResourceActions((String)entry.getKey(), Arrays.asList((String[])entry.getValue())));
            }
            catch (Exception exception) {
                throw new PortalException((Throwable)exception);
            }
            for (String actionId : entry.getValue()) {
                this._resourcePermissionLocalService.addResourcePermission(companyId, entry.getKey(), scope, primaryKey, role.getRoleId(), actionId);
            }
        }
    }

    private void _setRolePermissions(Role role, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String[]> companyResourceActionIds = new HashMap<String, String[]>();
        HashMap<String, String[]> groupResourceActionIds = new HashMap<String, String[]>();
        String name = role.getName();
        if (name.equals("Account Administrator")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"UPDATE", "MANAGE_USERS", "VIEW", "ASSIGN_USERS", "MANAGE_ADDRESSES", "VIEW_ADDRESSES", "VIEW_ACCOUNT_ROLES", "VIEW_ORGANIZATIONS", "VIEW_USERS", "MANAGE_CHANNEL_DEFAULTS", "VIEW_CHANNEL_DEFAULTS"});
            groupResourceActionIds.put(AccountRole.class.getName(), new String[]{"VIEW"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "APPROVE_OPEN_COMMERCE_ORDERS", "CHECKOUT_OPEN_COMMERCE_ORDERS", "DELETE_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "MANAGE_COMMERCE_ORDERS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Account Manager")) {
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"UPDATE", "MANAGE_USERS", "VIEW", "MANAGE_ADDRESSES", "VIEW_ADDRESSES", "VIEW_ACCOUNT_ROLES", "VIEW_ORGANIZATIONS", "VIEW_USERS", "MANAGE_CHANNEL_DEFAULTS", "VIEW_CHANNEL_DEFAULTS"});
            groupResourceActionIds.put(AccountRole.class.getName(), new String[]{"VIEW"});
        } else if (name.equals("Account Member")) {
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"VIEW"});
        } else if (name.equals("Buyer")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"MANAGE_ADDRESSES", "VIEW_ADDRESSES"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "CHECKOUT_OPEN_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_MULTISHIPPING", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Order Manager")) {
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            groupResourceActionIds.put("com.liferay.commerce.order", new String[]{"ADD_COMMERCE_ORDER", "APPROVE_OPEN_COMMERCE_ORDERS", "CHECKOUT_OPEN_COMMERCE_ORDERS", "DELETE_COMMERCE_ORDERS", "MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_MULTISHIPPING", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS", "MANAGE_COMMERCE_ORDERS", "VIEW_BILLING_ADDRESS", "VIEW_COMMERCE_ORDERS", "VIEW_OPEN_COMMERCE_ORDERS"});
        } else if (name.equals("Account Supplier")) {
            groupResourceActionIds.put(AccountEntry.class.getName(), new String[]{"VIEW_ACCOUNT_GROUPS"});
        } else if (name.equals("Supplier")) {
            for (String portletId : _SUPPLIER_CONTROL_PANEL_PORTLET_IDS) {
                companyResourceActionIds.put(portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
            }
            companyResourceActionIds.put("90", new String[]{"VIEW_CONTROL_PANEL"});
            companyResourceActionIds.put("com.liferay.commerce.catalog", new String[]{"ADD_COMMERCE_CATALOG"});
            companyResourceActionIds.put("com.liferay.commerce.channel", new String[]{"VIEW_COMMERCE_NOTIFICATION_QUEUE_ENTRIES", "ADD_COMMERCE_NOTIFICATION_TEMPLATE"});
            companyResourceActionIds.put("com.liferay.commerce.model.CommerceOrderType", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.order", new String[]{"MANAGE_COMMERCE_ORDER_DELIVERY_TERMS", "MANAGE_COMMERCE_ORDER_NOTES", "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS", "MANAGE_COMMERCE_ORDER_PAYMENT_STATUSES", "MANAGE_COMMERCE_ORDER_PAYMENT_TERMS", "MANAGE_COMMERCE_ORDER_PRICES", "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES", "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS"});
            companyResourceActionIds.put("com.liferay.commerce.price.list", new String[]{"ADD_COMMERCE_PRICE_LIST"});
            companyResourceActionIds.put("com.liferay.commerce.pricing", new String[]{"ADD_COMMERCE_PRICING_CLASS"});
            companyResourceActionIds.put("com.liferay.commerce.pricing.model.CommercePricingClass", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.product", new String[]{"ADD_COMMERCE_PRODUCT_OPTION", "ADD_COMMERCE_PRODUCT_SPECIFICATION_OPTION", "MANAGE_COMMERCE_PRODUCT_ATTACHMENTS", "MANAGE_COMMERCE_PRODUCT_IMAGES", "MANAGE_COMMERCE_PRODUCT_MEASUREMENT_UNITS", "VIEW_COMMERCE_PRODUCT_ATTACHMENTS", "VIEW_COMMERCE_PRODUCT_IMAGES"});
            companyResourceActionIds.put("com.liferay.commerce.product.model.CPOption", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.product.model.CPOptionCategory", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.product.model.CPSpecificationOption", new String[]{"VIEW"});
            companyResourceActionIds.put("com.liferay.commerce.shipment", new String[]{"MANAGE_COMMERCE_SHIPMENTS"});
            companyResourceActionIds.put("com.liferay.commerce.tax", new String[]{"VIEW_COMMERCE_PRODUCT_TAX_CATEGORIES"});
            companyResourceActionIds.put("com.liferay.document.library", new String[]{"ADD_DOCUMENT"});
            companyResourceActionIds.put("com.liferay.expando.kernel.model.ExpandoColumn", new String[]{"VIEW"});
        } else if (name.equals("Returns Manager")) {
            for (String portletId : _RETURNS_MANAGER_CONTROL_PANEL_PORTLET_IDS) {
                companyResourceActionIds.put(portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
            }
            companyResourceActionIds.put(CommerceChannel.class.getName(), new String[]{"UPDATE", "VIEW"});
            companyResourceActionIds.put(CommercePaymentEntry.class.getName(), new String[]{"VIEW"});
            companyResourceActionIds.put("90", new String[]{"VIEW_CONTROL_PANEL"});
            companyResourceActionIds.put("com.liferay.commerce.currency", new String[]{"MANAGE_COMMERCE_CURRENCIES"});
            companyResourceActionIds.put("com.liferay.commerce.order", new String[]{"VIEW_COMMERCE_ORDERS"});
            companyResourceActionIds.put("com.liferay.commerce.payment", new String[]{"ADD_REFUND"});
            companyResourceActionIds.put("com.liferay.commerce.return", new String[]{"MANAGE_RETURNS"});
            for (String objectDefinitionName : _RETURNS_MANAGER_OBJECT_DEFINITION_NAMES) {
                ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(role.getCompanyId(), objectDefinitionName);
                if (objectDefinition == null) continue;
                companyResourceActionIds.put(objectDefinition.getResourceName(), new String[]{"ADD_OBJECT_ENTRY"});
                companyResourceActionIds.put(objectDefinition.getClassName(), new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"});
                companyResourceActionIds.put(objectDefinition.getPortletId(), new String[]{"VIEW"});
            }
        } else if (name.equals("User")) {
            for (String objectDefinitionName : _RETURNS_MANAGER_OBJECT_DEFINITION_NAMES) {
                ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(role.getCompanyId(), objectDefinitionName);
                if (objectDefinition == null) continue;
                companyResourceActionIds.put(objectDefinition.getResourceName(), new String[]{"ADD_OBJECT_ENTRY"});
            }
            for (String externalReferenceCode : _RETURNS_MANAGER_LIST_TYPE_DEFINITION_EXTERNAL_REFERENCE_CODES) {
                ListTypeDefinition listTypeDefinition = this._listTypeDefinitionLocalService.fetchListTypeDefinitionByExternalReferenceCode(externalReferenceCode, role.getCompanyId());
                if (listTypeDefinition == null) continue;
                this._resourcePermissionLocalService.setResourcePermissions(serviceContext.getCompanyId(), listTypeDefinition.getModelClassName(), 4, String.valueOf(listTypeDefinition.getListTypeDefinitionId()), role.getRoleId(), new String[]{"VIEW"});
            }
        }
        this._setRolePermissions(serviceContext.getCompanyId(), String.valueOf(serviceContext.getCompanyId()), companyResourceActionIds, role, 1);
        this._setRolePermissions(serviceContext.getCompanyId(), String.valueOf(0L), groupResourceActionIds, role, 3);
    }
}

