/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentExpectedDateException;
import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentShippingDateException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.service.base.CommerceShipmentLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Callable;

public class CommerceShipmentLocalServiceImpl
extends CommerceShipmentLocalServiceBaseImpl {
    protected int[] messageShipmentStatuses = new int[]{2, 3};

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceDeliverySubscriptionShipment(long userId, long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceOrder.getCommerceAccountId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        CommerceAddress commerceAddress = this.updateCommerceShipmentAddress(commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, null);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceShipment(long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setGroupId(groupId);
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceAccountId);
        commerceShipment.setCommerceAddressId(commerceAddressId);
        commerceShipment.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceShipment.setShippingOptionName(commerceShippingOptionName);
        commerceShipment.setStatus(0);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrder.getGroupId(), commerceOrder.getCommerceAccountId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addDeliverySubscriptionCommerceShipment(long userId, long commerceOrderItemId) throws PortalException {
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        User user = this.userLocalService.getUser(userId);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceOrder.getCommerceAccountId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        commerceShipment = (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
        this.commerceShipmentItemLocalService.addDeliverySubscriptionCommerceShipmentItem(commerceOrder.getScopeGroupId(), userId, commerceShipmentId, commerceOrderItemId);
        return commerceShipment;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipment deleteCommerceShipment(CommerceShipment commerceShipment, boolean restoreStockQuantity) throws PortalException {
        this.commerceShipmentItemLocalService.deleteCommerceShipmentItems(commerceShipment.getCommerceShipmentId(), restoreStockQuantity);
        return (CommerceShipment)this.commerceShipmentPersistence.remove((BaseModel)commerceShipment);
    }

    @Override
    public CommerceShipment deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        return this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public List<CommerceShipment> getCommerceShipments(long commerceOrderId, int start, int end) {
        return this.commerceShipmentFinder.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, commerceAccountIds, keywords, excludeShipmentStatus, shipmentStatuses, start, end);
        BaseModelSearchResult<CommerceShipment> baseModelSearchResult = this.searchCommerceShipments(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_S(groupIds, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByGroupIds(groupIds, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_C(groupIds, commerceAddressId, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCount(long commerceOrderId) {
        return this.commerceShipmentFinder.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, commerceAccountIds, keywords, excludeShipmentStatus, shipmentStatuses, -1, -1);
        BaseModelSearchResult<CommerceShipment> baseModelSearchResult = this.searchCommerceShipments(searchContext);
        return baseModelSearchResult.getLength();
    }

    public int getCommerceShipmentsCount(long[] groupIds) {
        return this.commerceShipmentPersistence.countByGroupIds(groupIds);
    }

    public int getCommerceShipmentsCount(long[] groupIds, int status) {
        return this.commerceShipmentPersistence.countByG_S(groupIds, status);
    }

    public int getCommerceShipmentsCount(long[] groupIds, long commerceAddressId) {
        return this.commerceShipmentPersistence.countByG_C(groupIds, commerceAddressId);
    }

    public int[] getCommerceShipmentStatusesByCommerceOrderId(long commerceOrderId) {
        return this.commerceShipmentFinder.findCommerceShipmentStatusesByCommerceOrderId(commerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment reprocessCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        if (commerceShipment.getStatus() == 3) {
            throw new CommerceShipmentStatusException();
        }
        commerceShipment.setStatus(0);
        if (ArrayUtil.contains((int[])this.messageShipmentStatuses, (int)0)) {
            this.sendShipmentStatusMessage(commerceShipmentId);
        }
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public BaseModelSearchResult<CommerceShipment> searchCommerceShipments(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceShipment.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceShipment> commerceShipments = this.getCommerceShipments(hits);
            if (commerceShipments == null) continue;
            return new BaseModelSearchResult(commerceShipments, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceShipmentsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceShipment.class.getName());
        return indexer.searchCount(searchContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber) throws PortalException {
        return this.updateAddress(commerceShipmentId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        CommerceAddress commerceAddress = this.updateCommerceShipmentAddress(commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCarrierDetails(long commerceShipmentId, String carrier, String trackingNumber) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        String name = null;
        String description = null;
        String street1 = null;
        String street2 = null;
        String street3 = null;
        String city = null;
        String zip = null;
        long regionId = 0L;
        long countryId = 0L;
        String phoneNumber = null;
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        CommerceAddress commerceAddress = commerceShipment.fetchCommerceAddress();
        if (commerceAddress != null) {
            name = commerceAddress.getName();
            description = commerceAddress.getDescription();
            street1 = commerceAddress.getStreet1();
            street2 = commerceAddress.getStreet2();
            street3 = commerceAddress.getStreet3();
            city = commerceAddress.getCity();
            zip = commerceAddress.getZip();
            regionId = commerceAddress.getRegionId();
            countryId = commerceAddress.getCountryId();
            phoneNumber = commerceAddress.getPhoneNumber();
        }
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this.userLocalService.getUser(commerceShipment.getUserId());
        int oldStatus = commerceShipment.getStatus();
        this.validate(status, oldStatus);
        Date shippingDate = PortalUtil.getDate((int)shippingDateMonth, (int)shippingDateDay, (int)shippingDateYear, (int)shippingDateHour, (int)shippingDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentShippingDateException.class);
        Date expectedDate = PortalUtil.getDate((int)expectedDateMonth, (int)expectedDateDay, (int)expectedDateYear, (int)expectedDateHour, (int)expectedDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentExpectedDateException.class);
        CommerceAddress commerceAddress = this.updateCommerceShipmentAddress(commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, null);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        commerceShipment.setShippingDate(shippingDate);
        commerceShipment.setExpectedDate(expectedDate);
        commerceShipment.setStatus(status);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this.userLocalService.getUser(commerceShipment.getUserId());
        Date expectedDate = PortalUtil.getDate((int)expectedDateMonth, (int)expectedDateDay, (int)expectedDateYear, (int)expectedDateHour, (int)expectedDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentShippingDateException.class);
        commerceShipment.setExpectedDate(expectedDate);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this.userLocalService.getUser(commerceShipment.getUserId());
        Date shippingDate = PortalUtil.getDate((int)shippingDateMonth, (int)shippingDateDay, (int)shippingDateYear, (int)shippingDateHour, (int)shippingDateMinute, (TimeZone)user.getTimeZone(), CommerceShipmentShippingDateException.class);
        commerceShipment.setShippingDate(shippingDate);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        List commerceShipmentItems = this.commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, -1, -1, null);
        if (commerceShipmentItems.isEmpty()) {
            throw new CommerceShipmentItemQuantityException();
        }
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            if (commerceShipmentItem.getQuantity() >= 1 && commerceShipmentItem.getCommerceInventoryWarehouseId() > 0L) continue;
            throw new CommerceShipmentStatusException();
        }
        commerceShipment.setStatus(status);
        if (ArrayUtil.contains((int[])this.messageShipmentStatuses, (int)status)) {
            this.sendShipmentStatusMessage(commerceShipmentId);
        }
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, boolean negated, int[] shipmentStatuses, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (shipmentStatuses != null) {
            searchContext.setAttribute("negateShipmentStatuses", (Serializable)Boolean.valueOf(negated));
            searchContext.setAttribute("shipmentStatues", (Serializable)shipmentStatuses);
        }
        if (commerceAccountIds != null) {
            searchContext.setAttribute("commerceAccountIds", (Serializable)commerceAccountIds);
        }
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(keywords);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceShipment> getCommerceShipments(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceShipment> commerceShipments = new ArrayList<CommerceShipment>(documents.size());
        for (Document document : documents) {
            long commerceShipmentId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceShipment commerceShipment = this.fetchCommerceShipment(commerceShipmentId);
            if (commerceShipment == null) {
                commerceShipments = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceShipment.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceShipments == null) continue;
            commerceShipments.add(commerceShipment);
        }
        return commerceShipments;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    protected void sendShipmentStatusMessage(final long commerceShipmentId) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("commerceShipmentId", (Object)commerceShipmentId);
                MessageBusUtil.sendMessage((String)"liferay/shipment_status", (Message)message);
                return null;
            }
        });
    }

    protected CommerceAddress updateCommerceShipmentAddress(CommerceShipment commerceShipment, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress;
        if (serviceContext == null) {
            serviceContext = ServiceContextThreadLocal.getServiceContext();
        }
        if (Objects.equals(name, (commerceAddress = commerceShipment.fetchCommerceAddress()).getName()) && Objects.equals(description, commerceAddress.getDescription()) && Objects.equals(street1, commerceAddress.getStreet1()) && Objects.equals(street2, commerceAddress.getStreet2()) && Objects.equals(street3, commerceAddress.getStreet3()) && Objects.equals(city, commerceAddress.getCity()) && Objects.equals(zip, commerceAddress.getZip()) && Objects.equals(regionId, commerceAddress.getRegionId()) && Objects.equals(countryId, commerceAddress.getCountryId()) && Objects.equals(phoneNumber, commerceAddress.getPhoneNumber())) {
            return commerceAddress;
        }
        return this.commerceAddressLocalService.addCommerceAddress(commerceShipment.getModelClassName(), commerceShipment.getCommerceShipmentId(), name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, 2, serviceContext);
    }

    protected void validate(int status, int oldStatus) throws PortalException {
        if (status < oldStatus) {
            throw new CommerceShipmentStatusException();
        }
    }
}

