/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v6_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.RegionLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class CommerceRegionUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"CommerceAddress", "CommerceTaxFixedRateAddressRel", "CShippingFixedOptionRel"};

    protected void doUpgrade() throws Exception {
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet rs = selectStatement.executeQuery("select * from CommerceRegion order by commerceRegionId asc");
            while (rs.next()) {
                boolean active = rs.getBoolean("active_");
                String code = rs.getString("code_");
                long commerceCountryId = rs.getLong("commerceCountryId");
                long commerceRegionId = rs.getLong("commerceRegionId");
                Timestamp lastPublishDate = rs.getTimestamp("lastPublishDate");
                String name = rs.getString("name");
                Double priority = rs.getDouble("priority");
                Region region = RegionLocalServiceUtil.fetchRegion((long)commerceCountryId, (String)code);
                region = region != null ? this._updateRegion(region, active, name, priority, code, lastPublishDate) : this._addRegion(commerceRegionId, rs.getLong("companyId"), rs.getLong("userId"), rs.getString("userName"), rs.getTimestamp("createDate"), rs.getTimestamp("modifiedDate"), commerceCountryId, active, name, priority, code, lastPublishDate);
                if (region.getRegionId() == commerceRegionId) continue;
                for (String tableName : _TABLE_NAMES) {
                    this._updateRegionId(tableName, region.getRegionId(), commerceRegionId);
                }
            }
            this.runSQL("drop table CommerceRegion");
        }
    }

    private Region _addRegion(long regionId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long countryId, boolean active, String name, Double position, String regionCode, Date lastPublishDate) {
        if (RegionLocalServiceUtil.fetchRegion((long)regionId) != null) {
            regionId = this.increment();
        }
        Region region = RegionLocalServiceUtil.createRegion((long)regionId);
        region.setCompanyId(companyId);
        region.setUserId(userId);
        region.setUserName(userName);
        region.setCreateDate(createDate);
        region.setModifiedDate(modifiedDate);
        region.setCountryId(countryId);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position.doubleValue());
        region.setRegionCode(regionCode);
        region.setLastPublishDate(lastPublishDate);
        return RegionLocalServiceUtil.addRegion((Region)region);
    }

    private Region _updateRegion(Region region, boolean active, String name, Double position, String regionCode, Date lastPublishDate) {
        region.setActive(active);
        region.setName(name);
        region.setPosition(position.doubleValue());
        region.setRegionCode(regionCode);
        region.setLastPublishDate(lastPublishDate);
        return RegionLocalServiceUtil.updateRegion((Region)region);
    }

    private void _updateRegionId(String tableName, long newRegionId, long oldRegionId) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set regionId = ");
        sb.append(newRegionId);
        sb.append(" where regionId = ");
        sb.append(oldRegionId);
        this.runSQL(sb.toString());
    }
}

