/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v6_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class CommerceCountryUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"CommerceAddress", "CommerceAddressRestriction", "CommerceRegion", "CommerceTaxFixedRateAddressRel", "CShippingFixedOptionRel"};

    protected void doUpgrade() throws Exception {
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet rs = selectStatement.executeQuery("select * from CommerceCountry order by commerceCountryId asc");
            while (rs.next()) {
                String a2 = rs.getString("twoLettersISOCode");
                String a3 = rs.getString("threeLettersISOCode");
                boolean active = rs.getBoolean("active_");
                boolean billingAllowed = rs.getBoolean("billingAllowed");
                boolean channelFilterEnabled = rs.getBoolean("channelFilterEnabled");
                long commerceCountryId = rs.getLong("commerceCountryId");
                long companyId = rs.getLong("companyId");
                Timestamp lastPublishDate = rs.getTimestamp("lastPublishDate");
                String name = rs.getString("name");
                String numericISOCode = rs.getString("numericISOCode");
                Double priority = rs.getDouble("priority");
                boolean shippingAllowed = rs.getBoolean("shippingAllowed");
                boolean subjectToVAT = rs.getBoolean("subjectToVAT");
                Country country = CountryLocalServiceUtil.fetchCountryByA2((long)companyId, (String)a2);
                country = country != null ? this._updateCountry(country, a2, a3, active, billingAllowed, channelFilterEnabled, name, numericISOCode, priority, shippingAllowed, subjectToVAT, lastPublishDate) : this._addCountry(commerceCountryId, companyId, rs.getLong("userId"), rs.getString("userName"), rs.getTimestamp("createDate"), rs.getTimestamp("modifiedDate"), a2, a3, active, billingAllowed, channelFilterEnabled, name, numericISOCode, priority, shippingAllowed, subjectToVAT, lastPublishDate);
                if (country.getCountryId() == commerceCountryId) continue;
                for (String tableName : _TABLE_NAMES) {
                    this._updateCountryId(tableName, country.getCountryId(), commerceCountryId);
                }
            }
            this.runSQL("drop table CommerceCountry");
        }
    }

    private Country _addCountry(long countryId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, String a2, String a3, boolean active, boolean billingAllowed, boolean groupFilterEnabled, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, Date lastPublishDate) throws Exception {
        if (CountryLocalServiceUtil.fetchCountry((long)countryId) != null) {
            countryId = this.increment();
        }
        Country country = CountryLocalServiceUtil.createCountry((long)countryId);
        country.setCompanyId(companyId);
        country.setUserId(userId);
        country.setUserName(userName);
        country.setCreateDate(createDate);
        country.setModifiedDate(modifiedDate);
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setDefaultLanguageId(LocalizationUtil.getDefaultLanguageId((String)name));
        country.setGroupFilterEnabled(groupFilterEnabled);
        country.setName(LocalizationUtil.getLocalization((String)name, (String)LocalizationUtil.getDefaultLanguageId((String)name)));
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        country.setLastPublishDate(lastPublishDate);
        CountryLocalServiceUtil.addCountry((Country)country);
        for (String languageId : LocalizationUtil.getAvailableLanguageIds((String)name)) {
            CountryLocalServiceUtil.updateCountryLocalization((Country)country, (String)languageId, (String)LocalizationUtil.getLocalization((String)name, (String)languageId));
        }
        return country;
    }

    private Country _updateCountry(Country country, String a2, String a3, boolean active, boolean billingAllowed, boolean groupFilterEnabled, String name, String number, double position, boolean shippingAllowed, boolean subjectToVAT, Date lastPublishDate) throws Exception {
        country.setA2(a2);
        country.setA3(a3);
        country.setActive(active);
        country.setBillingAllowed(billingAllowed);
        country.setDefaultLanguageId(LocalizationUtil.getDefaultLanguageId((String)name));
        country.setGroupFilterEnabled(groupFilterEnabled);
        country.setName(LocalizationUtil.getLocalization((String)name, (String)LocalizationUtil.getDefaultLanguageId((String)name)));
        country.setNumber(number);
        country.setPosition(position);
        country.setShippingAllowed(shippingAllowed);
        country.setSubjectToVAT(subjectToVAT);
        country.setLastPublishDate(lastPublishDate);
        for (String languageId : LocalizationUtil.getAvailableLanguageIds((String)name)) {
            CountryLocalServiceUtil.updateCountryLocalization((Country)country, (String)languageId, (String)LocalizationUtil.getLocalization((String)name, (String)languageId));
        }
        return CountryLocalServiceUtil.updateCountry((Country)country);
    }

    private void _updateCountryId(String tableName, long newCountryId, long oldCountryId) throws Exception {
        String columnName = "countryId";
        if (tableName.equals("CommerceRegion")) {
            columnName = "commerceCountryId";
        }
        StringBundler sb = new StringBundler(10);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set ");
        sb.append(columnName);
        sb.append(" = ");
        sb.append(newCountryId);
        sb.append(" where ");
        sb.append(columnName);
        sb.append(" = ");
        sb.append(oldCountryId);
        this.runSQL(sb.toString());
    }
}

