/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v4_10_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.internal.upgrade.v4_10_0.util.CommerceOrderItemTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommerceOrderItemUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "deliveryMaxSubscriptionCycles", "LONG");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "deliverySubscriptionLength", "INTEGER");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "deliverySubscriptionType", "VARCHAR(75)");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "deliverySubTypeSettings", "VARCHAR(75)");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "depth", "DOUBLE");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "freeShipping", "BOOLEAN");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "height", "DOUBLE");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "maxSubscriptionCycles", "LONG");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "shipSeparately", "BOOLEAN");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "shippable", "BOOLEAN");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "shippingExtraPrice", "DOUBLE");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "subscriptionLength", "INTEGER");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "subscriptionType", "VARCHAR(75)");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "subscriptionTypeSettings", "VARCHAR(75)");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "weight", "DOUBLE");
        this.addColumn(CommerceOrderItemTable.class, "CommerceOrderItem", "width", "DOUBLE");
        String updateCommerceOrderItemSQL = StringBundler.concat((String[])new String[]{"update CommerceOrderItem SET shippable = ?, freeShipping = ?, ", "shipSeparately = ?, shippingExtraPrice = ?, width = ?, height = ", "?, depth = ?, weight = ?, subscriptionLength = ?, ", "subscriptionType = ?, subscriptionTypeSettings = ?, ", "maxSubscriptionCycles = ?, deliverySubscriptionLength = ?, ", "deliverySubscriptionType = ?, deliverySubTypeSettings = ?, ", "deliveryMaxSubscriptionCycles = ? where CPInstanceId = ? and ", "commerceOrderItemId = ?"});
        String getCPInstanceSQL = StringBundler.concat((String[])new String[]{"select  CPInstance.CPInstanceId, CPDefinition.shippable, ", "CPDefinition.freeShipping, CPDefinition.shipSeparately, ", "CPDefinition.shippingExtraPrice, CPDefinition.width, ", "CPDefinition.height, CPDefinition.depth, CPDefinition.weight, ", "CPDefinition.subscriptionLength, CPDefinition.subscriptionType, ", "CPDefinition.subscriptionTypeSettings, ", "CPDefinition.maxSubscriptionCycles, ", "CPDefinition.deliverySubscriptionLength, ", "CPDefinition.deliverySubscriptionType, ", "CPDefinition.deliverySubTypeSettings, ", "CPDefinition.deliveryMaxSubscriptionCycles, ", "CPInstance.overrideSubscriptionInfo, CPInstance.width, ", "CPInstance.height, CPInstance.depth, CPInstance.weight, ", "CPInstance.subscriptionLength, CPInstance.subscriptionType, ", "CPInstance.subscriptionTypeSettings, ", "CPInstance.maxSubscriptionCycles, ", "CPInstance.deliverySubscriptionLength, ", "CPInstance.deliverySubscriptionType, ", "CPInstance.deliverySubTypeSettings, ", "CPInstance.deliveryMaxSubscriptionCycles, ", "CommerceOrderItem.commerceOrderItemId from CPInstance join ", "CPDefinition on CPInstance.CPDefinitionId = ", "CPDefinition.CPDefinitionId join CommerceOrderItem on ", "CPInstance.CPInstanceId = CommerceOrderItem.CPInstanceId join ", "CommerceOrder on CommerceOrder.commerceOrderId = ", "CommerceOrderItem.commerceOrderId and CommerceOrder.orderStatus ", "= 2"});
        try (PreparedStatement ps1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCommerceOrderItemSQL);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet rs = s.executeQuery(getCPInstanceSQL);){
            while (rs.next()) {
                double weight;
                double depth;
                double height;
                long cpInstanceId = rs.getLong(1);
                boolean shippable = rs.getBoolean(2);
                boolean freeShipping = rs.getBoolean(3);
                boolean shipSeparately = rs.getBoolean(4);
                double shippingExtraPrice = rs.getDouble(5);
                double width = rs.getDouble(19);
                if (width <= 0.0) {
                    width = rs.getDouble(6);
                }
                if ((height = rs.getDouble(20)) <= 0.0) {
                    height = rs.getDouble(7);
                }
                if ((depth = rs.getDouble(21)) <= 0.0) {
                    depth = rs.getDouble(8);
                }
                if ((weight = rs.getDouble(22)) <= 0.0) {
                    weight = rs.getDouble(9);
                }
                int subscriptionLength = rs.getInt(10);
                String subscriptionType = rs.getString(11);
                String subscriptionTypeSettings = rs.getString(12);
                long maxSubscriptionCycles = rs.getLong(13);
                int deliverySubscriptionLength = rs.getInt(14);
                String deliverySubscriptionType = rs.getString(15);
                String deliverySubscriptionTypeSettings = rs.getString(16);
                long deliveryMaxSubscriptionCycles = rs.getLong(17);
                boolean overrideSubscription = rs.getBoolean(18);
                if (overrideSubscription) {
                    subscriptionLength = rs.getInt(23);
                    subscriptionType = rs.getString(24);
                    subscriptionTypeSettings = rs.getString(25);
                    maxSubscriptionCycles = rs.getLong(26);
                    deliverySubscriptionLength = rs.getInt(27);
                    deliverySubscriptionType = rs.getString(28);
                    deliverySubscriptionTypeSettings = rs.getString(29);
                    deliveryMaxSubscriptionCycles = rs.getLong(30);
                }
                long commerceOrderItemId = rs.getLong(31);
                ps1.setBoolean(1, shippable);
                ps1.setBoolean(2, freeShipping);
                ps1.setBoolean(3, shipSeparately);
                ps1.setDouble(4, shippingExtraPrice);
                ps1.setDouble(5, width);
                ps1.setDouble(6, height);
                ps1.setDouble(7, depth);
                ps1.setDouble(8, weight);
                ps1.setInt(9, subscriptionLength);
                ps1.setString(10, subscriptionType);
                ps1.setString(11, subscriptionTypeSettings);
                ps1.setLong(12, maxSubscriptionCycles);
                ps1.setInt(13, deliverySubscriptionLength);
                ps1.setString(14, deliverySubscriptionType);
                ps1.setString(15, deliverySubscriptionTypeSettings);
                ps1.setLong(16, deliveryMaxSubscriptionCycles);
                ps1.setLong(17, cpInstanceId);
                ps1.setLong(18, commerceOrderItemId);
                ps1.addBatch();
            }
            ps1.executeBatch();
        }
    }
}

