/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"key=login.events.post"}, service={LifecycleAction.class})
public class LoginPostAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(LoginPostAction.class);
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            Cookie[] cookies = httpServletRequest.getCookies();
            if (cookies == null) {
                return;
            }
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!name.startsWith(CommerceOrder.class.getName() + "#")) continue;
                HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
                HttpSession httpSession = originalHttpServletRequest.getSession();
                httpSession.setAttribute(name, (Object)cookie.getValue());
                break;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

