/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceShipmentExpectedDateException;
import com.liferay.commerce.exception.CommerceShipmentItemQuantityException;
import com.liferay.commerce.exception.CommerceShipmentShippingDateException;
import com.liferay.commerce.exception.CommerceShipmentStatusException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.attributes.provider.CommerceModelAttributesProvider;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShipmentItemLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.service.base.CommerceShipmentLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceShipment"}, service={AopService.class})
public class CommerceShipmentLocalServiceImpl
extends CommerceShipmentLocalServiceBaseImpl {
    protected int[] messageShipmentStatuses = new int[]{2, 3};
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceModelAttributesProvider _commerceModelAttributesProvider;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceShipmentItemLocalService _commerceShipmentItemLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceDeliverySubscriptionShipment(long userId, long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceOrder.getCommerceAccountId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        CommerceAddress commerceAddress = this._updateCommerceShipmentAddress(null, commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, null);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        return this.commerceShipmentLocalService.addCommerceShipment(null, commerceOrder.getGroupId(), commerceOrder.getCommerceAccountId(), commerceOrder.getShippingAddressId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addCommerceShipment(String externalReferenceCode, long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        commerceShipment.setExternalReferenceCode(externalReferenceCode);
        commerceShipment.setGroupId(groupId);
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceAccountId);
        commerceShipment.setCommerceAddressId(commerceAddressId);
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.fetchCommerceShippingMethod(commerceShippingMethodId);
        if (commerceShippingMethod != null) {
            commerceShipment.setCommerceShippingMethodId(commerceShippingMethodId);
            commerceShipment.setShippingOptionName(commerceShippingOptionName);
            commerceShipment.setTrackingURL(commerceShippingMethod.getTrackingURL());
        }
        commerceShipment.setStatus(0);
        commerceShipment.setExpandoBridgeAttributes(serviceContext);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment addDeliverySubscriptionCommerceShipment(long userId, long commerceOrderItemId) throws PortalException {
        long commerceShipmentId = this.counterLocalService.increment();
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.create(commerceShipmentId);
        User user = this._userLocalService.getUser(userId);
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        commerceShipment.setGroupId(commerceOrder.getGroupId());
        commerceShipment.setCompanyId(user.getCompanyId());
        commerceShipment.setUserId(user.getUserId());
        commerceShipment.setUserName(user.getFullName());
        commerceShipment.setCommerceAccountId(commerceOrder.getCommerceAccountId());
        commerceShipment.setCommerceAddressId(commerceOrder.getShippingAddressId());
        commerceShipment.setCommerceShippingMethodId(commerceOrder.getCommerceShippingMethodId());
        commerceShipment.setShippingOptionName(commerceOrder.getShippingOptionName());
        commerceShipment.setStatus(0);
        commerceShipment = (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
        this._commerceShipmentItemLocalService.addDeliverySubscriptionCommerceShipmentItem(commerceOrder.getScopeGroupId(), userId, commerceShipmentId, commerceOrderItemId);
        return commerceShipment;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceShipment deleteCommerceShipment(CommerceShipment commerceShipment, boolean restoreStockQuantity) throws PortalException {
        commerceShipment = (CommerceShipment)this.commerceShipmentPersistence.remove((BaseModel)commerceShipment);
        this._commerceShipmentItemLocalService.deleteCommerceShipmentItems(commerceShipment.getCommerceShipmentId(), restoreStockQuantity);
        this._expandoRowLocalService.deleteRows(commerceShipment.getCommerceShipmentId());
        return commerceShipment;
    }

    @Override
    public CommerceShipment deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        return this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public List<CommerceShipment> getCommerceShipments(long commerceOrderId, int start, int end) {
        return this.commerceShipmentFinder.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupIds, commerceAccountIds, keywords, excludeShipmentStatus, shipmentStatuses, start, end);
        BaseModelSearchResult<CommerceShipment> baseModelSearchResult = this.searchCommerceShipments(searchContext);
        return baseModelSearchResult.getBaseModels();
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_S(groupIds, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByGroupId(groupIds, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipments(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.commerceShipmentPersistence.findByG_C(groupIds, commerceAddressId, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCount(long commerceOrderId) {
        return this.commerceShipmentFinder.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, groupIds, commerceAccountIds, keywords, excludeShipmentStatus, shipmentStatuses, -1, -1);
        BaseModelSearchResult<CommerceShipment> baseModelSearchResult = this.searchCommerceShipments(searchContext);
        return baseModelSearchResult.getLength();
    }

    public int getCommerceShipmentsCount(long[] groupIds) {
        return this.commerceShipmentPersistence.countByGroupId(groupIds);
    }

    public int getCommerceShipmentsCount(long[] groupIds, int status) {
        return this.commerceShipmentPersistence.countByG_S(groupIds, status);
    }

    public int getCommerceShipmentsCount(long[] groupIds, long commerceAddressId) {
        return this.commerceShipmentPersistence.countByG_C(groupIds, commerceAddressId);
    }

    public int[] getCommerceShipmentStatusesByCommerceOrderId(long commerceOrderId) {
        return this.commerceShipmentFinder.findCommerceShipmentStatusesByCommerceOrderId(commerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment reprocessCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        if (commerceShipment.getStatus() == 3) {
            throw new CommerceShipmentStatusException();
        }
        commerceShipment.setStatus(0);
        if (ArrayUtil.contains((int[])this.messageShipmentStatuses, (int)0)) {
            this.sendShipmentStatusMessage(commerceShipment);
        }
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public BaseModelSearchResult<CommerceShipment> searchCommerceShipments(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceShipment.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceShipment> commerceShipments = this._getCommerceShipments(hits);
            if (commerceShipments == null) continue;
            return new BaseModelSearchResult(commerceShipments, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceShipmentsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceShipment.class.getName());
        return indexer.searchCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateAddress(String externalReferenceCode, long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        CommerceAddress commerceAddress = this._updateCommerceShipmentAddress(externalReferenceCode, commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCarrierDetails(long commerceShipmentId, long commerceShippingMethodId, String carrier, String trackingNumber, String trackingURL) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        if (commerceShipment.getCommerceShippingMethodId() != commerceShippingMethodId) {
            commerceShipment.setCommerceShippingMethodId(commerceShippingMethodId);
            commerceShipment.setShippingOptionName(null);
        }
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        commerceShipment.setTrackingURL(trackingURL);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, ServiceContext serviceContext) throws PortalException {
        String name = null;
        String description = null;
        String street1 = null;
        String street2 = null;
        String street3 = null;
        String city = null;
        String zip = null;
        long regionId = 0L;
        long countryId = 0L;
        String phoneNumber = null;
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        CommerceAddress commerceAddress = commerceShipment.fetchCommerceAddress();
        if (commerceAddress != null) {
            name = commerceAddress.getName();
            description = commerceAddress.getDescription();
            street1 = commerceAddress.getStreet1();
            street2 = commerceAddress.getStreet2();
            street3 = commerceAddress.getStreet3();
            city = commerceAddress.getCity();
            zip = commerceAddress.getZip();
            regionId = commerceAddress.getRegionId();
            countryId = commerceAddress.getCountryId();
            phoneNumber = commerceAddress.getPhoneNumber();
        }
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, commerceShippingMethodId, carrier, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, trackingNumber, trackingURL, status, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        Date expectedDate;
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        int oldStatus = commerceShipment.getStatus();
        this._validateStatus(status, oldStatus);
        if (commerceShipment.getCommerceShippingMethodId() != commerceShippingMethodId) {
            commerceShipment.setCommerceShippingMethodId(commerceShippingMethodId);
            commerceShipment.setShippingOptionName(null);
        }
        CommerceAddress commerceAddress = this._updateCommerceShipmentAddress(null, commerceShipment, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
        commerceShipment.setCommerceAddressId(commerceAddress.getCommerceAddressId());
        commerceShipment.setCarrier(carrier);
        commerceShipment.setTrackingNumber(trackingNumber);
        commerceShipment.setTrackingURL(trackingURL);
        Date shippingDate = this._getDate(shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, user.getTimeZone(), CommerceShipmentShippingDateException.class);
        if (shippingDate != null) {
            commerceShipment.setShippingDate(shippingDate);
        }
        if ((expectedDate = this._getDate(expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, user.getTimeZone(), CommerceShipmentExpectedDateException.class)) != null) {
            commerceShipment.setExpectedDate(expectedDate);
        }
        commerceShipment.setStatus(status);
        commerceShipment.setExpandoBridgeAttributes(serviceContext);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this._userLocalService.getUser(commerceShipment.getUserId());
        commerceShipment.setExpectedDate(this._getDate(expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, user.getTimeZone(), CommerceShipmentShippingDateException.class));
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateExternalReferenceCode(long commerceShipmentId, String externalReferenceCode) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        if (Objects.equals(commerceShipment.getExternalReferenceCode(), externalReferenceCode)) {
            return commerceShipment;
        }
        commerceShipment.setExternalReferenceCode(externalReferenceCode);
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        User user = this._userLocalService.getUser(commerceShipment.getUserId());
        commerceShipment.setShippingDate(this._getDate(shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, user.getTimeZone(), CommerceShipmentShippingDateException.class));
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        List commerceShipmentItems = this._commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, -1, -1, null);
        if (commerceShipmentItems.isEmpty()) {
            throw new CommerceShipmentItemQuantityException();
        }
        for (CommerceShipmentItem commerceShipmentItem : commerceShipmentItems) {
            if (!BigDecimalUtil.lte((BigDecimal)commerceShipmentItem.getQuantity(), (BigDecimal)BigDecimal.ZERO) && commerceShipmentItem.getCommerceInventoryWarehouseId() > 0L) continue;
            throw new CommerceShipmentStatusException();
        }
        commerceShipment.setStatus(status);
        if (ArrayUtil.contains((int[])this.messageShipmentStatuses, (int)status)) {
            this.sendShipmentStatusMessage(commerceShipment);
        }
        return (CommerceShipment)this.commerceShipmentPersistence.update((BaseModel)commerceShipment);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    protected void sendShipmentStatusMessage(CommerceShipment commerceShipment) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            DTOConverter commerceShipmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceShipment.class.getName());
            message.setPayload((Object)JSONUtil.put((String)"classPK", (Object)commerceShipment.getCommerceShipmentId()).put("commerceShipment", () -> {
                Object object = commerceShipmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceShipment.getCommerceShipmentId(), LocaleUtil.getSiteDefault(), null, null));
                return this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(object));
            }).put("commerceShipmentId", commerceShipment.getCommerceShipmentId()).put("model" + CommerceShipment.class.getName(), (Object)commerceShipment.getModelAttributes()).put("modelDTO" + commerceShipmentDTOConverter.getContentType(), (Object)this._commerceModelAttributesProvider.getModelAttributes((BaseModel)commerceShipment, commerceShipmentDTOConverter, commerceShipment.getUserId())));
            MessageBusUtil.sendMessage((String)"liferay/commerce_shipment_status", (Message)message);
            return null;
        });
    }

    private SearchContext _buildSearchContext(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, boolean negated, int[] shipmentStatuses, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (shipmentStatuses != null) {
            searchContext.setAttribute("negateShipmentStatuses", (Serializable)Boolean.valueOf(negated));
            searchContext.setAttribute("shipmentStatues", (Serializable)shipmentStatuses);
        }
        if (commerceAccountIds != null) {
            searchContext.setAttribute("commerceAccountIds", (Serializable)commerceAccountIds);
        }
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(keywords);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommerceShipment> _getCommerceShipments(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceShipment> commerceShipments = new ArrayList<CommerceShipment>(documents.size());
        for (Document document : documents) {
            long commerceShipmentId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceShipment commerceShipment = this.fetchCommerceShipment(commerceShipmentId);
            if (commerceShipment == null) {
                commerceShipments = null;
                Indexer indexer = this._indexerRegistry.getIndexer(CommerceShipment.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceShipments == null) continue;
            commerceShipments.add(commerceShipment);
        }
        return commerceShipments;
    }

    private Date _getDate(int dateMonth, int dateDay, int dateYear, int dateHour, int dateMinute, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        if (dateMonth == 0 && dateDay == 0 && dateYear == 0 && dateHour == 0 && dateMinute == 0) {
            return null;
        }
        return this._portal.getDate(dateMonth, dateDay, dateYear, dateHour, dateMinute, timeZone, clazz);
    }

    private CommerceAddress _updateCommerceShipmentAddress(String externalReferenceCode, CommerceShipment commerceShipment, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        CommerceAddress commerceAddress = commerceShipment.fetchCommerceAddress();
        if (Objects.equals(name, commerceAddress.getName()) && Objects.equals(description, commerceAddress.getDescription()) && Objects.equals(street1, commerceAddress.getStreet1()) && Objects.equals(street2, commerceAddress.getStreet2()) && Objects.equals(street3, commerceAddress.getStreet3()) && Objects.equals(city, commerceAddress.getCity()) && Objects.equals(zip, commerceAddress.getZip()) && Objects.equals(regionId, commerceAddress.getRegionId()) && Objects.equals(countryId, commerceAddress.getCountryId()) && Objects.equals(phoneNumber, commerceAddress.getPhoneNumber())) {
            return commerceAddress;
        }
        return this._commerceAddressLocalService.addCommerceAddress(externalReferenceCode, commerceShipment.getModelClassName(), commerceShipment.getCommerceShipmentId(), countryId, regionId, city, description, name, phoneNumber, street1, street2, street3, "", 2, zip, serviceContext);
    }

    private void _validateStatus(int status, int oldStatus) throws PortalException {
        if (status < oldStatus) {
            throw new CommerceShipmentStatusException();
        }
    }
}

