/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.exception.GuestCartItemMaxAllowedException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.exception.ProductBundleException;
import com.liferay.commerce.internal.context.CommerceContextFactoryImpl;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseItemUnitOfMeasureKeyException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemTable;
import com.liferay.commerce.model.CommerceOrderTable;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceUnitOfMeasureException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.util.CPJSONUtil;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.base.CommerceOrderItemLocalServiceBaseImpl;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderConfiguration"}, property={"model.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={AopService.class})
public class CommerceOrderItemLocalServiceImpl
extends CommerceOrderItemLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemLocalServiceImpl.class);
    private static final Snapshot<CommerceContextFactory> _commerceContextFactorySnapshot = new Snapshot(CommerceContextFactoryImpl.class, CommerceContextFactory.class);
    private static final Snapshot<CommerceOrderLocalService> _commerceOrderLocalServiceSnapshot = new Snapshot(CommerceOrderItemLocalServiceImpl.class, CommerceOrderLocalService.class);
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommerceOptionValueHelper _commerceOptionValueHelper;
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long userId, long commerceOrderId, long cpInstanceId, String json, BigDecimal quantity, long replacedCPInstanceId, BigDecimal shippedQuantity, String unitOfMeasureKey, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)json)) {
            json = this._getCPInstanceOptionValueRelsJSON(cpInstanceId);
        }
        CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
        CommerceOrder commerceOrder = commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        User user = this._userLocalService.getUser(userId);
        this._updateWorkflow(user.getUserId(), commerceOrder);
        CommerceProductPrice commerceProductPrice = this._getCommerceProductPrice(commerceOrder, cpInstance.getCPDefinitionId(), cpInstance.getCPInstanceId(), json, quantity, unitOfMeasureKey, commerceContext);
        BigDecimal unitOfMeasureIncrementalOrderQuantity = commerceProductPrice.getUnitOfMeasureIncrementalOrderQuantity();
        CommerceOrderItem commerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, commerceProductPrice, cpInstance, 0L, json, quantity, shippedQuantity, unitOfMeasureIncrementalOrderQuantity, unitOfMeasureKey, false, serviceContext);
        commerceOrderItem.setReplacedCPInstanceId(replacedCPInstanceId);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpInstance.getCPDefinitionId(), json);
        for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
            if (Validator.isNull((String)commerceOptionValue.getPriceType()) || this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() <= 0L) continue;
            CPInstance commerceOptionValueCPInstance = this._cpInstanceLocalService.getCPInstance(commerceOptionValue.getCPInstanceId());
            BigDecimal currentQuantity = quantity.multiply(commerceOptionValue.getQuantity());
            currentQuantity = currentQuantity.divide(unitOfMeasureIncrementalOrderQuantity, RoundingMode.HALF_UP);
            commerceProductPrice = this._getCommerceProductPrice(commerceOrder, commerceOptionValueCPInstance.getCPDefinitionId(), commerceOptionValueCPInstance.getCPInstanceId(), commerceOptionValue.toJSON(), currentQuantity, commerceOptionValue.getUnitOfMeasureKey(), commerceContext);
            CommerceOrderItem childCommerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, commerceProductPrice, commerceOptionValueCPInstance, commerceOrderItem.getCommerceOrderItemId(), commerceOptionValue.toJSON(), currentQuantity, BigDecimal.ZERO, commerceProductPrice.getUnitOfMeasureIncrementalOrderQuantity(), commerceOptionValue.getUnitOfMeasureKey(), true, serviceContext);
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                childCommerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
                continue;
            }
            childCommerceOrderItem.setUnitOfMeasureIncrementalOrderQuantity(BigDecimal.ONE);
            commerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), commerceOrder.getCommerceCurrency(), childCommerceOrderItem.getCommerceOrder(), currentQuantity, commerceOptionValue.getPrice(), BigDecimal.ONE, commerceOptionValue.getUnitOfMeasureKey());
            this._setCommerceOrderItemPrice(childCommerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        if (commerceOrder.isManuallyAdjusted() && commerceOrder.isOpen()) {
            commerceOrder.setManuallyAdjusted(false);
        }
        if (!commerceOrder.isShippable() && commerceOrderItem.isShippable()) {
            commerceOrder.setShippable(true);
        }
        commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    public CommerceOrderItem addOrUpdateCommerceOrderItem(long userId, long commerceOrderId, long cpInstanceId, String json, BigDecimal quantity, long replacedCPInstanceId, BigDecimal shippedQuantity, String unitOfMeasureKey, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(commerceOrderId, cpInstanceId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.getParentCommerceOrderItemId() != 0L || !this._jsonMatches(json, commerceOrderItem.getJson()) || !Objects.equals(GetterUtil.getString((String)unitOfMeasureKey), GetterUtil.getString((String)commerceOrderItem.getUnitOfMeasureKey()))) continue;
            return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getExternalReferenceCode(), userId, commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getJson(), quantity.add(commerceOrderItem.getQuantity()), commerceContext, serviceContext);
        }
        return this.commerceOrderItemLocalService.addCommerceOrderItem(userId, commerceOrderId, cpInstanceId, json, quantity, replacedCPInstanceId, BigDecimal.ZERO, unitOfMeasureKey, commerceContext, serviceContext);
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByC_S(commerceOrderId, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(long userId, CommerceOrderItem commerceOrderItem) throws PortalException {
        this._validateParentCommerceOrderId(commerceOrderItem);
        return this._deleteCommerceOrderItem(userId, commerceOrderItem);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(long userId, CommerceOrderItem commerceOrderItem, CommerceContext commerceContext) throws PortalException {
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, commerceOrderItem);
        CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (this._commerceShippingHelper.isFreeShipping(commerceOrder)) {
            commerceOrderLocalService.updateCommerceShippingMethod(commerceOrder.getCommerceOrderId(), 0L, null, BigDecimal.ZERO, commerceContext);
        }
        commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    public CommerceOrderItem deleteCommerceOrderItem(long userId, long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, commerceOrderItem);
    }

    public void deleteCommerceOrderItems(long userId, long commerceOrderId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.hasParentCommerceOrderItem()) continue;
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, commerceOrderItem);
        }
    }

    public void deleteCommerceOrderItemsByCPInstanceId(long userId, long cpInstanceId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCPInstanceId(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, commerceOrderItem);
        }
    }

    public void deleteMissingCommerceOrderItems(long userId, long commerceOrderId, Long[] commerceOrderItemIds, String[] externalReferenceCodes) throws PortalException {
        List commerceOrderItemIdsList = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId).and((Expression)CommerceOrderItemTable.INSTANCE.commerceOrderItemId.notIn((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(this._getPredicate(commerceOrderId, commerceOrderItemIds, externalReferenceCodes))))));
        Iterator iterator = commerceOrderItemIdsList.iterator();
        while (iterator.hasNext()) {
            long commerceOrderItemId = (Long)iterator.next();
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, commerceOrderItemId);
        }
    }

    public CommerceOrderItem fetchCommerceOrderItemByCommerceInventoryBookedQuantityId(long commerceInventoryBookedQuantityId) {
        return this.commerceOrderItemPersistence.fetchByCommerceInventoryBookedQuantityId(commerceInventoryBookedQuantityId);
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemFinder.findByAvailableQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getChildCommerceOrderItems(long parentCommerceOrderItemId) {
        return this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(parentCommerceOrderItemId);
    }

    public BigDecimal getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, commerceOrderItem.getSku(), commerceOrderItem.getUnitOfMeasureKey());
        if (commerceInventoryWarehouseItem == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryWarehouseItem.getQuantity();
        if (commerceInventoryWarehouseItemQuantity == null) {
            return BigDecimal.ZERO;
        }
        return commerceInventoryWarehouseItemQuantity;
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long cpInstanceId, int[] orderStatuses, String unitOfMeasureKey, int start, int end) {
        return (List)this.dslQuery(DSLQueryFactoryUtil.select((Table)CommerceOrderItemTable.INSTANCE).from((Table)CommerceOrderItemTable.INSTANCE).innerJoinON((Table)CommerceOrderTable.INSTANCE, CommerceOrderTable.INSTANCE.commerceOrderId.eq((Expression)CommerceOrderItemTable.INSTANCE.commerceOrderId)).where(CommerceOrderItemTable.INSTANCE.CPInstanceId.eq((Object)cpInstanceId).and(() -> {
            if (Validator.isNull((String)unitOfMeasureKey)) {
                return null;
            }
            return CommerceOrderItemTable.INSTANCE.unitOfMeasureKey.eq((Object)unitOfMeasureKey);
        }).and((Expression)CommerceOrderTable.INSTANCE.orderStatus.in((Object[])((Integer[])TransformUtil.transform((int[])orderStatuses, Integer::valueOf, Integer.class))))).limit(start, end));
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end) {
        return this.commerceOrderItemPersistence.findByC_CPI(commerceOrderId, cpInstanceId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByC_CPI(commerceOrderId, cpInstanceId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderItemFinder.findByG_A_O(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) {
        return this.commerceOrderItemPersistence.countByC_CPI(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) {
        return this.commerceOrderItemFinder.countByG_A_O(groupId, commerceAccountId, orderStatuses);
    }

    public BigDecimal getCommerceOrderItemsQuantity(long commerceOrderId) {
        return this.commerceOrderItemFinder.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public List<Long> getCustomerCommerceOrderIds(long commerceOrderId) {
        return (List)this.dslQuery((DSLQuery)this._getCustomerCommerceOrdersGroupByStep(commerceOrderId, DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderId})));
    }

    public int getCustomerCommerceOrderIdsCount(long commerceOrderId) {
        return this.dslQueryCount((DSLQuery)this._getCustomerCommerceOrdersGroupByStep(commerceOrderId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceOrderItemTable.INSTANCE.commerceOrderItemId)));
    }

    public List<CommerceOrderItem> getSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.findByC_S(commerceOrderId, true);
    }

    public List<Long> getSupplierCommerceOrderIds(long commerceOrderId) {
        return (List)this.dslQuery((DSLQuery)this._getSupplierCommerceOrdersGroupByStep(commerceOrderId, DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderId})));
    }

    public int getSupplierCommerceOrderIdsCount(long commerceOrderId) {
        return this.dslQueryCount((DSLQuery)this._getSupplierCommerceOrdersGroupByStep(commerceOrderId, DSLQueryFactoryUtil.countDistinct((Expression)CommerceOrderItemTable.INSTANCE.commerceOrderItemId)));
    }

    public List<CommerceOrderItem> getSupplierCommerceOrderItems(long customerCommerceOrderItemId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCustomerCommerceOrderItemId(customerCommerceOrderItemId, start, end);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem importCommerceOrderItem(long userId, String externalReferenceCode, long commerceOrderItemId, long commerceOrderId, long cpInstanceId, String cpMeasurementUnitKey, String json, BigDecimal quantity, BigDecimal shippedQuantity, BigDecimal unitOfMeasureIncrementalOrderQuantity, String unitOfMeasureKey, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)json)) {
            json = this._getCPInstanceOptionValueRelsJSON(cpInstanceId);
        }
        CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
        CommerceOrder commerceOrder = commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        User user = this._userLocalService.getUser(userId);
        this._updateWorkflow(user.getUserId(), commerceOrder);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.fetchByPrimaryKey(commerceOrderItemId);
        if (commerceOrderItem == null && !Validator.isBlank((String)externalReferenceCode)) {
            commerceOrderItem = this.commerceOrderItemPersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId());
        }
        commerceOrderItem = commerceOrderItem == null ? this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, null, cpInstance, 0L, json, quantity, shippedQuantity, unitOfMeasureIncrementalOrderQuantity, unitOfMeasureKey, false, serviceContext) : this._updateCommerceOrderItem(commerceOrderItem, externalReferenceCode, user, commerceOrder, cpInstance, json, quantity, shippedQuantity, unitOfMeasureIncrementalOrderQuantity, unitOfMeasureKey, serviceContext);
        if (!Validator.isBlank((String)cpMeasurementUnitKey)) {
            CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitLocalService.getCPMeasurementUnitByKey(user.getCompanyId(), cpMeasurementUnitKey);
            commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnit.getCPMeasurementUnitId());
        }
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem incrementShippedQuantity(long commerceOrderItemId, BigDecimal shippedQuantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (BigDecimalUtil.lt((BigDecimal)(shippedQuantity = shippedQuantity.add(commerceOrderItem.getShippedQuantity())), (BigDecimal)BigDecimal.ZERO)) {
            shippedQuantity = BigDecimal.ZERO;
        }
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, long parentCommerceOrderItemId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(commerceOrderId, parentCommerceOrderItemId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this._searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setKeywords(keywords);
        return this._searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String name, String sku, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setAndSearch(andOperator);
        searchContext.setAttribute("name", (Serializable)((Object)name));
        searchContext.setAttribute("sku", (Serializable)((Object)sku));
        return this._searchCommerceOrderItems(searchContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long commerceInventoryBookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem;
        block2: {
            commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
            commerceOrderItem.setCommerceInventoryBookedQuantityId(commerceInventoryBookedQuantityId);
            try {
                this._reindexCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItem(long userId, long commerceOrderItemId, BigDecimal quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getExternalReferenceCode(), userId, commerceOrderItemId, commerceOrderItem.getJson(), quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long userId, long commerceOrderItemId, long cpMeasurementUnitId, BigDecimal quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem = this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getExternalReferenceCode(), userId, commerceOrderItemId, commerceOrderItem.getJson(), quantity, commerceContext, serviceContext);
        commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnitId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItem(long userId, long commerceOrderItemId, long cpMeasurementUnitId, BigDecimal quantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem = this.commerceOrderItemLocalService.updateCommerceOrderItem(userId, commerceOrderItemId, commerceOrderItem.getJson(), quantity, serviceContext);
        commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnitId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long userId, long commerceOrderItemId, String json, BigDecimal quantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._validateParentCommerceOrderId(commerceOrderItem);
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        if (childCommerceOrderItems.isEmpty()) {
            return this._updateCommerceOrderItem(userId, commerceOrderItemId, quantity, json, serviceContext);
        }
        List commerceOptionValues = this._commerceOptionValueHelper.toCommerceOptionValues(json);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            CommerceOptionValue matchedCommerceOptionValue = commerceOptionValue.getFirstMatch(commerceOptionValues);
            if (matchedCommerceOptionValue == null) {
                throw new NoSuchOrderItemException("Child commerce order item does not match any JSON item");
            }
            BigDecimal currentQuantity = quantity.multiply(commerceOptionValue.getQuantity());
            currentQuantity = currentQuantity.divide(commerceOrderItem.getUnitOfMeasureIncrementalOrderQuantity(), RoundingMode.HALF_UP);
            this._updateCommerceOrderItem(userId, childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), serviceContext);
        }
        return this._updateCommerceOrderItem(userId, commerceOrderItemId, quantity, json, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(String externalReferenceCode, long userId, long commerceOrderItemId, String json, BigDecimal quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._validateParentCommerceOrderId(commerceOrderItem);
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        if (childCommerceOrderItems.isEmpty()) {
            return this._updateCommerceOrderItem(externalReferenceCode, userId, commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
        }
        List commerceOptionValues = this._commerceOptionValueHelper.toCommerceOptionValues(json);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            CommerceOptionValue matchedCommerceOptionValue = commerceOptionValue.getFirstMatch(commerceOptionValues);
            if (matchedCommerceOptionValue == null) {
                throw new NoSuchOrderItemException("Child commerce order item does not match any JSON item");
            }
            BigDecimal currentQuantity = quantity.multiply(commerceOptionValue.getQuantity());
            currentQuantity = currentQuantity.divide(commerceOrderItem.getUnitOfMeasureIncrementalOrderQuantity(), RoundingMode.HALF_UP);
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._updateCommerceOrderItem(childCommerceOrderItem.getExternalReferenceCode(), userId, childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), null, commerceContext, serviceContext);
                continue;
            }
            CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
            CommerceProductPrice staticCommerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), commerceOrder.getCommerceCurrency(), childCommerceOrderItem.getCommerceOrder(), currentQuantity, commerceOptionValue.getPrice(), BigDecimal.ONE, childCommerceOrderItem.getUnitOfMeasureKey());
            this._updateCommerceOrderItem(childCommerceOrderItem.getExternalReferenceCode(), userId, childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), staticCommerceProductPrice, commerceContext, serviceContext);
        }
        return this._updateCommerceOrderItem(externalReferenceCode, userId, commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemDeliveryDate(long commerceOrderItemId, Date requestedDeliveryDate) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroupName, String printedNote) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setDeliveryGroupName(deliveryGroupName);
        commerceOrderItem.setPrintedNote(printedNote);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroupName, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear) throws PortalException {
        Date requestedDeliveryDate = this._portal.getDate(requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setDeliveryGroupName(deliveryGroupName);
        commerceOrderItem.setPrintedNote(printedNote);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroupName, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroupName, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrice(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (commerceOrderItem.isManuallyAdjusted() || commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            return commerceOrderItem;
        }
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            return commerceOrderItem;
        }
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._setCommerceOrderItemPrice(childCommerceOrderItem, null, commerceContext);
            } else {
                CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
                this._setCommerceOrderItemPrice(childCommerceOrderItem, this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), commerceOrder.getCommerceCurrency(), childCommerceOrderItem.getCommerceOrder(), childCommerceOrderItem.getQuantity(), commerceOptionValue.getPrice(), BigDecimal.ONE, childCommerceOrderItem.getUnitOfMeasureKey()), commerceContext);
            }
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._setCommerceOrderItemPrice(commerceOrderItem, null, commerceContext);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._validateParentCommerceOrderId(commerceOrderItem);
        boolean discountChanged = this._isDiscountChanged(discountAmount, commerceOrderItem);
        boolean priceChanged = this._isPriceChanged(finalPrice, promoPrice, unitPrice, commerceOrderItem);
        commerceOrderItem.setDiscountAmount((BigDecimal)GetterUtil.get((Object)discountAmount, (Number)BigDecimal.ZERO));
        if (!commerceOrderItem.isDiscountManuallyAdjusted() && discountChanged) {
            commerceOrderItem.setDiscountManuallyAdjusted(true);
        }
        commerceOrderItem.setDiscountPercentageLevel1((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPrice((BigDecimal)GetterUtil.get((Object)finalPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setManuallyAdjusted(true);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && priceChanged) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setPromoPrice((BigDecimal)GetterUtil.get((Object)promoPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPrice((BigDecimal)GetterUtil.get((Object)unitPrice, (Number)BigDecimal.ZERO));
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel1WithTaxAmount, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel2WithTaxAmount, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel3WithTaxAmount, BigDecimal discountPercentageLevel4, BigDecimal discountPercentageLevel4WithTaxAmount, BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        boolean discountChanged = this._isDiscountChanged(discountAmount, discountAmountWithTaxAmount, commerceOrderItem);
        boolean priceChanged = this._isPriceChanged(finalPrice, finalPriceWithTaxAmount, promoPrice, promoPriceWithTaxAmount, unitPrice, unitPriceWithTaxAmount, commerceOrderItem);
        commerceOrderItem.setDiscountAmount((BigDecimal)GetterUtil.get((Object)discountAmount, (Number)BigDecimal.ZERO));
        if (!commerceOrderItem.isDiscountManuallyAdjusted() && discountChanged) {
            commerceOrderItem.setDiscountManuallyAdjusted(true);
        }
        commerceOrderItem.setDiscountPercentageLevel1((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountWithTaxAmount((BigDecimal)GetterUtil.get((Object)discountAmountWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPrice((BigDecimal)GetterUtil.get((Object)finalPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)finalPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setManuallyAdjusted(true);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && priceChanged) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setPromoPrice((BigDecimal)GetterUtil.get((Object)promoPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setPromoPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)promoPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPrice((BigDecimal)GetterUtil.get((Object)unitPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)unitPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && this._isPriceChanged(unitPrice, commerceOrderItem)) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long userId, long commerceOrderItemId, BigDecimal quantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && this._isPriceChanged(unitPrice, commerceOrderItem)) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        this._updateCommerceInventoryBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getCommerceInventoryBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        commerceOrderItem.setManuallyAdjusted(true);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCustomFields(long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    public CommerceOrderItem updateExternalReferenceCode(long commerceOrderItemId, String externalReferenceCode) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        commerceOrderItem.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderConfiguration.class, properties);
    }

    private SearchContext _buildSearchContext(long commerceOrderId, Long parentCommerceOrderItemId, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
        CommerceOrder commerceOrder = commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        searchContext.setAttribute("commerceOrderId", (Serializable)Long.valueOf(commerceOrderId));
        if (parentCommerceOrderItemId != null) {
            searchContext.setAttribute("parentCommerceOrderItemId", (Serializable)parentCommerceOrderItemId);
        }
        searchContext.setCompanyId(commerceOrder.getCompanyId());
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private CommerceOrderItem _createCommerceOrderItem(long groupId, User user, CommerceOrder commerceOrder, CommerceProductPrice commerceProductPrice, CPInstance cpInstance, long parentCommerceOrderItemId, String json, BigDecimal quantity, BigDecimal shippedQuantity, BigDecimal unitOfMeasureIncrementalOrderQuantity, String unitOfMeasureKey, boolean child, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this._validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, json, quantity, unitOfMeasureKey, child, GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        long commerceOrderItemId = this.counterLocalService.increment();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.create(commerceOrderItemId);
        commerceOrderItem.setGroupId(groupId);
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setParentCommerceOrderItemId(parentCommerceOrderItemId);
        commerceOrderItem.setFreeShipping(cpDefinition.isFreeShipping());
        commerceOrderItem.setJson(json);
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShipSeparately(cpDefinition.isShipSeparately());
        commerceOrderItem.setShippable(cpDefinition.isShippable());
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        commerceOrderItem.setShippingExtraPrice(cpDefinition.getShippingExtraPrice());
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setSubscription(this._isSubscription(cpInstance));
        commerceOrderItem.setUnitOfMeasureIncrementalOrderQuantity(unitOfMeasureIncrementalOrderQuantity);
        commerceOrderItem.setUnitOfMeasureKey(unitOfMeasureKey);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setDimensions(commerceOrderItem, cpInstance);
        this._setSubscriptionInfo(commerceOrderItem, cpInstance);
        if (!ExportImportThreadLocal.isImportInProcess() && commerceProductPrice != null) {
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        this._validate(serviceContext.getLocale(), commerceOrderItem, true);
        return commerceOrderItem;
    }

    private void _deleteBundleChildrenOrderItems(long userId, long commerceOrderItemId) throws PortalException {
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            childCommerceOrderItem.setParentCommerceOrderItemId(0L);
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(userId, childCommerceOrderItem);
        }
    }

    private CommerceOrderItem _deleteCommerceOrderItem(long userId, CommerceOrderItem commerceOrderItem) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        this._deleteBundleChildrenOrderItems(userId, commerceOrderItem.getCommerceOrderItemId());
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        if (commerceOrderItem.getCommerceInventoryBookedQuantityId() > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getCommerceInventoryBookedQuantityId())) != null) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(userId, commerceOrderItem.getCommerceInventoryBookedQuantityId(), (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).build(), this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("delete-booked-quantity"));
        }
        this._expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        this._updateWorkflow(userId, commerceOrderItem.getCommerceOrder());
        return commerceOrderItem;
    }

    private List<CommerceOrderItem> _getCommerceOrderItems(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrderItem> commerceOrderItems = new ArrayList<CommerceOrderItem>(documents.size());
        for (Document document : documents) {
            long commerceOrderItemId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrderItem commerceOrderItem = this.fetchCommerceOrderItem(commerceOrderItemId);
            if (commerceOrderItem == null) {
                commerceOrderItems = null;
                continue;
            }
            if (commerceOrderItems == null) continue;
            commerceOrderItems.add(commerceOrderItem);
        }
        return commerceOrderItems;
    }

    private CommerceProductPrice _getCommerceProductPrice(CommerceOrder commerceOrder, long cpDefinitionId, long cpInstanceId, String json, BigDecimal quantity, String unitOfMeasureKey, CommerceContext commerceContext) throws PortalException {
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCalculateTax(true);
        long accountEntryId = 0L;
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        if (accountEntry != null) {
            accountEntryId = accountEntry.getAccountEntryId();
        }
        CommerceContextFactory commerceContextFactory = (CommerceContextFactory)_commerceContextFactorySnapshot.get();
        commerceProductPriceRequest.setCommerceContext(commerceContextFactory.create(accountEntryId, commerceContext.getCommerceChannelGroupId(), commerceOrder.getCommerceCurrencyCode(), commerceOrder.getCommerceOrderId(), commerceOrder.getCompanyId()));
        commerceProductPriceRequest.setCommerceOptionValues(this._getStaticOptionValuesNotLinkedToSku(cpDefinitionId, json));
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(false);
        commerceProductPriceRequest.setUnitOfMeasureKey(unitOfMeasureKey);
        return this._commerceProductPriceCalculation.getCommerceProductPrice(commerceProductPriceRequest);
    }

    private BigDecimal _getConvertedPrice(long cpInstanceId, BigDecimal price, CommerceOrder commerceOrder) throws PortalException {
        return CommercePriceConverterUtil.getConvertedPrice(commerceOrder.getGroupId(), cpInstanceId, commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), price, false, this._commerceTaxCalculation);
    }

    private String _getCPInstanceOptionValueRelsJSON(long cpInstanceId) throws PortalException {
        JSONArray jsonArray = CPJSONUtil.toJSONArray((Map)this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId));
        return jsonArray.toString();
    }

    private GroupByStep _getCustomerCommerceOrdersGroupByStep(long commerceOrderId, FromStep fromStep) {
        return fromStep.from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.commerceOrderItemId.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.customerCommerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId))));
    }

    private Predicate _getPredicate(long commerceOrderId, Long[] commerceOrderItemIds, String[] externalReferenceCodes) {
        return CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId).and(() -> {
            Predicate predicate = null;
            if (ArrayUtil.isNotEmpty((Object[])commerceOrderItemIds)) {
                predicate = CommerceOrderItemTable.INSTANCE.commerceOrderItemId.in((Object[])commerceOrderItemIds);
            }
            if (ArrayUtil.isNotEmpty((Object[])externalReferenceCodes)) {
                if (predicate != null) {
                    return predicate.or((Expression)CommerceOrderItemTable.INSTANCE.externalReferenceCode.in((Object[])externalReferenceCodes));
                }
                predicate = CommerceOrderItemTable.INSTANCE.externalReferenceCode.in((Object[])externalReferenceCodes);
            }
            return predicate;
        });
    }

    private CommerceProductPrice _getStaticCommerceProductPrice(long cpInstanceId, CommerceCurrency commerceCurrency, CommerceOrder commerceOrder, BigDecimal quantity, BigDecimal optionValuePrice, BigDecimal unitOfMeasureIncrementalOrderQuantity, String unitOfMeasureKey) throws PortalException {
        if (unitOfMeasureIncrementalOrderQuantity == null) {
            unitOfMeasureIncrementalOrderQuantity = BigDecimal.ONE;
        }
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        if (optionValuePrice == null) {
            optionValuePrice = BigDecimal.ZERO;
        }
        commerceProductPriceImpl.setUnitPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPriceImpl.setUnitPromoPrice(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        BigDecimal unitPriceWithTaxAmount = optionValuePrice;
        BigDecimal finalPriceWithTaxAmount = optionValuePrice;
        if (cpInstanceId > 0L) {
            unitPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
            optionValuePrice = optionValuePrice.multiply(quantity);
            finalPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
        }
        commerceProductPriceImpl.setUnitPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, unitPriceWithTaxAmount));
        commerceProductPriceImpl.setFinalPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPriceImpl.setFinalPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, finalPriceWithTaxAmount));
        commerceProductPriceImpl.setCommerceDiscountValue(null);
        commerceProductPriceImpl.setQuantity(quantity);
        commerceProductPriceImpl.setUnitOfMeasureIncrementalOrderQuantity(unitOfMeasureIncrementalOrderQuantity);
        commerceProductPriceImpl.setUnitOfMeasureKey(unitOfMeasureKey);
        return commerceProductPriceImpl;
    }

    private List<CommerceOptionValue> _getStaticOptionValuesNotLinkedToSku(long cpDefinitionId, String jsonArrayString) throws PortalException {
        return ListUtil.filter((List)this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpDefinitionId, jsonArrayString), commerceOptionValue -> this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() == 0L);
    }

    private GroupByStep _getSupplierCommerceOrdersGroupByStep(long commerceOrderId, FromStep fromStep) {
        return fromStep.from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.customerCommerceOrderItemId.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId))));
    }

    private boolean _isDiscountChanged(BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, CommerceOrderItem commerceOrderItem) {
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        if (discountAmountWithTaxAmount == null) {
            discountAmountWithTaxAmount = BigDecimal.ZERO;
        }
        int discountAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountAmount() != null) {
            discountAmountCompareTo = discountAmount.compareTo(commerceOrderItem.getDiscountAmount());
        }
        int discountAmountWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountWithTaxAmount() != null) {
            discountAmountWithTaxAmountCompareTo = discountAmountWithTaxAmount.compareTo(commerceOrderItem.getDiscountWithTaxAmount());
        }
        return discountAmountCompareTo != 0 || discountAmountWithTaxAmountCompareTo != 0;
    }

    private boolean _isDiscountChanged(BigDecimal discountAmount, CommerceOrderItem commerceOrderItem) {
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        int discountAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountAmount() != null) {
            discountAmountCompareTo = discountAmount.compareTo(commerceOrderItem.getDiscountAmount());
        }
        return discountAmountCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount, CommerceOrderItem commerceOrderItem) {
        if (finalPrice == null) {
            finalPrice = BigDecimal.ZERO;
        }
        if (promoPrice == null) {
            promoPrice = BigDecimal.ZERO;
        }
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        if (promoPriceWithTaxAmount == null) {
            promoPriceWithTaxAmount = BigDecimal.ZERO;
        }
        if (finalPriceWithTaxAmount == null) {
            finalPriceWithTaxAmount = BigDecimal.ZERO;
        }
        if (unitPriceWithTaxAmount == null) {
            unitPriceWithTaxAmount = BigDecimal.ZERO;
        }
        int finalPriceCompareTo = 0;
        if (commerceOrderItem.getFinalPrice() != null) {
            finalPriceCompareTo = finalPrice.compareTo(commerceOrderItem.getFinalPrice());
        }
        int promoPriceCompareTo = 0;
        if (commerceOrderItem.getPromoPrice() != null) {
            promoPriceCompareTo = promoPrice.compareTo(commerceOrderItem.getPromoPrice());
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        int finalPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getFinalPriceWithTaxAmount() != null) {
            finalPriceWithTaxAmountCompareTo = finalPriceWithTaxAmount.compareTo(commerceOrderItem.getFinalPriceWithTaxAmount());
        }
        int promoPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getPromoPriceWithTaxAmount() != null) {
            promoPriceWithTaxAmountCompareTo = promoPriceWithTaxAmount.compareTo(commerceOrderItem.getPromoPriceWithTaxAmount());
        }
        int unitPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getUnitPriceWithTaxAmount() != null) {
            unitPriceWithTaxAmountCompareTo = unitPriceWithTaxAmount.compareTo(commerceOrderItem.getUnitPriceWithTaxAmount());
        }
        return finalPriceCompareTo != 0 || promoPriceCompareTo != 0 || unitPriceCompareTo != 0 || finalPriceWithTaxAmountCompareTo != 0 || promoPriceWithTaxAmountCompareTo != 0 || unitPriceWithTaxAmountCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice, CommerceOrderItem commerceOrderItem) {
        if (finalPrice == null) {
            finalPrice = BigDecimal.ZERO;
        }
        if (promoPrice == null) {
            promoPrice = BigDecimal.ZERO;
        }
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        int finalPriceCompareTo = 0;
        if (commerceOrderItem.getFinalPrice() != null) {
            finalPriceCompareTo = finalPrice.compareTo(commerceOrderItem.getFinalPrice());
        }
        int promoPriceCompareTo = 0;
        if (commerceOrderItem.getPromoPrice() != null) {
            promoPriceCompareTo = promoPrice.compareTo(commerceOrderItem.getPromoPrice());
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        return finalPriceCompareTo != 0 || promoPriceCompareTo != 0 || unitPriceCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal unitPrice, CommerceOrderItem commerceOrderItem) {
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        return unitPriceCompareTo != 0;
    }

    private boolean _isStaticPriceType(Object value) {
        return Objects.equals(value, "static");
    }

    private boolean _isSubscription(CPInstance cpInstance) throws PortalException {
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (cpDefinition.isSubscriptionEnabled() || cpDefinition.isDeliverySubscriptionEnabled()) {
            return true;
        }
        return cpInstance.isOverrideSubscriptionInfo() && (cpInstance.isSubscriptionEnabled() || cpInstance.isDeliverySubscriptionEnabled());
    }

    private boolean _jsonMatches(String json1, String json2) {
        if (Objects.equals(json1, json2)) {
            return true;
        }
        try {
            JSONArray jsonArray1 = this._jsonFactory.createJSONArray(json1);
            JSONArray jsonArray2 = this._jsonFactory.createJSONArray(json2);
            if (jsonArray1.length() != jsonArray2.length()) {
                return false;
            }
            for (int i = 0; i < jsonArray1.length(); ++i) {
                JSONArray valueJSONArray;
                JSONObject existingJSONObject = null;
                JSONObject jsonObject1 = jsonArray1.getJSONObject(i);
                for (int j = 0; j < jsonArray2.length(); ++j) {
                    JSONObject jsonObject2 = jsonArray2.getJSONObject(j);
                    if (!jsonObject1.has("skuOptionKey") || !Objects.equals(jsonObject1.get("skuOptionKey"), jsonObject2.get("skuOptionKey"))) continue;
                    existingJSONObject = jsonObject2;
                    break;
                }
                if (existingJSONObject == null) {
                    return false;
                }
                Object value = jsonObject1.get("value");
                if (value instanceof JSONArray && (valueJSONArray = (JSONArray)value).length() != 0) {
                    return false;
                }
                if ((!jsonObject1.has("value") || Objects.equals(existingJSONObject.get("value"), value)) && (!jsonObject1.has("skuOptionValueKey") || Objects.equals(existingJSONObject.get("skuOptionValueKey"), jsonObject1.get("skuOptionValueKey")))) continue;
                return false;
            }
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return false;
        }
        return true;
    }

    private void _reindexCommerceInventoryBookedQuantity(long commerceInventoryBookedQuantityId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryBookedQuantity.class);
        indexer.reindex(CommerceInventoryBookedQuantity.class.getName(), commerceInventoryBookedQuantityId);
    }

    private BaseModelSearchResult<CommerceOrderItem> _searchCommerceOrderItems(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommerceOrderItem.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceOrderItem> commerceOrderItems = this._getCommerceOrderItems(hits);
            if (commerceOrderItems == null) continue;
            return new BaseModelSearchResult(commerceOrderItems, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private void _setCommerceOrderItemDiscountValue(CommerceOrderItem commerceOrderItem, CommerceDiscountValue commerceDiscountValue, boolean includeTax) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (includeTax) {
            commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrderItem.setDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrderItem.setDiscountAmount(discountAmount);
            commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice) {
        commerceOrderItem.setPriceOnApplication(commerceProductPrice.isPriceOnApplication());
        CommerceMoney unitPriceCommerceMoney = commerceProductPrice.getUnitPrice();
        CommerceMoney unitPromoPriceCommerceMoney = commerceProductPrice.getUnitPromoPrice();
        BigDecimal unitPrice = BigDecimal.ZERO;
        if (!unitPriceCommerceMoney.isEmpty()) {
            unitPrice = unitPriceCommerceMoney.getPrice();
        }
        commerceOrderItem.setUnitPrice(unitPrice);
        BigDecimal promoPrice = BigDecimal.ZERO;
        if (!unitPromoPriceCommerceMoney.isEmpty()) {
            promoPrice = unitPromoPriceCommerceMoney.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        CommerceMoney unitPriceWithTaxAmountCommerceMoney = commerceProductPrice.getUnitPriceWithTaxAmount();
        CommerceMoney unitPromoPriceWithTaxAmountCommerceMoney = commerceProductPrice.getUnitPromoPriceWithTaxAmount();
        BigDecimal unitPriceWithTaxAmount = BigDecimal.ZERO;
        if (unitPriceWithTaxAmountCommerceMoney != null && !unitPriceWithTaxAmountCommerceMoney.isEmpty()) {
            unitPriceWithTaxAmount = unitPriceWithTaxAmountCommerceMoney.getPrice();
        }
        commerceOrderItem.setUnitPriceWithTaxAmount(unitPriceWithTaxAmount);
        BigDecimal promoPriceWithTaxAmount = BigDecimal.ZERO;
        if (unitPromoPriceWithTaxAmountCommerceMoney != null && !unitPromoPriceWithTaxAmountCommerceMoney.isEmpty()) {
            promoPriceWithTaxAmount = unitPromoPriceWithTaxAmountCommerceMoney.getPrice();
        }
        commerceOrderItem.setPromoPriceWithTaxAmount(promoPriceWithTaxAmount);
        CommerceMoney finalPriceCommerceMoney = commerceProductPrice.getFinalPrice();
        commerceOrderItem.setFinalPrice(finalPriceCommerceMoney.getPrice());
        CommerceMoney finalPriceWithTaxAmountCommerceMoney = commerceProductPrice.getFinalPriceWithTaxAmount();
        if (finalPriceWithTaxAmountCommerceMoney != null) {
            BigDecimal finalPriceWithTaxAmount = BigDecimal.ZERO;
            if (!finalPriceWithTaxAmountCommerceMoney.isEmpty()) {
                finalPriceWithTaxAmount = finalPriceWithTaxAmountCommerceMoney.getPrice();
            }
            commerceOrderItem.setFinalPriceWithTaxAmount(finalPriceWithTaxAmount);
        }
        commerceOrderItem.setCommercePriceListId(commerceProductPrice.getCommercePriceListId());
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null || commerceOrderItem.isManuallyAdjusted()) {
            return;
        }
        if (commerceProductPrice == null) {
            commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCommerceOrder(), commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity(), commerceOrderItem.getUnitOfMeasureKey(), commerceContext);
        }
        this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
    }

    private void _setDimensions(CommerceOrderItem commerceOrderItem, CPInstance cpInstance) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        commerceOrderItem.setWidth(cpInstance.getWidth());
        if (commerceOrderItem.getWidth() <= 0.0) {
            commerceOrderItem.setWidth(cpDefinition.getWidth());
        }
        commerceOrderItem.setHeight(cpInstance.getHeight());
        if (commerceOrderItem.getHeight() <= 0.0) {
            commerceOrderItem.setHeight(cpDefinition.getHeight());
        }
        commerceOrderItem.setDepth(cpInstance.getDepth());
        if (commerceOrderItem.getDepth() <= 0.0) {
            commerceOrderItem.setDepth(cpDefinition.getDepth());
        }
        commerceOrderItem.setWeight(cpInstance.getWeight());
        if (commerceOrderItem.getWeight() <= 0.0) {
            commerceOrderItem.setWeight(cpDefinition.getWeight());
        }
    }

    private void _setSubscriptionInfo(CommerceOrderItem commerceOrderItem, CPInstance cpInstance) throws PortalException {
        if (cpInstance.isOverrideSubscriptionInfo()) {
            if (cpInstance.isDeliverySubscriptionEnabled()) {
                commerceOrderItem.setDeliveryMaxSubscriptionCycles(cpInstance.getDeliveryMaxSubscriptionCycles());
                commerceOrderItem.setDeliverySubscriptionLength(cpInstance.getDeliverySubscriptionLength());
                commerceOrderItem.setDeliverySubscriptionType(cpInstance.getDeliverySubscriptionType());
                commerceOrderItem.setDeliverySubscriptionTypeSettings(cpInstance.getDeliverySubscriptionTypeSettings());
            }
            if (cpInstance.isSubscriptionEnabled()) {
                commerceOrderItem.setMaxSubscriptionCycles(cpInstance.getMaxSubscriptionCycles());
                commerceOrderItem.setSubscriptionLength(cpInstance.getSubscriptionLength());
                commerceOrderItem.setSubscriptionType(cpInstance.getSubscriptionType());
                commerceOrderItem.setSubscriptionTypeSettings(cpInstance.getSubscriptionTypeSettings());
            }
        } else {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
            if (cpDefinition.isDeliverySubscriptionEnabled()) {
                commerceOrderItem.setDeliveryMaxSubscriptionCycles(cpDefinition.getDeliveryMaxSubscriptionCycles());
                commerceOrderItem.setDeliverySubscriptionLength(cpDefinition.getDeliverySubscriptionLength());
                commerceOrderItem.setDeliverySubscriptionType(cpDefinition.getDeliverySubscriptionType());
                commerceOrderItem.setDeliverySubscriptionTypeSettings(cpDefinition.getDeliverySubscriptionTypeSettings());
            }
            if (cpDefinition.isSubscriptionEnabled()) {
                commerceOrderItem.setMaxSubscriptionCycles(cpDefinition.getMaxSubscriptionCycles());
                commerceOrderItem.setSubscriptionLength(cpDefinition.getSubscriptionLength());
                commerceOrderItem.setSubscriptionType(cpDefinition.getSubscriptionType());
                commerceOrderItem.setSubscriptionTypeSettings(cpDefinition.getSubscriptionTypeSettings());
            }
        }
    }

    private void _updateCommerceInventoryBookedQuantity(long userId, CommerceOrderItem commerceOrderItem, long commerceInventoryBookedQuantityId, BigDecimal quantity, BigDecimal oldQuantity) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        if (oldQuantity.compareTo(quantity) != 0 && commerceInventoryBookedQuantityId > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId)) != null) {
            this._commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(userId, commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId(), quantity, (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build(), commerceInventoryBookedQuantity.getMvccVersion());
        }
    }

    private CommerceOrderItem _updateCommerceOrderItem(CommerceOrderItem commerceOrderItem, String externalReferenceCode, User user, CommerceOrder commerceOrder, CPInstance cpInstance, String json, BigDecimal quantity, BigDecimal shippedQuantity, BigDecimal unitOfMeasureIncrementalOrderQuantity, String unitOfMeasureKey, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this._validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, json, quantity, unitOfMeasureKey, commerceOrderItem.hasParentCommerceOrderItem(), GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        commerceOrderItem.setExternalReferenceCode(externalReferenceCode);
        commerceOrderItem.setGroupId(commerceOrder.getGroupId());
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setFreeShipping(cpDefinition.isFreeShipping());
        commerceOrderItem.setJson(json);
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShipSeparately(cpDefinition.isShipSeparately());
        commerceOrderItem.setShippable(cpDefinition.isShippable());
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        commerceOrderItem.setShippingExtraPrice(cpDefinition.getShippingExtraPrice());
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setSubscription(this._isSubscription(cpInstance));
        commerceOrderItem.setUnitOfMeasureIncrementalOrderQuantity(unitOfMeasureIncrementalOrderQuantity);
        commerceOrderItem.setUnitOfMeasureKey(unitOfMeasureKey);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._setDimensions(commerceOrderItem, cpInstance);
        this._setSubscriptionInfo(commerceOrderItem, cpInstance);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            CommerceProductPrice commerceProductPrice = this._getCommerceProductPrice(commerceOrder, cpInstance.getCPDefinitionId(), cpInstance.getCPInstanceId(), json, quantity, unitOfMeasureKey, null);
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        this._validate(serviceContext.getLocale(), commerceOrderItem, true);
        return commerceOrderItem;
    }

    private CommerceOrderItem _updateCommerceOrderItem(long userId, long commerceOrderItemId, BigDecimal quantity, String json, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        this._validate(serviceContext.getLocale(), commerceOrder, commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), json, quantity, commerceOrderItem.getUnitOfMeasureKey(), commerceOrderItem.hasParentCommerceOrderItem(), GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        this._updateCommerceInventoryBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getCommerceInventoryBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        this._updateWorkflow(userId, commerceOrder);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._validate(serviceContext.getLocale(), commerceOrderItem, true);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    private CommerceOrderItem _updateCommerceOrderItem(String externalReferenceCode, long userId, long commerceOrderItemId, BigDecimal quantity, String json, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        this._validate(serviceContext.getLocale(), commerceOrder, commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), json, quantity, commerceOrderItem.getUnitOfMeasureKey(), commerceOrderItem.hasParentCommerceOrderItem(), GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        this._updateCommerceInventoryBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getCommerceInventoryBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        commerceOrder = this._updateWorkflow(userId, commerceOrder);
        commerceOrderItem.setExternalReferenceCode(externalReferenceCode);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setQuantity(quantity);
        if (commerceOrder.isOpen()) {
            if (commerceProductPrice == null) {
                commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCommerceOrder(), commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), quantity, commerceOrderItem.getUnitOfMeasureKey(), commerceContext);
            }
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        this._validate(serviceContext.getLocale(), commerceOrderItem, true);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        if (commerceOrder.isOpen()) {
            CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
            commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        }
        return commerceOrderItem;
    }

    private CommerceOrder _updateWorkflow(long userId, CommerceOrder commerceOrder) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L, true);
        if (workflowDefinitionLink != null && commerceOrder.isApproved()) {
            CommerceOrderLocalService commerceOrderLocalService = (CommerceOrderLocalService)_commerceOrderLocalServiceSnapshot.get();
            return commerceOrderLocalService.updateStatus(userId, commerceOrder.getCommerceOrderId(), 2, Collections.emptyMap());
        }
        return commerceOrder;
    }

    private void _validate(Locale locale, CommerceOrder commerceOrder, CPDefinition cpDefinition, CPInstance cpInstance, String json, BigDecimal quantity, String unitOfMeasureKey, boolean child, boolean validateOrder) throws PortalException {
        List commerceCartValidatorResults;
        int count;
        if (commerceOrder.getUserId() == 0L && (count = this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrder.getCommerceOrderId())) >= this._commerceOrderConfiguration.guestCartItemMaxAllowed()) {
            throw new GuestCartItemMaxAllowedException();
        }
        if (cpDefinition != null && cpInstance != null && cpDefinition.getCPDefinitionId() != cpInstance.getCPDefinitionId()) {
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstance.getCPInstanceId(), " belongs to a different CPDefinition than ", cpDefinition.getCPDefinitionId()}));
        }
        if (cpInstance != null) {
            if (Validator.isNotNull((String)unitOfMeasureKey)) {
                CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(cpInstance.getCPInstanceId(), unitOfMeasureKey);
                if (cpInstanceUnitOfMeasure == null) {
                    throw new NoSuchCPInstanceUnitOfMeasureException("No commerce product instance unit of measure exists with the primary key " + unitOfMeasureKey);
                }
            } else {
                int cpInstanceUnitOfMeasuresCount = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasuresCount(cpInstance.getCPInstanceId());
                if (cpInstanceUnitOfMeasuresCount > 0) {
                    throw new CommerceInventoryWarehouseItemUnitOfMeasureKeyException("Unit of measure key is mandatory");
                }
            }
        }
        if (!ExportImportThreadLocal.isImportInProcess() && validateOrder && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrder, cpInstance, json, quantity, child)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    private void _validate(Locale locale, CommerceOrderItem commerceOrderItem, boolean validateOrder) throws PortalException {
        List commerceCartValidatorResults;
        if (!ExportImportThreadLocal.isImportInProcess() && validateOrder && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrderItem)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    private void _validateParentCommerceOrderId(CommerceOrderItem commerceOrderItem) throws PortalException {
        if (commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            throw new ProductBundleException(StringBundler.concat((Object[])new Object[]{"Operation not allowed on an item ", commerceOrderItem.getCommerceOrderItemId(), " because it is a child commerce order item ", commerceOrderItem.getParentCommerceOrderItemId()}));
        }
    }
}

