/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.verify;

import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.commerce.util.CommerceAccountRoleHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"initial.deployment=true"}, service={VerifyProcess.class})
public class CommerceAccountServiceVerifyProcess
extends VerifyProcess {
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void verifyAccountGroup() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> this._accountGroupLocalService.checkGuestAccountGroup(companyId.longValue()));
        }
    }

    public void verifyAccountRoles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._companyLocalService.forEachCompanyId(companyId -> {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAttribute("forceReloadPermissions", (Serializable)Boolean.TRUE);
                serviceContext.setCompanyId(companyId.longValue());
                serviceContext.setUserId(this._getAdminUserId((long)companyId));
                serviceContext.setUuid(PortalUUIDUtil.generate());
                this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
            });
        }
    }

    protected void doVerify() throws Exception {
        this.verifyAccountRoles();
        this.verifyAccountGroup();
    }

    private long _getAdminUserId(long companyId) throws PortalException {
        Role role = this._roleLocalService.getRole(companyId, "Administrator");
        long[] userIds = this._userLocalService.getRoleUserIds(role.getRoleId());
        if (userIds.length == 0) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"No user exists in company ", companyId, " with role ", role.getName()}));
        }
        return userIds[0];
    }
}

