/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.stock.activity;

import com.liferay.commerce.internal.stock.activity.comparator.CommerceLowStockActivityServiceWrapperPriorityComparator;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.stock.activity.CommerceLowStockActivity;
import com.liferay.commerce.stock.activity.CommerceLowStockActivityRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceLowStockActivityRegistry.class})
public class CommerceLowStockActivityRegistryImpl
implements CommerceLowStockActivityRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceLowStockActivityRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceLowStockActivity>> _commerceLowStockActivityServiceWrapperPriorityComparator = new CommerceLowStockActivityServiceWrapperPriorityComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceLowStockActivity>> _serviceTrackerMap;

    public List<CommerceLowStockActivity> getCommerceLowStockActivities() {
        ArrayList<CommerceLowStockActivity> commerceLowStockActivities = new ArrayList<CommerceLowStockActivity>();
        List commerceLowStockActivityServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceLowStockActivityServiceWrappers, _commerceLowStockActivityServiceWrapperPriorityComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceLowStockActivityServiceWrapper : commerceLowStockActivityServiceWrappers) {
            commerceLowStockActivities.add((CommerceLowStockActivity)commerceLowStockActivityServiceWrapper.getService());
        }
        return Collections.unmodifiableList(commerceLowStockActivities);
    }

    public CommerceLowStockActivity getCommerceLowStockActivity(CPDefinitionInventory cpDefinitionInventory) {
        if (cpDefinitionInventory == null) {
            return null;
        }
        return this.getCommerceLowStockActivity(cpDefinitionInventory.getLowStockActivity());
    }

    public CommerceLowStockActivity getCommerceLowStockActivity(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceLowStockActivityServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceLowStockActivityServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce low stock activity registered with key " + key));
            }
            return null;
        }
        return (CommerceLowStockActivity)commerceLowStockActivityServiceWrapper.getService();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceLowStockActivity.class, (String)"commerce.low.stock.activity.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

