/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.service;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.service.AccountEntryLocalServiceWrapper;
import com.liferay.commerce.context.CommerceContextThreadLocal;
import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.internal.util.AccountEntryUtil;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRelTable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class CommerceChannelAccountEntryRelAccountEntryLocalServiceWrapper
extends AccountEntryLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(CommerceChannelAccountEntryRelAccountEntryLocalServiceWrapper.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public AccountEntry fetchUserAccountEntry(long userId, long accountEntryId) {
        AccountEntry accountEntry = super.fetchUserAccountEntry(userId, accountEntryId);
        if (accountEntry != null) {
            return accountEntry;
        }
        try {
            long commerceChannelId = AccountEntryUtil.getCommerceChannelId(CommerceContextThreadLocal.get(), CommerceGroupThreadLocal.get());
            JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE).from((Table)CommerceChannelAccountEntryRelTable.INSTANCE).leftJoinOn((Table)AccountEntryTable.INSTANCE, AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.accountEntryId));
            DSLQuery dslQuery = joinStep.where(CommerceChannelAccountEntryRelTable.INSTANCE.accountEntryId.eq((Object)accountEntryId).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId)).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(User.class.getName()))).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.classPK.eq((Object)userId)).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.type.eq((Object)7))).limit(0, 1);
            List accountEntries = (List)this.dslQuery(dslQuery);
            if (accountEntries.isEmpty()) {
                return null;
            }
            return (AccountEntry)accountEntries.get(0);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return null;
        }
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end) throws PortalException {
        ArrayList<AccountEntry> userAccountEntries = new ArrayList<AccountEntry>(super.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, status, start, end));
        long commerceChannelId = AccountEntryUtil.getCommerceChannelId(CommerceContextThreadLocal.get(), CommerceGroupThreadLocal.get());
        JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE).from((Table)CommerceChannelAccountEntryRelTable.INSTANCE).leftJoinOn((Table)AccountEntryTable.INSTANCE, AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.accountEntryId));
        DSLQuery dslQuery = joinStep.where(CommerceChannelAccountEntryRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(User.class.getName()))).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.classPK.eq((Object)userId)).and((Expression)CommerceChannelAccountEntryRelTable.INSTANCE.type.eq((Object)7))).limit(start, end);
        ArrayList<AccountEntry> accountEntries = new ArrayList<AccountEntry>((Collection)this.dslQuery(dslQuery));
        if (userAccountEntries.isEmpty()) {
            return accountEntries;
        }
        userAccountEntries.addAll(accountEntries);
        return new ArrayList<AccountEntry>(new LinkedHashSet(userAccountEntries));
    }
}

