/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.query.contributor;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ExpandoQueryContributor;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MultiMatchQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.LinkedHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={KeywordQueryContributor.class})
public class CommerceOrderItemKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    private ExpandoQueryContributor _expandoQueryContributor;
    @Reference
    private QueryHelper _queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        String expandoAttributes;
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        this._queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "name", true);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "sku", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this._expandoQueryContributor.contribute(expandoAttributes, booleanQuery, new String[]{CommerceOrderItem.class.getName()}, searchContext);
        }
        if (Validator.isNotNull((String)keywords)) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                BooleanQueryImpl searchQuery = new BooleanQueryImpl();
                booleanQuery.add((Query)new TermQueryImpl("sku.1_10_ngram", keywords), BooleanClauseOccur.SHOULD);
                MultiMatchQuery multiMatchQuery = new MultiMatchQuery(searchContext.getKeywords());
                multiMatchQuery.addField("sku");
                multiMatchQuery.addField("sku.reverse");
                multiMatchQuery.setType(MultiMatchQuery.Type.PHRASE_PREFIX);
                booleanQuery.add((Query)multiMatchQuery, BooleanClauseOccur.SHOULD);
                if (searchContext.isAndSearch()) {
                    searchQuery.add((Query)booleanQuery, BooleanClauseOccur.MUST);
                } else {
                    searchQuery.add((Query)booleanQuery, BooleanClauseOccur.SHOULD);
                }
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }
}

