/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.commerce.address.CommerceAddressFormatter;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceShipmentItemLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceShipment"}, service={ModelDocumentContributor.class})
public class CommerceShipmentModelDocumentContributor
implements ModelDocumentContributor<CommerceShipment> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentModelDocumentContributor.class);
    @Reference
    private CommerceAddressFormatter _commerceAddressFormatter;
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceShipmentItemLocalService _commerceShipmentItemLocalService;

    public void contribute(Document document, CommerceShipment commerceShipment) {
        block3: {
            try {
                document.addNumberSortable("entryClassPK", Long.valueOf(commerceShipment.getCommerceShipmentId()));
                document.addKeyword("status", commerceShipment.getStatus());
                document.addKeyword("carrier", commerceShipment.getCarrier());
                document.addTextSortable("carrier", commerceShipment.getCarrier());
                document.addKeyword("commerceAccountId", commerceShipment.getCommerceAccountId());
                document.addKeyword("commerceAccountName", commerceShipment.getAccountEntryName(), true);
                CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceShipment.getGroupId());
                document.addKeyword("commerceChannelId", commerceChannel.getCommerceChannelId());
                document.addKeyword("commerceChannelName", commerceChannel.getName(), true);
                document.addKeyword("commerceOrderIds", this._getCommerceOrderIds(commerceShipment.getCommerceShipmentId()));
                document.addDateSortable("expectedDate", commerceShipment.getExpectedDate());
                document.addNumber("itemsCount", this._commerceShipmentItemLocalService.getCommerceShipmentItemsCount(commerceShipment.getCommerceShipmentId()));
                CommerceAddress commerceAddress = this._commerceAddressLocalService.fetchCommerceAddress(commerceShipment.getCommerceAddressId());
                if (commerceAddress != null) {
                    document.addKeyword("oneLineAddress", this._commerceAddressFormatter.getOneLineAddress(commerceAddress));
                }
                document.addKeyword("trackingNumber", commerceShipment.getTrackingNumber());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index commerce shipment " + commerceShipment.getCommerceShipmentId()), (Throwable)exception);
            }
        }
    }

    private String[] _getCommerceOrderIds(long commerceShipmentId) {
        HashSet<String> commerceOrderIds = new HashSet<String>();
        for (CommerceShipmentItem commerceShipmentItem : this._commerceShipmentItemLocalService.getCommerceShipmentItems(commerceShipmentId, -1, -1, null)) {
            CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.fetchCommerceOrderItem(commerceShipmentItem.getCommerceOrderItemId());
            if (commerceOrderItem == null) continue;
            commerceOrderIds.add(String.valueOf(commerceOrderItem.getCommerceOrderId()));
        }
        return commerceOrderIds.toArray(new String[0]);
    }
}

