/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.index.contributor;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={ModelDocumentContributor.class})
public class CommerceOrderItemModelDocumentContributor
implements ModelDocumentContributor<CommerceOrderItem> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemModelDocumentContributor.class);
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;

    public void contribute(Document document, CommerceOrderItem commerceOrderItem) {
        block3: {
            try {
                CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure;
                document.addNumber("entryClassPK", commerceOrderItem.getCommerceOrderItemId());
                document.addLocalizedKeyword("name", commerceOrderItem.getNameMap(), false, true);
                document.addKeyword("sku", commerceOrderItem.getSku(), true);
                document.addNumber("commerceOrderId", commerceOrderItem.getCommerceOrderId());
                document.addKeyword("CPDefinitionId", commerceOrderItem.getCPDefinitionId());
                document.addNumber("finalPrice", commerceOrderItem.getFinalPrice());
                document.addNumber("parentCommerceOrderItemId", commerceOrderItem.getParentCommerceOrderItemId());
                document.addNumber("quantity", commerceOrderItem.getQuantity());
                document.addNumber("unitPrice", commerceOrderItem.getUnitPrice());
                String unitOfMeasureKey = commerceOrderItem.getUnitOfMeasureKey();
                if (Validator.isNotNull((String)unitOfMeasureKey) && (cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureLocalService.fetchCPInstanceUnitOfMeasure(commerceOrderItem.getCPInstanceId(), unitOfMeasureKey)) != null) {
                    document.addLocalizedText("cpInstanceUnitOfMeasure", cpInstanceUnitOfMeasure.getNameMap(), true);
                }
                this._expandoBridgeIndexer.addAttributes(document, commerceOrderItem.getExpandoBridge());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to index commerce order item " + commerceOrderItem.getCommerceOrderItemId()), (Throwable)exception);
            }
        }
    }
}

