/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.validation.rule;

import com.liferay.commerce.internal.object.validation.rule.BaseObjectValidationRuleEngineImpl;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectValidationRuleEngine.class})
public class CommerceReturnItemQuantityObjectValidationRuleEngineImpl
extends BaseObjectValidationRuleEngineImpl {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;

    @Override
    protected String getObjectDefinitionName() {
        return "CommerceReturnItem";
    }

    @Override
    protected String getObjectFieldName() {
        return "quantity";
    }

    @Override
    protected boolean hasValidationCriteriaMet(Map<String, Object> inputObjects) {
        Map entryDTO = (Map)inputObjects.get("entryDTO");
        Map properties = (Map)entryDTO.get("properties");
        CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.fetchCommerceOrderItem(GetterUtil.getLong(properties.get("r_commerceOrderItemToCommerceReturnItems_commerceOrderItemId")));
        if (commerceOrderItem == null) {
            return false;
        }
        BigDecimal quantity = BigDecimal.valueOf(GetterUtil.getLong(properties.get("quantity")));
        return BigDecimalUtil.gte((BigDecimal)quantity, (BigDecimal)BigDecimal.ZERO) && BigDecimalUtil.lte((BigDecimal)quantity, (BigDecimal)commerceOrderItem.getQuantity());
    }
}

