/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.notification.term.evaluator;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SalesAgentNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    private final CommerceOrderLocalService _commerceOrderLocalService;
    private final ObjectDefinition _objectDefinition;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleLocalService _roleLocalService;
    private final UserLocalService _userLocalService;

    public SalesAgentNotificationTermEvaluator(ModelResourcePermission<AccountEntry> accountEntryModelResourcePermission, CommerceOrderLocalService commerceOrderLocalService, ObjectDefinition objectDefinition, PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, UserLocalService userLocalService) {
        this._accountEntryModelResourcePermission = accountEntryModelResourcePermission;
        this._commerceOrderLocalService = commerceOrderLocalService;
        this._objectDefinition = objectDefinition;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleLocalService = roleLocalService;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map && termName.equals("[%SALES_AGENT%]") && "CommerceOrder".equalsIgnoreCase(this._objectDefinition.getShortName()))) {
            return termName;
        }
        Map termValues = (Map)object;
        return StringUtil.merge(this._getEmailAddresses(termValues));
    }

    private List<String> _getEmailAddresses(Map<String, Object> termValues) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(GetterUtil.getLong((Object)termValues.get("id")));
        Role salesAgentRole = this._roleLocalService.getRole(commerceOrder.getCompanyId(), "Sales Agent");
        return TransformUtil.transform((Collection)this._userLocalService.getRoleUsers(salesAgentRole.getRoleId()), user -> {
            if (this._accountEntryModelResourcePermission.contains(this._permissionCheckerFactory.create(user), commerceOrder.getCommerceAccountId(), "VIEW")) {
                return user.getEmailAddress();
            }
            return null;
        });
    }
}

