/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.events;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.commerce.configuration.CommerceAccountServiceConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=login.events.post"}, service={LifecycleAction.class})
public class LoginPostAction
extends Action {
    private static final String _COOKIE_NAME_PREFIX_ACCOUNT_ENTRY = AccountEntry.class.getName() + "#";
    private static final String _COOKIE_NAME_PREFIX_COMMERCE_ORDER = CommerceOrder.class.getName() + "#";
    private static final Log _log = LogFactoryUtil.getLog(LoginPostAction.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block2: {
            try {
                this._addDefaultAccountRoles(httpServletRequest);
                this._run(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _addBusinessAccountRoles(AccountEntry accountEntry, User user) {
        block2: {
            try {
                Role accountAdmnistratorRole = this._roleLocalService.getRole(user.getCompanyId(), "Account Administrator");
                Role accountBuyerRole = this._roleLocalService.getRole(user.getCompanyId(), "Buyer");
                AccountRole accountAdmnistratorAccountRole = this._accountRoleLocalService.getAccountRoleByRoleId(accountAdmnistratorRole.getRoleId());
                AccountRole accountBuyerAccountRole = this._accountRoleLocalService.getAccountRoleByRoleId(accountBuyerRole.getRoleId());
                this._accountRoleLocalService.associateUser(accountEntry.getAccountEntryId(), new long[]{accountAdmnistratorAccountRole.getAccountRoleId(), accountBuyerAccountRole.getAccountRoleId()}, user.getUserId());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private void _addDefaultAccountRoles(HttpServletRequest httpServletRequest) throws Exception {
        CommerceAccountServiceConfiguration commerceAccountServiceConfiguration = (CommerceAccountServiceConfiguration)this._configurationProvider.getSystemConfiguration(CommerceAccountServiceConfiguration.class);
        if (commerceAccountServiceConfiguration.applyDefaultRoleToExistingUsers()) {
            this._commerceAccountHelper.addDefaultRoles(this._portal.getUserId(httpServletRequest));
        }
    }

    private void _associateAccountEntryToCommerceOrder(AccountEntry accountEntry, long commerceChannelGroupId, CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, long userId) throws PortalException {
        CommerceOrder userCommerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(accountEntry.getAccountEntryId(), commerceChannelGroupId, userId, 2);
        if (userCommerceOrder != null) {
            CommerceContext commerceContext = this._commerceContextFactory.create(accountEntry.getAccountEntryId(), commerceChannelGroupId, null, userCommerceOrder.getCommerceOrderId(), this._portal.getCompanyId(httpServletRequest));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest)));
            this._commerceOrderLocalService.mergeGuestCommerceOrder(userId, commerceOrder.getCommerceOrderId(), userCommerceOrder.getCommerceOrderId(), commerceContext, ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest));
        } else {
            this._commerceOrderLocalService.updateAccount(commerceOrder.getCommerceOrderId(), userId, accountEntry.getAccountEntryId());
        }
    }

    private AccountEntry _createAccountEntry(String name, String type, User user) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setUserId(user.getUserId());
        AccountEntry accountEntry = this._accountEntryLocalService.addAccountEntry("", user.getUserId(), 0L, name, null, null, user.getEmailAddress(), null, "", type, 0, serviceContext);
        this._accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntry.getAccountEntryId(), user.getUserId());
        if (type.equals("business")) {
            this._addBusinessAccountRoles(accountEntry, user);
        }
        return accountEntry;
    }

    private AccountEntry _getAccountEntry(int commerceSiteType, long userId) {
        AccountEntry accountEntry;
        block6: {
            accountEntry = null;
            String[] accountEntryTypes = new String[]{"person"};
            if (commerceSiteType == 1) {
                accountEntryTypes = new String[]{"business"};
            } else if (commerceSiteType == 2) {
                accountEntryTypes = new String[]{"business", "person"};
            }
            try {
                List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, null, null, accountEntryTypes, -1, -1);
                if (accountEntries.size() != 1) {
                    return null;
                }
                accountEntry = (AccountEntry)accountEntries.get(0);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)portalException);
            }
        }
        return accountEntry;
    }

    private long _getCommerceChannelGroupId(String key) {
        return GetterUtil.getLong((String)StringUtil.extractLast((String)key, (String)"#"));
    }

    private CommerceOrder _getCommerceOrderByUuidAndGroupId(long commerceChannelGroupId, String commerceOrderUuid) {
        try {
            return this._commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannelGroupId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private Map<String, String> _parseAccountEntryInformation(int commerceSiteType, String cookieValue, User user) {
        String[] keyValues;
        String accountEntryName = user.getFullName();
        String accountEntryType = "person";
        String userEmailAddress = user.getEmailAddress();
        for (String keyValue : keyValues = cookieValue.split("#")) {
            if (keyValue.startsWith("accountEntryName=")) {
                accountEntryName = StringUtil.extractLast((String)keyValue, (String)"=");
                continue;
            }
            if (keyValue.startsWith("accountEntryType=")) {
                String value = StringUtil.extractLast((String)keyValue, (String)"=");
                if (!value.equals("business") && !value.equals("person")) continue;
                accountEntryType = value;
                continue;
            }
            if (!keyValue.startsWith("userEmailAddress=")) continue;
            userEmailAddress = StringUtil.extractLast((String)keyValue, (String)"=");
        }
        if (commerceSiteType == 1) {
            accountEntryType = "business";
        } else if (commerceSiteType == 0) {
            accountEntryType = "person";
        }
        return HashMapBuilder.put((Object)"accountEntryName", (Object)accountEntryName).put((Object)"accountEntryType", (Object)accountEntryType).put((Object)"userEmailAddress", (Object)userEmailAddress).build();
    }

    private void _prepareOrderForCheckout(CommerceOrder commerceOrder, HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("COMMERCE_ORDER", (Object)commerceOrder);
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = originalHttpServletRequest.getSession();
        httpSession.setAttribute("#immediate-checkout", (Object)Boolean.TRUE);
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies == null) {
            return;
        }
        AccountEntry accountEntry = null;
        CommerceOrder commerceOrder = null;
        boolean immediateCheckout = false;
        User user = this._portal.getUser(httpServletRequest);
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (cookieName.startsWith(_COOKIE_NAME_PREFIX_ACCOUNT_ENTRY)) {
                Map<String, String> accountEntryInformation = this._parseAccountEntryInformation(this._commerceAccountHelper.getCommerceSiteType(this._getCommerceChannelGroupId(cookieName)), cookie.getValue(), user);
                String userEmailAddress = accountEntryInformation.get("userEmailAddress");
                if (userEmailAddress.equals(user.getEmailAddress())) {
                    String accountEntryName = accountEntryInformation.get("accountEntryName");
                    String accountEntryType = accountEntryInformation.get("accountEntryType");
                    accountEntry = this._createAccountEntry(accountEntryName, accountEntryType, user);
                }
                CookiesManagerUtil.deleteCookies((String)cookie.getDomain(), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{cookieName});
                continue;
            }
            if (!cookieName.startsWith(_COOKIE_NAME_PREFIX_COMMERCE_ORDER)) continue;
            long commerceChannelGroupId = this._getCommerceChannelGroupId(cookieName);
            String commerceOrderUuid = cookie.getValue();
            if (commerceOrderUuid.endsWith("#immediate-checkout")) {
                commerceOrderUuid = StringUtil.removeSubstring((String)commerceOrderUuid, (String)"#immediate-checkout");
                immediateCheckout = true;
            }
            if ((commerceOrder = this._getCommerceOrderByUuidAndGroupId(commerceChannelGroupId, commerceOrderUuid)) == null || !immediateCheckout) continue;
            this._prepareOrderForCheckout(commerceOrder, httpServletRequest);
        }
        if (accountEntry == null && commerceOrder != null) {
            accountEntry = this._getAccountEntry(this._commerceAccountHelper.getCommerceSiteType(commerceOrder.getGroupId()), user.getUserId());
            if (accountEntry == null) {
                commerceOrder.setUserId(user.getUserId());
                commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
                HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
                HttpSession httpSession = originalHttpServletRequest.getSession();
                httpSession.setAttribute("COMMERCE_ORDER_ON_ACCOUNT_SELECTION", (Object)commerceOrder);
                httpSession.setAttribute(_COOKIE_NAME_PREFIX_COMMERCE_ORDER + commerceOrder.getGroupId(), (Object)commerceOrder.getUuid());
            } else {
                CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{_COOKIE_NAME_PREFIX_COMMERCE_ORDER + commerceOrder.getGroupId()});
            }
        }
        if (accountEntry != null && commerceOrder != null) {
            this._associateAccountEntryToCommerceOrder(accountEntry, commerceOrder.getGroupId(), commerceOrder, httpServletRequest, user.getUserId());
        }
    }
}

