/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceOrderNoteContentException;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.base.CommerceOrderNoteLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceOrderPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CommerceOrderNote"}, service={AopService.class})
public class CommerceOrderNoteLocalServiceImpl
extends CommerceOrderNoteLocalServiceBaseImpl {
    @Reference
    private CommerceOrderPersistence _commerceOrderPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceOrderNote addCommerceOrderNote(long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceOrderNote(null, commerceOrderId, content, restricted, serviceContext);
    }

    public CommerceOrderNote addCommerceOrderNote(String externalReferenceCode, long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        this._validate(content);
        long commerceOrderNoteId = this.counterLocalService.increment();
        CommerceOrderNote commerceOrderNote = this.commerceOrderNotePersistence.create(commerceOrderNoteId);
        commerceOrderNote.setExternalReferenceCode(externalReferenceCode);
        commerceOrderNote.setGroupId(commerceOrder.getGroupId());
        commerceOrderNote.setCompanyId(user.getCompanyId());
        commerceOrderNote.setUserId(user.getUserId());
        commerceOrderNote.setUserName(user.getFullName());
        commerceOrderNote.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderNote.setContent(content);
        commerceOrderNote.setRestricted(restricted);
        return (CommerceOrderNote)this.commerceOrderNotePersistence.update((BaseModel)commerceOrderNote);
    }

    public CommerceOrderNote addOrUpdateCommerceOrderNote(String externalReferenceCode, long commerceOrderNoteId, long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        CommerceOrderNote commerceOrderNote = commerceOrderNoteId > 0L ? this.getCommerceOrderNote(commerceOrderNoteId) : this.commerceOrderNotePersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId());
        if (commerceOrderNote != null) {
            return this.updateCommerceOrderNote(externalReferenceCode, commerceOrderNote.getCommerceOrderNoteId(), content, restricted);
        }
        return this.addCommerceOrderNote(externalReferenceCode, commerceOrderId, content, restricted, serviceContext);
    }

    public void deleteCommerceOrderNotes(long commerceOrderId) {
        this.commerceOrderNotePersistence.removeByCommerceOrderId(commerceOrderId);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, boolean restricted) {
        return this.commerceOrderNotePersistence.findByC_R(commerceOrderId, restricted);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, boolean restricted, int start, int end) {
        return this.commerceOrderNotePersistence.findByC_R(commerceOrderId, restricted, start, end);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, int start, int end) {
        return this.commerceOrderNotePersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId) {
        return this.commerceOrderNotePersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId, boolean restricted) {
        return this.commerceOrderNotePersistence.countByC_R(commerceOrderId, restricted);
    }

    public CommerceOrderNote updateCommerceOrderNote(long commerceOrderNoteId, String content, boolean restricted) throws PortalException {
        return this.updateCommerceOrderNote(null, commerceOrderNoteId, content, restricted);
    }

    public CommerceOrderNote updateCommerceOrderNote(String externalReferenceCode, long commerceOrderNoteId, String content, boolean restricted) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNotePersistence.findByPrimaryKey(commerceOrderNoteId);
        this._validate(content);
        if (Validator.isNull((String)commerceOrderNote.getExternalReferenceCode())) {
            commerceOrderNote.setExternalReferenceCode(externalReferenceCode);
        }
        commerceOrderNote.setContent(content);
        commerceOrderNote.setRestricted(restricted);
        return (CommerceOrderNote)this.commerceOrderNotePersistence.update((BaseModel)commerceOrderNote);
    }

    private void _validate(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new CommerceOrderNoteContentException();
        }
    }
}

