/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.NoSuchAvailabilityEstimateException;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.service.base.CPDAvailabilityEstimateLocalServiceBaseImpl;
import com.liferay.commerce.service.persistence.CommerceAvailabilityEstimatePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CPDAvailabilityEstimate"}, service={AopService.class})
public class CPDAvailabilityEstimateLocalServiceImpl
extends CPDAvailabilityEstimateLocalServiceBaseImpl {
    @Reference
    private CommerceAvailabilityEstimatePersistence _commerceAvailabilityEstimatePersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    @SystemEvent(type=1)
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(CPDAvailabilityEstimate cpdAvailabilityEstimate) {
        return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.remove((BaseModel)cpdAvailabilityEstimate);
    }

    @Override
    public CPDAvailabilityEstimate deleteCPDAvailabilityEstimate(long cpdAvailabilityEstimateId) throws PortalException {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
        return this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
    }

    public void deleteCPDAvailabilityEstimateByCProductId(long cProductId) {
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimateLocalService.fetchCPDAvailabilityEstimateByCProductId(cProductId);
        if (cpdAvailabilityEstimate != null) {
            this.cpdAvailabilityEstimateLocalService.deleteCPDAvailabilityEstimate(cpdAvailabilityEstimate);
        }
    }

    public void deleteCPDAvailabilityEstimates(long commerceAvailabilityEstimateId) {
        this.cpdAvailabilityEstimatePersistence.removeByCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
    }

    public CPDAvailabilityEstimate fetchCPDAvailabilityEstimateByCProductId(long cProductId) {
        return this.cpdAvailabilityEstimatePersistence.fetchByCProductId(cProductId);
    }

    public CPDAvailabilityEstimate updateCPDAvailabilityEstimateByCProductId(long userId, long cpdAvailabilityEstimateId, long cProductId, long commerceAvailabilityEstimateId) throws PortalException {
        this._validate(commerceAvailabilityEstimateId);
        if (cpdAvailabilityEstimateId > 0L) {
            CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.findByPrimaryKey(cpdAvailabilityEstimateId);
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.fetchCPDAvailabilityEstimateByCProductId(cProductId);
        if (cpdAvailabilityEstimate != null) {
            cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
            return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
        }
        return this._addCPDAvailabilityEstimateByCProductId(userId, cProductId, commerceAvailabilityEstimateId);
    }

    private CPDAvailabilityEstimate _addCPDAvailabilityEstimateByCProductId(long userId, long cProductId, long commerceAvailabilityEstimateId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long cpdAvailabilityEstimateId = this.counterLocalService.increment();
        CPDAvailabilityEstimate cpdAvailabilityEstimate = this.cpdAvailabilityEstimatePersistence.create(cpdAvailabilityEstimateId);
        cpdAvailabilityEstimate.setCompanyId(user.getCompanyId());
        cpdAvailabilityEstimate.setUserId(user.getUserId());
        cpdAvailabilityEstimate.setUserName(user.getFullName());
        cpdAvailabilityEstimate.setCommerceAvailabilityEstimateId(commerceAvailabilityEstimateId);
        cpdAvailabilityEstimate.setCProductId(cProductId);
        return (CPDAvailabilityEstimate)this.cpdAvailabilityEstimatePersistence.update((BaseModel)cpdAvailabilityEstimate);
    }

    private void _validate(long commerceAvailabilityEstimateId) throws PortalException {
        CommerceAvailabilityEstimate commerceAvailabilityEstimate;
        if (commerceAvailabilityEstimateId > 0L && (commerceAvailabilityEstimate = this._commerceAvailabilityEstimatePersistence.fetchByPrimaryKey(commerceAvailabilityEstimateId)) == null) {
            throw new NoSuchAvailabilityEstimateException();
        }
    }
}

