/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.model.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactoryUtil;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalServiceUtil;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.model.impl.CommerceOrderBaseImpl;
import com.liferay.commerce.service.CommerceAddressLocalServiceUtil;
import com.liferay.commerce.service.CommerceOrderItemLocalServiceUtil;
import com.liferay.commerce.service.CommerceShippingMethodLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class CommerceOrderImpl
extends CommerceOrderBaseImpl {
    public AccountEntry getAccountEntry() throws PortalException {
        if (this.getCommerceAccountId() == -1L) {
            return AccountEntryLocalServiceUtil.getGuestAccountEntry((long)this.getCompanyId());
        }
        return AccountEntryLocalServiceUtil.getAccountEntry((long)this.getCommerceAccountId());
    }

    public List<FileEntry> getAttachmentFileEntries(int start, int end) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository();
        if (localRepository == null) {
            return Collections.emptyList();
        }
        Folder folder = this.getFolder(localRepository);
        if (folder == null) {
            return Collections.emptyList();
        }
        return localRepository.getFileEntries(folder.getFolderId(), start, end, null);
    }

    public int getAttachmentFileEntriesCount() throws PortalException {
        LocalRepository localRepository = this.getLocalRepository();
        if (localRepository == null) {
            return 0;
        }
        Folder folder = this.getFolder(localRepository);
        if (folder == null) {
            return 0;
        }
        return localRepository.getFileEntriesCount(folder.getFolderId());
    }

    public CommerceAddress getBillingAddress() throws PortalException {
        long billingAddressId = this.getBillingAddressId();
        if (billingAddressId <= 0L) {
            return null;
        }
        return CommerceAddressLocalServiceUtil.fetchCommerceAddress((long)this.getBillingAddressId());
    }

    public String getCommerceAccountName() throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry();
        if (accountEntry.isPersonalAccount()) {
            return accountEntry.getUserName();
        }
        return accountEntry.getName();
    }

    public CommerceCurrency getCommerceCurrency() throws PortalException {
        return CommerceCurrencyLocalServiceUtil.getCommerceCurrency((long)this.getCompanyId(), (String)this.getCommerceCurrencyCode());
    }

    public List<CommerceOrderItem> getCommerceOrderItems() {
        return CommerceOrderItemLocalServiceUtil.getCommerceOrderItems((long)this.getCommerceOrderId(), (int)-1, (int)-1);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long cpInstanceId) {
        return CommerceOrderItemLocalServiceUtil.getCommerceOrderItems((long)this.getCommerceOrderId(), (long)cpInstanceId, (int)-1, (int)-1);
    }

    public int getCommerceOrderItemsCount(long cpInstanceId) {
        return CommerceOrderItemLocalServiceUtil.getCommerceOrderItemsCount((long)this.getCommerceOrderId(), (long)cpInstanceId);
    }

    public CommerceShippingMethod getCommerceShippingMethod() throws PortalException {
        long commerceShippingMethodId = this.getCommerceShippingMethodId();
        if (commerceShippingMethodId <= 0L) {
            return null;
        }
        return CommerceShippingMethodLocalServiceUtil.getCommerceShippingMethod((long)commerceShippingMethodId);
    }

    public List<Long> getCustomerCommerceOrderIds() {
        return CommerceOrderItemLocalServiceUtil.getCustomerCommerceOrderIds((long)this.getCommerceOrderId());
    }

    public int getCustomerCommerceOrderIdsCount() {
        return CommerceOrderItemLocalServiceUtil.getCustomerCommerceOrderIdsCount((long)this.getCommerceOrderId());
    }

    public Folder getFolder(LocalRepository localRepository) {
        if (localRepository == null) {
            return null;
        }
        return localRepository.fetchFolderByExternalReferenceCode("order-" + this.getCommerceOrderId());
    }

    public LocalRepository getLocalRepository() throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)this.getGroupId(), (String)"com.liferay.commerce.order");
        if (repository == null) {
            return null;
        }
        return RepositoryProviderUtil.getLocalRepository((long)repository.getRepositoryId());
    }

    public long getScopeGroupId() throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry();
        if (accountEntry.isBusinessAccount()) {
            return accountEntry.getAccountEntryGroupId();
        }
        return this.getGroupId();
    }

    public CommerceAddress getShippingAddress() throws PortalException {
        long shippingAddressId = this.getShippingAddressId();
        if (shippingAddressId <= 0L) {
            return null;
        }
        return CommerceAddressLocalServiceUtil.fetchCommerceAddress((long)this.getShippingAddressId());
    }

    public CommerceMoney getShippingMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getShippingAmount());
    }

    public CommerceMoney getShippingWithTaxAmountMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getShippingWithTaxAmount());
    }

    public CommerceMoney getSubtotalMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getSubtotal());
    }

    public CommerceMoney getSubtotalWithTaxAmountMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getSubtotalWithTaxAmount());
    }

    public List<Long> getSupplierCommerceOrderIds() {
        return CommerceOrderItemLocalServiceUtil.getSupplierCommerceOrderIds((long)this.getCommerceOrderId());
    }

    public int getSupplierCommerceOrderIdsCount() {
        return CommerceOrderItemLocalServiceUtil.getSupplierCommerceOrderIdsCount((long)this.getCommerceOrderId());
    }

    public CommerceMoney getTotalMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getTotal());
    }

    public CommerceMoney getTotalWithTaxAmountMoney() throws PortalException {
        return CommerceMoneyFactoryUtil.create((CommerceCurrency)this.getCommerceCurrency(), (BigDecimal)this.getTotalWithTaxAmount());
    }

    public boolean isB2B() throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry();
        return accountEntry.isBusinessAccount();
    }

    public boolean isEmpty() {
        int count = CommerceOrderItemLocalServiceUtil.getCommerceOrderItemsCount((long)this.getCommerceOrderId());
        return count <= 0;
    }

    public boolean isGuestOrder() throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry();
        return accountEntry.isGuestAccount();
    }

    public boolean isOpen() {
        return this.getOrderStatus() == 2;
    }

    public boolean isQuote() {
        return this.getOrderStatus() == 22 || this.getOrderStatus() == 21;
    }

    public boolean isSubscription() {
        return this.getOrderStatus() == 9;
    }

    public boolean isSubscriptionOrder() {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems();
        if (commerceOrderItems.isEmpty()) {
            return false;
        }
        CommerceOrderItem commerceOrderItem = commerceOrderItems.get(0);
        return commerceOrderItem.isSubscription();
    }

    public void setShippingDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal shippingDiscountAmount = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal shippingDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            shippingDiscountAmount = discountAmountCommerceMoney.getPrice();
            if (percentages != null && percentages.length > 0) {
                shippingDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                shippingDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                shippingDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                shippingDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setShippingDiscountAmount(shippingDiscountAmount);
        this.setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
        this.setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
        this.setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
        this.setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
    }

    public void setSubtotalDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal subtotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal subtotalDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            subtotalDiscountAmount = discountAmountCommerceMoney.getPrice();
            if (percentages != null && percentages.length > 0) {
                subtotalDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                subtotalDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                subtotalDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                subtotalDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setSubtotalDiscountAmount(subtotalDiscountAmount);
        this.setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
        this.setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
        this.setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
        this.setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
    }

    public void setTotalDiscounts(CommerceDiscountValue commerceDiscountValue) {
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal totalDiscountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            totalDiscountAmount = discountAmountCommerceMoney.getPrice();
            if (percentages != null && percentages.length > 0) {
                totalDiscountPercentageLevel1 = percentages[0];
            }
            if (percentages != null && percentages.length > 1) {
                totalDiscountPercentageLevel1 = percentages[1];
            }
            if (percentages != null && percentages.length > 2) {
                totalDiscountPercentageLevel1 = percentages[2];
            }
            if (percentages != null && percentages.length > 3) {
                totalDiscountPercentageLevel1 = percentages[3];
            }
        }
        this.setTotalDiscountAmount(totalDiscountAmount);
        this.setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
        this.setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
        this.setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
        this.setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
    }
}

