/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_2_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CommerceAccountUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAccountUpgradeProcess.class);
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    private final EmailAddressLocalService _emailAddressLocalService;
    private final OrganizationLocalService _organizationLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceAccountUpgradeProcess(AccountEntryLocalService accountEntryLocalService, AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, AccountEntryUserRelLocalService accountEntryUserRelLocalService, EmailAddressLocalService emailAddressLocalService, OrganizationLocalService organizationLocalService, RoleLocalService roleLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._accountEntryUserRelLocalService = accountEntryUserRelLocalService;
        this._emailAddressLocalService = emailAddressLocalService;
        this._organizationLocalService = organizationLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        long organizationId;
        Object resultSet;
        ArrayList<Long> queuedOrganizationIds = new ArrayList<Long>();
        try (Statement s = this.connection.createStatement(1003, 1007);){
            resultSet = s.executeQuery("select organizationId from Organization_ where type_ = 'account'");
            try {
                while (resultSet.next()) {
                    organizationId = resultSet.getLong("organizationId");
                    queuedOrganizationIds.add(organizationId);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        while (!queuedOrganizationIds.isEmpty()) {
            ArrayList organizationIds = new ArrayList(queuedOrganizationIds);
            queuedOrganizationIds.clear();
            resultSet = organizationIds.iterator();
            while (resultSet.hasNext()) {
                organizationId = (Long)resultSet.next();
                Organization organization = this._organizationLocalService.getOrganization(organizationId);
                long parentCommerceAccountId = this._getParentCommerceAccountId(organization.getParentOrganizationId());
                if (parentCommerceAccountId < 0L) {
                    queuedOrganizationIds.add(organizationId);
                    continue;
                }
                this._addCommerceAccount(organization, parentCommerceAccountId);
            }
            if (queuedOrganizationIds.size() < organizationIds.size()) continue;
            _log.error((Object)"Organization data is missing, so accounts cannot be correctly created. Aborting data transformation.");
            String organizationIdsString = ListUtil.toString(organizationIds, (String)"", (String)", ");
            _log.error((Object)("The following organizations are orphaned: " + organizationIdsString));
            return;
        }
    }

    private void _addCommerceAccount(Organization organization, long parentCommerceAccountId) throws Exception {
        String email = this._getOrganizationEmailAddress(organization);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(organization.getCompanyId());
        serviceContext.setUserId(organization.getUserId());
        AccountEntry accountEntry = AccountEntryLocalServiceUtil.addAccountEntry((long)organization.getUserId(), (long)parentCommerceAccountId, (String)organization.getName(), null, null, (String)email, null, (String)"", (String)"business", (int)0, (ServiceContext)serviceContext);
        if (organization.getExternalReferenceCode() != null) {
            accountEntry.setExternalReferenceCode(organization.getExternalReferenceCode());
            accountEntry = this._accountEntryLocalService.updateAccountEntry(accountEntry);
        }
        Role role = this._roleLocalService.getRole(serviceContext.getCompanyId(), "Account Administrator");
        this._accountEntryUserRelLocalService.inviteUser(accountEntry.getAccountEntryId(), new long[]{role.getRoleId()}, email, serviceContext.fetchUser(), serviceContext);
        this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(accountEntry.getAccountEntryId(), organization.getOrganizationId());
    }

    private String _getOrganizationEmailAddress(Organization organization) {
        List emailAddresses = this._emailAddressLocalService.getEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        for (EmailAddress emailAddress : emailAddresses) {
            if (!emailAddress.isPrimary()) continue;
            return emailAddress.getAddress();
        }
        if (!emailAddresses.isEmpty()) {
            EmailAddress emailAddress = (EmailAddress)emailAddresses.get(0);
            return emailAddress.getAddress();
        }
        return "";
    }

    private long _getParentCommerceAccountId(long parentOrganizationId) throws Exception {
        if (parentOrganizationId == 0L) {
            return 0L;
        }
        Organization organization = this._organizationLocalService.getOrganization(parentOrganizationId);
        if (!Objects.equals(organization.getType(), "account")) {
            return 0L;
        }
        String sql = "select commerceAccountId from CommerceAccountOrganizationRel where organizationId = " + parentOrganizationId;
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(sql);){
            if (resultSet.next()) {
                long l = resultSet.getLong("commerceAccountId");
                return l;
            }
        }
        return -1L;
    }
}

