/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v11_5_3;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.util.Arrays;
import java.util.List;

public class CommercePermissionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommercePermissionUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommercePermissionUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        List<String> actionIds = Arrays.asList("MANAGE_COMMERCE_ORDER_MULTISHIPPING");
        this._resourceActionLocalService.checkResourceActions("com.liferay.commerce.order", actionIds);
        this._companyLocalService.forEachCompanyId(companyId -> {
            try {
                this._updateCommerceAccountRoles((long)companyId, "Account Administrator", "com.liferay.commerce.order", actionIds);
                this._updateCommerceAccountRoles((long)companyId, "Buyer", "com.liferay.commerce.order", actionIds);
                this._updateCommerceAccountRoles((long)companyId, "Order Manager", "com.liferay.commerce.order", actionIds);
                this._updateRegularRoles((long)companyId, "Sales Agent", "com.liferay.commerce.order", actionIds);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private void _addResourcePermission(String actionId, long companyId, String primKey, String resourceName, long roleId, int scope) throws PortalException {
        if (!this._resourcePermissionLocalService.hasResourcePermission(companyId, resourceName, scope, primKey, roleId, actionId)) {
            this._resourcePermissionLocalService.addResourcePermission(companyId, resourceName, scope, primKey, roleId, actionId);
        }
    }

    private void _updateCommerceAccountRoles(long companyId, String name, String resourceName, List<String> actionIds) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            return;
        }
        for (String actionId : actionIds) {
            this._addResourcePermission(actionId, companyId, String.valueOf(0L), resourceName, role.getRoleId(), 3);
        }
    }

    private void _updateRegularRoles(long companyId, String name, String resourceName, List<String> actionIds) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            return;
        }
        for (String actionId : actionIds) {
            this._addResourcePermission(actionId, companyId, String.valueOf(companyId), resourceName, role.getRoleId(), 1);
        }
    }
}

