/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchPermissionFilterContributor.class})
public class CommerceOrderSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderSearchPermissionFilterContributor.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(CommerceOrder.class.getName())) {
            return;
        }
        try {
            TermsFilter groupsTermsFilter = new TermsFilter("groupId");
            for (long groupId : groupIds) {
                if (!this._hasRoleAccountSupplier(permissionChecker, groupId)) continue;
                groupsTermsFilter.addValue(String.valueOf(groupId));
            }
            if (!groupsTermsFilter.isEmpty()) {
                booleanFilter.add((Filter)groupsTermsFilter, BooleanClauseOccur.SHOULD);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private boolean _hasRoleAccountSupplier(PermissionChecker permissionChecker, long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelByGroupClassPK(groupId);
        if (commerceChannel != null && commerceChannel.getAccountEntryId() == 0L) {
            return false;
        }
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), "", new String[]{"supplier"}, -1, -1);
        for (AccountEntry accountEntry : accountEntries) {
            if (accountEntry.getAccountEntryId() != commerceChannel.getAccountEntryId() || !this._userGroupRoleLocalService.hasUserGroupRole(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId(), "Account Supplier")) continue;
            return true;
        }
        return false;
    }
}

