/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.content.contributor.name=availabilityEstimate"}, service={CPContentContributor.class})
public class AvailabilityEstimateCPContentContributor
implements CPContentContributor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public String getName() {
        return "availabilityEstimate";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory;
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine;
        BigDecimal stockQuantity;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
        if (commerceChannel == null) {
            return jsonObject;
        }
        boolean available = false;
        long accountEntryId = -1L;
        CommerceContext commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        if (accountEntry != null) {
            accountEntryId = accountEntry.getAccountEntryId();
        }
        if (BigDecimalUtil.gt((BigDecimal)(stockQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), accountEntryId, cpInstance.getGroupId(), commerceChannel.getGroupId(), cpInstance.getSku(), "")), (BigDecimal)(cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId()))).getMinStockQuantity(commerceContext.getCPConfigurationListId(cpDefinitionInventory.getGroupId()), cpInstance))) {
            available = true;
        }
        if (!available) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            jsonObject.put("availabilityEstimate", this._getAvailabilityEstimateLabel(themeDisplay.getLocale(), cpDefinitionInventoryEngine.getAvailabilityEstimate(commerceContext.getCPConfigurationListId(cpInstance.getGroupId()), cpInstance, themeDisplay.getLocale())));
        }
        return jsonObject;
    }

    private String _getAvailabilityEstimateLabel(Locale locale, String availabilityEstimate) {
        if (Validator.isNull((String)availabilityEstimate)) {
            return "";
        }
        return this._language.format(locale, "product-will-be-available-in-x", (Object)availabilityEstimate);
    }
}

