/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ObjectCommerceDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    private static final Log _log = LogFactoryUtil.getLog(ObjectCommerceDefinitionTermContributor.class);
    private final long _objectDefinitionId;
    private final Map<String, Long> _objectFieldIds = HashMapBuilder.put((Object)"[%OBJECT_ENTRY_CREATOR%]", (Object)0L).put((Object)"[%OBJECT_ENTRY_ID%]", (Object)0L).build();
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final UserLocalService _userLocalService;

    public ObjectCommerceDefinitionTermContributor(long objectDefinitionId, ObjectFieldLocalService objectFieldLocalService, UserLocalService userLocalService) {
        this._objectDefinitionId = objectDefinitionId;
        this._objectFieldLocalService = objectFieldLocalService;
        this._userLocalService = userLocalService;
        List objectFields = objectFieldLocalService.getObjectFields(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            this._objectFieldIds.put(StringBundler.concat((String[])new String[]{"[%", StringUtil.toUpperCase((String)StringUtil.replace((String)objectField.getName(), (char)' ', (char)'_')), "%]"}), objectField.getObjectFieldId());
        }
    }

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        if (!(object instanceof ObjectEntry)) {
            return term;
        }
        ObjectEntry objectEntry = (ObjectEntry)object;
        if (term.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            User user = this._userLocalService.getUser(objectEntry.getUserId());
            return user.getFullName(true, true);
        }
        if (term.equals("[%OBJECT_ENTRY_ID%]")) {
            return String.valueOf(objectEntry.getObjectEntryId());
        }
        long objectEntryId = this._objectFieldIds.get(term);
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectEntryId);
        if (objectField == null) {
            return term;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing term for object field " + objectField.getName()));
        }
        Map values = objectEntry.getValues();
        return String.valueOf(values.get(objectField.getName()));
    }

    public String getLabel(String term, Locale locale) {
        if (term.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            return LanguageUtil.get((Locale)locale, (String)"creator");
        }
        if (term.equals("[%OBJECT_ENTRY_ID%]")) {
            return LanguageUtil.get((Locale)locale, (String)"id");
        }
        long objectFieldId = this._objectFieldIds.get(term);
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldId);
        return objectField.getLabel(locale);
    }

    public List<String> getTerms() {
        return new ArrayList<String>(this._objectFieldIds.keySet());
    }
}

