/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.internal.order.comparator.CommerceOrderStatusPriorityComparator;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceOrderStatusRegistry.class})
public class CommerceOrderStatusRegistryImpl
implements CommerceOrderStatusRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderStatusRegistryImpl.class);
    private final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceOrderStatus>> _commerceOrderStatusServiceWrapperOrderComparator = new CommerceOrderStatusPriorityComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceOrderStatus>> _serviceTrackerMap;

    public CommerceOrderStatus getCommerceOrderStatus(int key) {
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderStatusServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)String.valueOf(key));
        if (commerceOrderStatusServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No CommerceOrderStatus registered with key " + key));
            }
            return null;
        }
        return (CommerceOrderStatus)commerceOrderStatusServiceWrapper.getService();
    }

    public List<CommerceOrderStatus> getCommerceOrderStatuses() {
        return this.getCommerceOrderStatuses(null);
    }

    public List<CommerceOrderStatus> getCommerceOrderStatuses(CommerceOrder commerceOrder) {
        ArrayList<CommerceOrderStatus> commerceOrderStatuses = new ArrayList<CommerceOrderStatus>();
        List commerceOrderStatusServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceOrderStatusServiceWrappers, this._commerceOrderStatusServiceWrapperOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceOrderStatusServiceWrapper : commerceOrderStatusServiceWrappers) {
            CommerceOrderStatus commerceOrderStatus = (CommerceOrderStatus)commerceOrderStatusServiceWrapper.getService();
            try {
                if (commerceOrder != null && !commerceOrderStatus.isEnabled(commerceOrder)) continue;
                commerceOrderStatuses.add((CommerceOrderStatus)commerceOrderStatusServiceWrapper.getService());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return Collections.unmodifiableList(commerceOrderStatuses);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceOrderStatus.class, (String)"commerce.order.status.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

